package com.bringspring.system.base.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.exception.DataException;
import com.bringspring.system.base.entity.DataInterfaceEntity;
import com.bringspring.system.base.model.dataInterface.DataInterfacePage;
import com.bringspring.system.base.model.dataInterface.PaginationDataInterface;

import java.util.List;
import java.util.Map;

/**
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2021/3/12 15:31
 */
public interface DataInterfaceService extends IService<DataInterfaceEntity> {
    /**
     * 获取接口列表(分页)
     *
     * @param pagination 分页参数
     * @return ignore
     */
    List<DataInterfaceEntity> getList(PaginationDataInterface pagination, String dataType);

    /**
     * 获取接口列表下拉框
     *
     * @return ignore
     */
    List<DataInterfaceEntity> getList();

    /**
     * 获取接口数据
     *
     * @param id 主键
     * @return ignore
     */
    DataInterfaceEntity getInfo(String id);

    /**
     * 获取接口信息
     * @param code 编码
     * @return
     */
    DataInterfaceEntity getInfoByCode(String code);
    /**
     * 添加数据接口
     *
     * @param entity 实体
     */
    void create(DataInterfaceEntity entity);

    /**
     * 修改接口
     *
     * @param entity 实体
     * @param id     主键
     * @return 实体
     * @throws DataException ignore
     */
    boolean update(DataInterfaceEntity entity, String id) throws DataException;

    /**
     * 删除接口
     *
     * @param entity 实体
     */
    void delete(DataInterfaceEntity entity);

    /**
     * 判断接口名称是否重复
     *
     * @param fullName 名称
     * @param id       主键
     * @return ignore
     */
    boolean isExistByFullName(String fullName, String id);

    /**
     * 判断编码是否重复
     *
     * @param fullName 名称
     * @param id       主键
     * @return ignore
     */
    boolean isExistByEnCode(String fullName, String id);

    /**
     * 访问接口路径
     *
     * @param id 主键
     * @return ignore
     */
    ActionResult infoToId(String id);

    /**
     * 获取接口分页数据
     *
     * @param id   主键
     * @param page 分页参数
     * @return ignore
     */
    ActionResult infoToIdPageList(String id, DataInterfacePage page);

    /**
     * 获取接口详情数据
     *
     * @param id   主键
     * @param page 分页参数
     * @return ignore
     */
    Map<String, Object> infoToInfo(String id, DataInterfacePage page);

    /**
     * 访问接口路径
     *
     * @param id       主键
     * @param tenantId 租户encode
     * @param map      需要替换的参数
     * @return ignore
     */
    ActionResult infoToId(String id, String tenantId, Map<String, String> map);
    /**
     * 访问接口路径
     *
     * @param code      编码
     * @param tenantId 租户encode
     * @param map      需要替换的参数
     * @return ignore
     */
    ActionResult getApiByCode(String code, String tenantId, Map<String, String> map);

    ActionResult getApiById(String code, String tenantId, Map<String, String> map);

    /**
     * 预览语句
     *
     * @param id
     * @return
     */
    Object preview(String id);
}
