package com.bringspring.system.external.service;

import com.alibaba.fastjson.JSONObject;
import com.bringspring.common.base.UserInfo;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.entity.UserEntity;
import me.chanjar.weixin.common.error.WxErrorException;

/**
 * 本系统的公司、部门、用户同步更新到企业微信的通讯录
 *
 * @版本： V1.0.0
 * @版权： 荣科科技股份有限公司
 * @作者： RKKJ开发平台组
 * @日期： 2024/2/20 11:12
 */
public interface SynPushToThirdQyService {

    //------------------------------------本系统同步公司、部门到企业微信-------------------------------------

    /**
     * 本地同步单个公司或部门到企业微信(供调用)
     *
     * @param userInfo   当前操作用户(异步线程无法获取，所以传参)
     * @param isBatch    是否批量(批量不受开关限制)，仅用作标识 不受配置开关限制。
     * @param deptEntity
     * @param corpId     企业微信ID
     * @return
     * @throws WxErrorException
     */
    JSONObject createDepartmentSysToQy(UserInfo userInfo, boolean isBatch, OrganizeEntity deptEntity, String corpId) throws WxErrorException;

    /**
     * 本地更新单个公司或部门到企业微信(供调用)
     *
     * @param userInfo   当前操作用户(异步线程无法获取，所以传参)
     * @param isBatch    是否批量(批量不受开关限制)，仅用作标识 不受配置开关限制。
     * @param deptEntity
     * @param corpId     企业微信ID
     * @return
     * @throws WxErrorException
     */
    JSONObject updateDepartmentSysToQy(UserInfo userInfo, boolean isBatch, OrganizeEntity deptEntity, String corpId) throws WxErrorException;

    /**
     * 本地删除单个公司或部门，同步到企业微信(供调用)
     *
     * @param userInfo 当前操作用户(异步线程无法获取，所以传参)
     * @param isBatch  是否批量(批量不受开关限制)
     * @param deptId   本系统的公司或部门ID
     * @param corpId   企业微信ID
     * @return
     * @throws WxErrorException
     */
    JSONObject deleteDepartmentSysToQy(UserInfo userInfo, boolean isBatch, String deptId, String corpId) throws WxErrorException;

    /**
     * 部门信息变更，触发同步的条件
     * @param oldDept 变更前
     * @param newDept 变更后
     * @return
     */
    boolean triggeringCondition(OrganizeEntity oldDept, OrganizeEntity newDept);

    /**
     * 部门信息 变更触发 用户信息 同步，
     * @param oldDept 变更前
     * @param newDept 变更后
     * @return
     */
    boolean triggeringConditionForUser(OrganizeEntity oldDept, OrganizeEntity newDept);

    //------------------------------------本系统同步成员到企业微信-------------------------------------

    /**
     * 本地新增单个用户到企业微信(供调用)
     *
     * @param userInfo   当前操作用户(异步线程无法获取，所以传参)
     * @param isBatch    是否批量(批量不受开关限制)
     * @param userEntity 本系统的用户
     * @param corpId     企业微信ID
     * @return
     * @throws WxErrorException
     */
    JSONObject createUserSysToQy(UserInfo userInfo, boolean isBatch, UserEntity userEntity, String corpId) throws WxErrorException;

    /**
     * 本地更新单个用户到企业微信(供调用)
     *
     * @param userInfo   当前操作用户(异步线程无法获取，所以传参)
     * @param isBatch    是否批量(批量不受开关限制)
     * @param userEntity 本系统的用户
     * @param corpId     企业微信ID
     * @return
     * @throws WxErrorException
     */
    JSONObject updateUserSysToQy(UserInfo userInfo, boolean isBatch, UserEntity userEntity, String corpId) throws WxErrorException;

    /**
     * 本地删除单个用户，同步到企业微信(供调用)
     *
     * @param userInfo  当前操作用户(异步线程无法获取，所以传参)
     * @param isBatch   是否批量(批量不受开关限制)
     * @param sysUserId 本系统的用户ID
     * @param corpId    企业微信ID
     * @return
     * @throws WxErrorException
     */
    JSONObject deleteUserSysToQy(UserInfo userInfo, boolean isBatch, String sysUserId, String corpId) throws WxErrorException;

    /**
     * 成员信息变更，触发同步的条件
     * @param oldUser 变更前
     * @param newUser 变更后
     * @return
     */
    boolean triggeringCondition(UserEntity oldUser, UserEntity newUser);
}
