package com.bringspring.system.message.controller;

import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.vo.ListVO;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.system.message.model.ImReplyListModel;
import com.bringspring.system.message.model.ImReplyListVo;
import com.bringspring.system.message.service.ImContentService;
import com.bringspring.system.message.service.ImReplyService;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.service.UserService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 消息会话接口
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2021-05-29
 */
@Api(tags = "消息会话接口", value = "imreply")
@RestController
@RequestMapping("/api/message/imreply")
public class ImReplyController {
    @Autowired
    private ImReplyService imReplyService;
    @Autowired
    private ImContentService imContentService;
    @Autowired
    private UserService userService;
    @Autowired
    private UserProvider userProvider;

    /**
     * 获取消息会话列表
     *
     * @return
     */
    @ApiOperation("获取消息会话列表")
    @GetMapping
    public ActionResult getList() {
        List<ImReplyListModel> imReplyList = imReplyService.getImReplyList();
        for (ImReplyListModel vo : imReplyList) {
            //头像路径拼接
//            vo.setHeadIcon(UploaderUtil.uploaderImg(vo.getHeadIcon()));
            vo.setHeadIcon(vo.getHeadIcon());
            //获取未读消息
            vo.setUnreadMessage(imContentService.getUnreadCount(vo.getId(), userProvider.get().getUserId()));
            UserEntity entity = userService.getInfo(vo.getId());
            if (entity != null) {
                //拼接账号和名称
                vo.setRealName(entity.getRealName());
                vo.setAccount(entity.getAccount());
            }
        }
        //排序
        imReplyList = imReplyList.stream().sorted(Comparator.comparing(ImReplyListModel::getLatestDate).reversed())
                .collect(Collectors.toList());
        List<ImReplyListVo> imReplyListVoList = JsonUtil.getJsonToList(imReplyList, ImReplyListVo.class);
        ListVO listVO = new ListVO();
        listVO.setList(imReplyListVoList);
        return ActionResult.success(listVO);
    }

}
