package com.bringspring.system.msgcenter.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.util.Date;


/**
 * 消息模板表
 *
 * @版本： V1.0.0
 * @版权： 荣科科技股份有限公司
 * @作者： RKKJ开发平台组
 * @日期： 2024-06-07
 */
@Data
@TableName("MC_MSG_TEMPLATE")
public class McMsgTemplateEntity {

    @TableId("ID")
    private String id;

    @TableField("FULL_NAME")
    private String fullName;

    @TableField("EN_CODE")
    private String enCode;

    @TableField("TEMPLATE_TYPE")
    private String templateType;

    @TableField("MESSAGE_SOURCE")
    private String messageSource;

    @TableField("MESSAGE_TYPE")
    private String messageType;

    @TableField("DESCRIPTION")
    private String description;

    @TableField("TITLE")
    private String title;

    @TableField("CONTENT")
    private String content;

    @TableField("TEMPLATE_CODE")
    private String templateCode;

    @TableField("WX_SKIP")
    private String wxSkip;

    @TableField("XCX_APP_ID")
    private String xcxAppId;

    @TableField("SUBSCRIBER_TYPE")
    private String subscriberType;

    @TableField("ENABLED_MARK")
    private Integer enabledMark;

    @TableField("SORT_CODE")
    private Long sortCode;

    @TableField(value = "CREATOR_TIME", fill = FieldFill.INSERT)
    private Date creatorTime;

    @TableField(value = "CREATOR_USER_ID", fill = FieldFill.INSERT)
    private String creatorUserId;

    @TableField(value = "LAST_MODIFY_TIME", fill = FieldFill.INSERT_UPDATE)
    private Date lastModifyTime;

    @TableField(value = "LAST_MODIFY_USER_ID", fill = FieldFill.INSERT_UPDATE)
    private String lastModifyUserId;

    @TableField("DELETE_TIME")
    private Date deleteTime;

    @TableField("DELETE_USER_ID")
    private String deleteUserId;

    @TableField("DELETE_MARK")
    private Integer deleteMark;

}
