package com.bringspring.system.permission.model.user.vo;

import com.bringspring.system.permission.model.permission.PermissionModel;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;

/**
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2021/3/12 15:31
 */
@Data
public class UserInfoVO implements Serializable {

    @ApiModelProperty(value = "code")
    private String code;
    @ApiModelProperty(value = "id")
    private String id;
    @ApiModelProperty(value = "账户")
    private String account;
    @ApiModelProperty(value = "户名")
    private String realName;
    @ApiModelProperty(value = "部门id")
    private String organizeId;
    @JsonProperty("organizeName")
    private List<PermissionModel>  organizeNames;
    @ApiModelProperty(value = "组织id树")
    private List<LinkedList<String>> organizeIdTree;
    @ApiModelProperty(value = "主管id")
    private String managerId;
    @ApiModelProperty(value = "岗位id")
    private String positionId;
    @ApiModelProperty(value = "角色id")
    private String roleId;
    @JsonProperty("roleName")
    private String roleName;
    @ApiModelProperty(value = "备注")
    private String description;
    @ApiModelProperty(value = "性别")
    private String gender;
    @ApiModelProperty(value = "民族")
    private String nation;
    @ApiModelProperty(value = "籍贯")
    private String nativePlace;
    @ApiModelProperty(value = "入职时间")
    private Long entryDate;
    @ApiModelProperty(value = "证件类型")
    private String certificatesType;
    @ApiModelProperty(value = "证件号码")
    private String certificatesNumber;
    @ApiModelProperty(value = "学历")
    private String education;
    @ApiModelProperty(value = "出生年月")
    private Long birthday;
    @ApiModelProperty(value = "办公电话")
    private String telePhone;
    @ApiModelProperty(value = "办公座机")
    private String landline;
    @ApiModelProperty(value = "手机号码")
    private String mobilePhone;
    @ApiModelProperty(value = "电子邮箱")
    private String email;
    @ApiModelProperty(value = "紧急联系人")
    private String urgentContacts;
    @ApiModelProperty(value = "紧急联系人电话")
    private String urgentTelePhone;
    @ApiModelProperty(value = "通信地址")
    private String postalAddress;
    @ApiModelProperty(value = "用户头像")
    private String headIcon;
    @ApiModelProperty(value = "状态")
    private Integer enabledMark;
    @ApiModelProperty(value = "排序")
    private Long sortCode;
    @ApiModelProperty(value = "分组id")
    private String groupId;

    //销售授权区域
    private List<List<String>> authorizeAddress;

    //售后授权区域
    private List<List<String>> afterAuthorizeAddress;

    //实施授权区域
    private List<List<String>> executeAddress;


}
