package com.bringspring.system.print.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.bringspring.system.print.entity.OperatorRecordEntity;
import com.bringspring.system.print.entity.PrintDevEntity;
import com.bringspring.system.print.model.PaginationPrint;
import com.bringspring.system.print.model.vo.PrintDevVO;

import java.util.List;
import java.util.Map;

/**
 * 打印模板-服务类
 *
 * @author RKKJ开发平台组 YY
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2017年9月30日
 */
public interface IPrintDevService extends IService<PrintDevEntity> {
    /**
     * 列表
     * @throws Exception 字典分类不存在BUG
     */
    List<PrintDevEntity> getList(PaginationPrint paginationPrint);

    /**
     * 获取打印模板对象树形模型
     * @throws Exception 字典分类不存在BUG
     */
    List<PrintDevVO> getTreeModel() throws Exception;

    /**
     * 获取打印模板对象树形模型(selector)
     * @param type 打印模板类型
     * @throws Exception 字典分类不存在BUG
     */
    List<PrintDevVO> getTreeModel(Integer type) throws Exception;

    /**
     * 重名验证
     * @param fullName 全名
     * @param id 模板id
     * @return true:存在 、false:不存在
     */
    Boolean checkNameExist(String fullName,String id);

    /**
     * 获取流程经办记录集合
     * @param taskId 任务ID
     * @return 经办记录集合
     */
    List<OperatorRecordEntity> getFlowTaskOperatorRecordList(String taskId);

    /**
     * sql获取打印内容
     * @param dbLinkId      数据连接ID
     * @param sqlTempLate   SQL语句数组
     * @param type          类型
     * @return
     * @throws Exception
     */
    Map<String,Object> getDataBySql(String dbLinkId, String sqlTempLate, int type) throws Exception;

}
