package com.bringspring.system.scheduletask.service;


import com.baomidou.mybatisplus.extension.service.IService;
import com.bringspring.common.base.Pagination;
import com.bringspring.system.scheduletask.entity.TimeTaskEntity;
import com.bringspring.system.scheduletask.entity.TimeTaskLogEntity;
import com.bringspring.system.scheduletask.model.TaskPage;

import java.util.List;

/**
 * 定时任务
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2017年9月27日 上午9:18
 */
public interface TimetaskService extends IService<TimeTaskEntity> {

    /**
     * 列表
     *
     * @param
     * @return
     */
    List<TimeTaskEntity> getList();

    /**
     * 列表
     *
     * @param pagination 分页
     * @return
     */
    List<TimeTaskEntity> getList(Pagination pagination);

    /**
     * 列表（执行记录）
     *
     * @param pagination 分页
     * @param taskId     任务Id
     * @return
     */
    List<TimeTaskLogEntity> getTaskLogList(String taskId, TaskPage pagination);

    /**
     * 信息
     *
     * @param id 主键值
     * @return
     */
    TimeTaskEntity getInfo(String id);

    /**
     * 验证名称
     *
     * @param fullName 名称
     * @param id       主键值
     * @return
     */
    boolean isExistByFullName(String fullName, String id);

    /**
     * 验证编码
     *
     * @param enCode 编码
     * @param id     主键值
     * @return
     */
    boolean isExistByEnCode(String enCode, String id);

    /**
     * 创建
     *
     * @param entity 实体对象
     */
    void create(TimeTaskEntity entity);

    /**
     * 更新
     *
     * @param id     主键值
     * @param entity 实体对象
     */
    boolean update(String id, TimeTaskEntity entity);

    /**
     * 删除
     *
     * @param entity 实体对象
     */
    void delete(TimeTaskEntity entity);

    /**
     * 上移
     *
     * @param id 主键值
     */
    boolean first(String id);

    /**
     * 下移
     *
     * @param id 主键值
     */
    boolean next(String id);

    /**
     * 执行记录
     *
     * @param entity 实体对象
     */
    void createTaskLog(TimeTaskLogEntity entity);

    /**
     * 立即执行一次
     *
     * @param id
     * @param entity
     */
    boolean jobStartNow(String id, TimeTaskEntity entity);

    /**
     * 根据content查询数据
     *
     * @param content
     */
    List<TimeTaskEntity> getListByContent(String content);

    /**
     * 根据encode查询数据
     *
     * @param encode
     */
    List<TimeTaskEntity> getListByEncode(String encode);
}
