/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.base.controller;

import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.system.base.model.baseSyncThirdInfo.BaseSyncThirdInfoInfoVO;
import com.bringspring.system.base.model.baseSyncThirdInfo.BaseSyncThirdInfoListVO;
import com.bringspring.system.base.model.baseSyncThirdInfo.BaseSyncThirdInfoPagination;
import com.bringspring.system.base.service.BaseSyncThirdInfoService;
import com.bringspring.system.message.entity.SynThirdInfoEntity;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u7b2c\u4e09\u65b9\u540c\u6b65"}, value="SyncThirdInfo")
@RequestMapping(value={"/api/system/base/thirdInfo"})
public class BaseSyncThirdInfoController {
    private static final Logger log = LoggerFactory.getLogger(BaseSyncThirdInfoController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private BaseSyncThirdInfoService baseSyncThirdInfoService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody BaseSyncThirdInfoPagination baseSyncThirdInfoPagination) throws IOException {
        List<SynThirdInfoEntity> list = this.baseSyncThirdInfoService.getList(baseSyncThirdInfoPagination);
        List listVO = JsonUtil.getJsonToList(list, BaseSyncThirdInfoListVO.class);
        for (BaseSyncThirdInfoListVO infoVO : listVO) {
            if ("2".equals(infoVO.getDataType())) {
                infoVO.setSystemObjectId(this.baseDataUtil.userSelectValue(infoVO.getSystemObjectId()));
            } else {
                infoVO.setSystemObjectId(this.baseDataUtil.comSelectValues(infoVO.getSystemObjectId()));
            }
            infoVO.setCreatorUserId(this.baseDataUtil.userSelectValue(infoVO.getCreatorUserId()));
            infoVO.setLastModifyUserId(this.baseDataUtil.userSelectValue(infoVO.getLastModifyUserId()));
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)baseSyncThirdInfoPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<BaseSyncThirdInfoInfoVO> info(@PathVariable(value="id") String id) {
        SynThirdInfoEntity entity = this.baseSyncThirdInfoService.getInfo(id);
        BaseSyncThirdInfoInfoVO vo = (BaseSyncThirdInfoInfoVO)JsonUtil.getJsonToBean((Object)entity, BaseSyncThirdInfoInfoVO.class);
        if (vo.getCreatorTime() != null) {
            vo.setCreatorTime(vo.getCreatorTime());
        }
        vo.setCreatorUserId(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
        if (vo.getLastModifyTime() != null) {
            vo.setLastModifyTime(vo.getLastModifyTime());
        }
        vo.setLastModifyUserId(this.baseDataUtil.userSelectValue(vo.getLastModifyUserId()));
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<BaseSyncThirdInfoInfoVO> detailInfo(@PathVariable(value="id") String id) {
        SynThirdInfoEntity entity = this.baseSyncThirdInfoService.getInfo(id);
        BaseSyncThirdInfoInfoVO vo = (BaseSyncThirdInfoInfoVO)JsonUtil.getJsonToBean((Object)entity, BaseSyncThirdInfoInfoVO.class);
        vo.setCreatorUserId(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
        vo.setLastModifyUserId(this.baseDataUtil.userSelectValue(vo.getLastModifyUserId()));
        return ActionResult.success((Object)vo);
    }
}

