/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.base.util.jobutil;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerFactory;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.impl.StdSchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobManager {
    private static final Logger log = LoggerFactory.getLogger(JobManager.class);
    private SchedulerFactory schedulerFactory = new StdSchedulerFactory();
    private final String TRIGGER_PREFIX = "tri_";
    public static final String CRON_DELIMITER = ";";

    public void addJob(String jobName, String jobGroupName, String cron, JobDataMap jobDataMap, Date startDate, Date endDate, Class<? extends Job> jobClass) {
        this.addJobInternal(jobName, jobGroupName, jobClass, cron, jobDataMap, startDate, endDate);
    }

    public void updateJob(String jobName, String jobGroupName, String cron, JobDataMap jobDataMap, Date startDate, Date endDate) {
        this.updateJobInternal(jobName, jobGroupName, cron, jobDataMap, startDate, endDate);
    }

    public void removeJob(String jobName, String jobGroupName) {
        this.removeJobWithAllTriggers(jobName, jobGroupName);
    }

    public void startJobNow(String jobName, String jobGroupName, JobDataMap jobDataMap, Class<? extends Job> jobClass) {
        try {
            Scheduler sched = this.schedulerFactory.getScheduler();
            String triggerName = this.generateUniqueTriggerName(jobName, jobGroupName, "once");
            JobDetail jobDetail = jobDataMap != null ? JobBuilder.newJob(jobClass).withIdentity(jobName, jobGroupName).setJobData(jobDataMap).build() : JobBuilder.newJob(jobClass).withIdentity(jobName, jobGroupName).build();
            Trigger trigger = TriggerBuilder.newTrigger().withIdentity(triggerName, jobGroupName).startNow().build();
            sched.scheduleJob(jobDetail, trigger);
            if (!sched.isShutdown()) {
                sched.start();
                log.info("\u7acb\u5373\u6267\u884c\u4e00\u6b21\u4efb\u52a1\u6210\u529f: {}.{}", (Object)jobGroupName, (Object)jobName);
            }
        }
        catch (Exception e) {
            log.error("\u7acb\u5373\u6267\u884c\u4e00\u6b21\u4efb\u52a1\u5931\u8d25: {}.{} - {}", new Object[]{jobGroupName, jobName, e.getMessage()});
        }
    }

    private void addJobInternal(String jobName, String jobGroupName, Class<? extends Job> jobClass, String cron, JobDataMap jobDataMap, Date startDate, Date endDate) {
        try {
            Scheduler sched = this.schedulerFactory.getScheduler();
            JobKey jobKey = new JobKey(jobName, jobGroupName);
            if (sched.checkExists(jobKey)) {
                log.warn("\u4efb\u52a1\u5df2\u5b58\u5728: {}.{}", (Object)jobGroupName, (Object)jobName);
                return;
            }
            JobDetail jobDetail = this.createJobDetail(jobName, jobGroupName, jobClass, jobDataMap);
            Set<Trigger> triggers = this.parseCronExpressions(jobName, jobGroupName, cron, jobDataMap, startDate, endDate);
            if (triggers.isEmpty()) {
                log.error("\u672a\u627e\u5230\u6709\u6548\u7684Cron\u8868\u8fbe\u5f0f: {}", (Object)cron);
                return;
            }
            sched.scheduleJob(jobDetail, triggers, true);
            if (!sched.isShutdown()) {
                sched.start();
                log.info("\u6dfb\u52a0\u5b9a\u65f6\u4efb\u52a1\u6210\u529f: {}.{}, \u89e6\u53d1\u5668\u6570\u91cf: {}", new Object[]{jobGroupName, jobName, triggers.size()});
            }
        }
        catch (Exception e) {
            log.error("\u6dfb\u52a0\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25: {}.{} - {}", new Object[]{jobGroupName, jobName, e.getMessage()});
        }
    }

    private void removeJobWithAllTriggers(String jobName, String jobGroupName) {
        try {
            Scheduler sched = this.schedulerFactory.getScheduler();
            JobKey jobKey = new JobKey(jobName, jobGroupName);
            if (!sched.checkExists(jobKey)) {
                log.warn("\u4efb\u52a1\u4e0d\u5b58\u5728: {}.{}", (Object)jobGroupName, (Object)jobName);
                return;
            }
            List triggers = sched.getTriggersOfJob(jobKey);
            for (Trigger trigger : triggers) {
                sched.pauseTrigger(trigger.getKey());
            }
            boolean deleted = sched.deleteJob(jobKey);
            if (deleted) {
                log.info("\u79fb\u9664\u4efb\u52a1\u6210\u529f: {}.{}, \u79fb\u9664\u89e6\u53d1\u5668\u6570\u91cf: {}", new Object[]{jobGroupName, jobName, triggers.size()});
            }
        }
        catch (Exception e) {
            log.error("\u79fb\u9664\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25: {}.{} - {}", new Object[]{jobGroupName, jobName, e.getMessage()});
        }
    }

    private void updateJobInternal(String jobName, String jobGroupName, String cron, JobDataMap jobDataMap, Date startDate, Date endDate) {
        try {
            Scheduler sched = this.schedulerFactory.getScheduler();
            JobKey jobKey = new JobKey(jobName, jobGroupName);
            if (!sched.checkExists(jobKey)) {
                log.warn("\u4efb\u52a1\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u66f4\u65b0: {}.{}", (Object)jobGroupName, (Object)jobName);
                return;
            }
            List oldTriggers = sched.getTriggersOfJob(jobKey);
            HashSet<TriggerKey> triggerKeys = new HashSet<TriggerKey>();
            for (Trigger trigger : oldTriggers) {
                triggerKeys.add(trigger.getKey());
                sched.unscheduleJob(trigger.getKey());
            }
            Set<Trigger> newTriggers = this.parseCronExpressions(jobName, jobGroupName, cron, jobDataMap, startDate, endDate);
            for (Trigger trigger : newTriggers) {
                sched.scheduleJob(trigger);
            }
            log.info("\u66f4\u65b0\u4efb\u52a1\u6210\u529f: {}.{}, \u65e7\u89e6\u53d1\u5668: {}, \u65b0\u89e6\u53d1\u5668: {}", new Object[]{jobGroupName, jobName, oldTriggers.size(), newTriggers.size()});
        }
        catch (Exception e) {
            log.error("\u4fee\u6539\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25: {}.{} - {}", new Object[]{jobGroupName, jobName, e.getMessage()});
        }
    }

    private Set<Trigger> parseCronExpressions(String jobName, String jobGroupName, String cron, JobDataMap jobDataMap, Date startDate, Date endDate) {
        HashSet<Trigger> triggers = new HashSet<Trigger>();
        if (cron == null || cron.trim().isEmpty()) {
            return triggers;
        }
        String[] cronExpressions = cron.split(CRON_DELIMITER);
        for (int i = 0; i < cronExpressions.length; ++i) {
            String singleCron = cronExpressions[i].trim();
            if (singleCron.isEmpty()) continue;
            try {
                String triggerName = this.generateUniqueTriggerName(jobName, jobGroupName, String.valueOf(i));
                TriggerBuilder triggerBuilder = TriggerBuilder.newTrigger().withIdentity(triggerName, jobGroupName).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)singleCron));
                if (startDate != null) {
                    triggerBuilder.startAt(startDate);
                } else {
                    triggerBuilder.startNow();
                }
                if (endDate != null) {
                    triggerBuilder.endAt(endDate);
                }
                if (jobDataMap != null) {
                    triggerBuilder.usingJobData(new JobDataMap((Map)jobDataMap));
                }
                triggers.add(triggerBuilder.build());
                continue;
            }
            catch (Exception e) {
                log.error("\u89e3\u6790Cron\u8868\u8fbe\u5f0f\u5931\u8d25: {} - {}", (Object)singleCron, (Object)e.getMessage());
            }
        }
        return triggers;
    }

    private JobDetail createJobDetail(String jobName, String jobGroupName, Class<? extends Job> jobClass, JobDataMap jobDataMap) {
        JobBuilder jobBuilder = JobBuilder.newJob(jobClass).withIdentity(jobName, jobGroupName);
        if (jobDataMap != null) {
            jobBuilder.setJobData(jobDataMap);
        }
        return jobBuilder.build();
    }

    private String generateUniqueTriggerName(String jobName, String jobGroupName, String suffix) {
        return "tri_" + jobName + "_" + jobGroupName + "_" + suffix + "_" + System.currentTimeMillis();
    }

    public List<String> getJobTriggersInfo(String jobName, String jobGroupName) {
        ArrayList<String> triggerInfos = new ArrayList<String>();
        try {
            Scheduler sched = this.schedulerFactory.getScheduler();
            JobKey jobKey = new JobKey(jobName, jobGroupName);
            if (sched.checkExists(jobKey)) {
                List triggers = sched.getTriggersOfJob(jobKey);
                for (Trigger trigger : triggers) {
                    if (trigger instanceof CronTrigger) {
                        CronTrigger cronTrigger = (CronTrigger)trigger;
                        triggerInfos.add(String.format("\u89e6\u53d1\u5668: %s, Cron: %s", trigger.getKey(), cronTrigger.getCronExpression()));
                        continue;
                    }
                    triggerInfos.add(String.format("\u89e6\u53d1\u5668: %s, \u7c7b\u578b: %s", trigger.getKey(), trigger.getClass().getSimpleName()));
                }
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u4efb\u52a1\u89e6\u53d1\u5668\u4fe1\u606f\u5931\u8d25: {}.{} - {}", new Object[]{jobGroupName, jobName, e.getMessage()});
        }
        return triggerInfos;
    }

    public boolean isJobExists(String jobName, String jobGroupName) {
        try {
            Scheduler sched = this.schedulerFactory.getScheduler();
            JobKey jobKey = new JobKey(jobName, jobGroupName);
            return sched.checkExists(jobKey);
        }
        catch (Exception e) {
            log.error("\u5224\u65ad\u4efb\u52a1\u662f\u5426\u5b58\u5728\u5931\u8d25: {}.{} - {}", new Object[]{jobGroupName, jobName, e.getMessage()});
            return false;
        }
    }

    public void startJobs() {
        try {
            Scheduler sched = this.schedulerFactory.getScheduler();
            sched.start();
            log.info("\u542f\u52a8\u6240\u6709\u5b9a\u65f6\u4efb\u52a1\u6210\u529f");
        }
        catch (Exception e) {
            log.error("\u542f\u52a8\u6240\u6709\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25: {}", (Object)e.getMessage());
            throw new RuntimeException(e);
        }
    }

    public void shutdownJobs() {
        try {
            Scheduler sched = this.schedulerFactory.getScheduler();
            if (!sched.isShutdown()) {
                sched.shutdown();
                log.info("\u5173\u95ed\u6240\u6709\u5b9a\u65f6\u4efb\u52a1\u6210\u529f");
            }
        }
        catch (Exception e) {
            log.error("\u5173\u95ed\u6240\u6709\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25: {}", (Object)e.getMessage());
            throw new RuntimeException(e);
        }
    }

    private void removeJob(String jobName, String jobGroupName, String triggerName, String triggerGroupName) {
        try {
            Scheduler sched = this.schedulerFactory.getScheduler();
            JobKey jobKey = JobKey.jobKey((String)jobName, (String)jobGroupName);
            JobDetail jobDetail = sched.getJobDetail(jobKey);
            if (null != jobDetail) {
                TriggerKey triggerKey = TriggerKey.triggerKey((String)triggerName, (String)triggerGroupName);
                sched.pauseTrigger(triggerKey);
                sched.unscheduleJob(triggerKey);
                sched.deleteJob(jobKey);
            }
        }
        catch (Exception e) {
            log.error("\u79fb\u9664\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25:{}", (Object)e.getMessage());
        }
    }

    private void updateJob(String jobName, String jobGroupName, String triggerName, String triggerGroupName, String cron, JobDataMap jobDataMap, Date startDate, Date endDate) {
        try {
            CronTrigger cronTrigger;
            String oldTime;
            Scheduler sched = this.schedulerFactory.getScheduler();
            TriggerKey triggerKey = TriggerKey.triggerKey((String)triggerName, (String)triggerGroupName);
            Trigger trigger = sched.getTrigger(triggerKey);
            if (trigger == null) {
                return;
            }
            if (trigger instanceof CronTrigger && !(oldTime = (cronTrigger = (CronTrigger)trigger).getCronExpression()).equalsIgnoreCase(cron)) {
                TriggerBuilder triggerBuilder = TriggerBuilder.newTrigger();
                if (jobDataMap != null) {
                    triggerBuilder.withIdentity(triggerName, triggerGroupName).usingJobData(jobDataMap);
                } else {
                    triggerBuilder.withIdentity(triggerName, triggerGroupName);
                }
                triggerBuilder.startNow();
                triggerBuilder.withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cron));
                if (endDate != null) {
                    triggerBuilder.endAt(endDate);
                }
                Trigger newTrigger = triggerBuilder.build();
                sched.rescheduleJob(triggerKey, newTrigger);
            }
        }
        catch (Exception e) {
            log.error("\u4fee\u6539\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25:{}", (Object)e.getMessage());
        }
    }

    private boolean isTriKey(String jobName, String jobGroupName) {
        boolean flag = false;
        try {
            Scheduler sched = this.schedulerFactory.getScheduler();
            TriggerKey triggerKey = TriggerKey.triggerKey((String)("tri_" + jobName), (String)("tri_" + jobGroupName));
            Trigger trigger = sched.getTrigger(triggerKey);
            if (trigger != null) {
                flag = true;
            }
        }
        catch (Exception e) {
            log.error("\u5224\u65ad\u4efb\u52a1\u8c03\u5ea6\u89e6\u53d1\u5668\u662f\u5426\u5b58\u5728:{}", (Object)e.getMessage());
        }
        return flag;
    }
}

