/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.external.controller;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.extra.emoji.EmojiUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.system.base.listener.DIngStream;
import com.bringspring.system.external.bean.linkedcorp.MyWxCpLinkedCorpUser;
import com.bringspring.system.external.config.mutil.WxCpConfiguration;
import com.bringspring.system.external.service.impl.MyWxCpLinkedCorpServiceImpl;
import com.bringspring.system.external.util.ValidateCommonUtil;
import com.bringspring.system.message.entity.SynThirdInfoEntity;
import com.bringspring.system.message.service.SynThirdInfoService;
import com.bringspring.system.message.util.SynThirdConsts;
import com.bringspring.system.message.util.SynThirdTotal;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.entity.PositionEntity;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.service.PositionService;
import com.bringspring.system.permission.service.UserService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import me.chanjar.weixin.cp.api.WxCpService;
import me.chanjar.weixin.cp.bean.linkedcorp.WxCpLinkedCorpAgentPerm;
import me.chanjar.weixin.cp.bean.linkedcorp.WxCpLinkedCorpDepartment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u4f01\u4e1a\u5fae\u4fe1-\u4e92\u8054\u4f01\u4e1a"}, value="WxCpLinkedCorp")
@RestController
@RequestMapping(value={"/api/external/linkedCorp/{corpId}/{agentId}"})
public class WxCpLinkedCorpController {
    private static final Logger log = LoggerFactory.getLogger(WxCpLinkedCorpController.class);
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private SynThirdInfoService synThirdInfoService;
    @Autowired
    private OrganizeService organizeService;
    @Autowired
    PositionService positionService;
    @Autowired
    private UserService userService;
    @Autowired
    private DIngStream dIngStream;
    @Autowired
    WxCpConfiguration wxCpConfiguration;
    @Autowired
    ValidateCommonUtil validateCommonUtil;

    @ApiOperation(value="\u4f01\u4e1a\u5fae\u4fe1\u3010\u4e92\u8054\u4f01\u4e1a\u3011\u83b7\u53d6\u4e92\u8054\u4f01\u4e1a\u90e8\u95e8\u5217\u8868")
    @GetMapping(value={"/department/list"})
    @DSTransactional
    @CacheEvict(value={"OrganizeCache"}, allEntries=true)
    public ActionResult linkedcorpDepartmentList(@PathVariable String corpId, @PathVariable Integer agentId) {
        UserInfo userInfo = this.userProvider.get();
        if (ObjectUtil.isEmpty((Object)userInfo)) {
            return ActionResult.fail((String)"\u83b7\u53d6\u5f53\u524d\u767b\u5f55\u7528\u6237\u4fe1\u606f\u5931\u8d25");
        }
        WxCpService wxCpService = this.wxCpConfiguration.getCpService(corpId, agentId);
        if (wxCpService == null) {
            return ActionResult.fail((String)String.format("\u672a\u627e\u5230\u5bf9\u5e94corpId=[%s]\u3001agentId=[%d]\u7684\u914d\u7f6e\uff0c\u8bf7\u6838\u5b9e\uff01", corpId, agentId));
        }
        MyWxCpLinkedCorpServiceImpl wxCpLinkedCorpService = new MyWxCpLinkedCorpServiceImpl();
        wxCpLinkedCorpService.setWxCpService(wxCpService);
        try {
            String[] agentPermList;
            WxCpLinkedCorpAgentPerm linkedCorpAgentPerm = wxCpLinkedCorpService.getLinkedCorpAgentPerm();
            if (ObjectUtil.isNotEmpty((Object)linkedCorpAgentPerm)) {
                String[] userIdList = linkedCorpAgentPerm.getUserIdList();
                agentPermList = linkedCorpAgentPerm.getDepartmentIdList();
                if (ObjectUtil.isEmpty((Object)agentPermList) || agentPermList.length == 0) {
                    return ActionResult.fail((String)"\u53ef\u89c1\u7ec4\u7ec7\u4e3a\u7a7a\uff0c\u8bf7\u6838\u5b9e\u4f01\u4e1a\u5fae\u4fe1\u7ba1\u7406\u540e\u53f0\u5e94\u7528\u914d\u7f6e\uff01");
                }
            } else {
                return ActionResult.fail((String)"\u83b7\u53d6\u5e94\u7528\u7684\u53ef\u89c1\u8303\u56f4\u63a5\u53e3\u8fd4\u56de\u6570\u636e\u9519\u8bef");
            }
            ArrayList organizeList = new ArrayList();
            ArrayList synThirdInfoList = new ArrayList();
            for (String s : agentPermList) {
                List<WxCpLinkedCorpDepartment> deptList = wxCpLinkedCorpService.getLinkedCorpDepartmentList(s);
                if (deptList == null || deptList.size() == 0) {
                    return ActionResult.fail((String)"\u83b7\u53d6\u4e92\u8054\u4f01\u4e1a\u90e8\u95e8\u5217\u8868\u63a5\u53e3\u6570\u636e\u4e3a\u7a7a");
                }
                deptList.stream().forEach(item -> {
                    String id = item.getDepartmentId();
                    String parentid = item.getParentId();
                    OrganizeEntity organizeEntity = new OrganizeEntity();
                    organizeEntity.setId(id);
                    organizeEntity.setFullName(item.getDepartmentName());
                    organizeEntity.setParentId("0".equals(parentid) ? "-1" : parentid);
                    organizeEntity.setCategory("1".equals(parentid) || "0".equals(parentid) ? "company" : "department");
                    organizeEntity.setSortCode((long)item.getOrder());
                    organizeList.add(organizeEntity);
                    SynThirdInfoEntity synThirdInfoEntity = this.synThirdInfoService.getInfoByThirdObjId("1", "1", id);
                    if (null == synThirdInfoEntity) {
                        synThirdInfoEntity = new SynThirdInfoEntity();
                        synThirdInfoEntity.setId(RandomUtil.uuId());
                    }
                    synThirdInfoEntity.setThirdObjectId(id);
                    synThirdInfoEntity.setSystemObjectId(id);
                    synThirdInfoEntity.setCropId(corpId);
                    synThirdInfoEntity.setThirdType(Integer.valueOf("1"));
                    synThirdInfoEntity.setDataType(Integer.valueOf("1"));
                    synThirdInfoEntity.setSynState(SynThirdConsts.SYN_STATE_OK);
                    synThirdInfoEntity.setCreatorUserId(userInfo.getUserId());
                    synThirdInfoEntity.setCreatorTime(DateUtil.getNowDate());
                    synThirdInfoList.add(synThirdInfoEntity);
                });
            }
            if (organizeList.size() != 0 && synThirdInfoList.size() != 0) {
                this.organizeService.saveOrUpdateBatch(organizeList);
                this.synThirdInfoService.saveOrUpdateBatch(synThirdInfoList);
                this.dIngStream.setOrganizedTree();
                SynThirdTotal synThirdTotal = this.synThirdInfoService.getSynTotal("1", "1");
                return ActionResult.success((Object)synThirdTotal);
            }
            return ActionResult.fail((String)"\u83b7\u53d6\u4e92\u8054\u4f01\u4e1a\u90e8\u95e8\u5217\u8868\u4e3a\u7a7a");
        }
        catch (Exception e) {
            e.printStackTrace();
            return ActionResult.fail((String)("\u7cfb\u7edf\u8fd0\u884c\u65f6\u5f02\u5e38\uff1a" + e));
        }
    }

    @ApiOperation(value="\u4f01\u4e1a\u5fae\u4fe1\u3010\u4e92\u8054\u4f01\u4e1a\u3011\u83b7\u53d6\u4e92\u8054\u4f01\u4e1a\u90e8\u95e8\u6210\u5458\u8be6\u60c5")
    @GetMapping(value={"/user/list"})
    @DSTransactional
    @CacheEvict(value={"UserCache"}, allEntries=true)
    public ActionResult linkedcorpUserList(@PathVariable String corpId, @PathVariable Integer agentId) {
        UserInfo userInfo = this.userProvider.get();
        if (ObjectUtil.isEmpty((Object)userInfo)) {
            return ActionResult.fail((String)"\u83b7\u53d6\u5f53\u524d\u767b\u5f55\u7528\u6237\u4fe1\u606f\u5931\u8d25");
        }
        WxCpService wxCpService = this.wxCpConfiguration.getCpService(corpId, agentId);
        if (wxCpService == null) {
            return ActionResult.fail((String)String.format("\u672a\u627e\u5230\u5bf9\u5e94corpId=[%s]\u3001agentId=[%d]\u7684\u914d\u7f6e\uff0c\u8bf7\u6838\u5b9e\uff01", corpId, agentId));
        }
        MyWxCpLinkedCorpServiceImpl wxCpLinkedCorpService = new MyWxCpLinkedCorpServiceImpl();
        wxCpLinkedCorpService.setWxCpService(wxCpService);
        try {
            String[] agentPermList;
            WxCpLinkedCorpAgentPerm linkedCorpAgentPerm = wxCpLinkedCorpService.getLinkedCorpAgentPerm();
            if (ObjectUtil.isNotEmpty((Object)linkedCorpAgentPerm)) {
                String[] userIdList = linkedCorpAgentPerm.getUserIdList();
                agentPermList = linkedCorpAgentPerm.getDepartmentIdList();
                if (ObjectUtil.isEmpty((Object)agentPermList) || agentPermList.length == 0) {
                    return ActionResult.fail((String)"\u53ef\u89c1\u7ec4\u7ec7\u4e3a\u7a7a\uff0c\u8bf7\u6838\u5b9e\u4f01\u4e1a\u5fae\u4fe1\u7ba1\u7406\u540e\u53f0\u5e94\u7528\u914d\u7f6e\uff01");
                }
            } else {
                return ActionResult.fail((String)"\u83b7\u53d6\u5e94\u7528\u7684\u53ef\u89c1\u8303\u56f4\u63a5\u53e3\u8fd4\u56de\u6570\u636e\u9519\u8bef");
            }
            this.validateCommonUtil.initData();
            StringBuilder deptListMsg = new StringBuilder();
            StringBuilder userListMsg = new StringBuilder();
            ArrayList<UserEntity> userBatch = new ArrayList<UserEntity>();
            ArrayList synThirdInfoBatch = new ArrayList();
            HashMap<String, UserEntity> updateUserMap = new HashMap<String, UserEntity>();
            HashMap<String, UserEntity> saveUserMap = new HashMap<String, UserEntity>();
            HashMap<String, SynThirdInfoEntity> updateThirdMap = new HashMap<String, SynThirdInfoEntity>();
            HashMap<String, SynThirdInfoEntity> saveThirdMap = new HashMap<String, SynThirdInfoEntity>();
            ArrayList positionBatch = new ArrayList();
            HashMap<String, PositionEntity> savePositionMap = new HashMap<String, PositionEntity>();
            for (String s : agentPermList) {
                String agentPerm = s;
                List<WxCpLinkedCorpDepartment> lcDeptList = wxCpLinkedCorpService.getLinkedCorpDepartmentList(agentPerm);
                if (lcDeptList == null || lcDeptList.size() == 0) {
                    deptListMsg.append(agentPerm);
                    deptListMsg.append(":\u83b7\u53d6\u4e92\u8054\u4f01\u4e1a\u90e8\u95e8\u5217\u8868\u5931\u8d25");
                    continue;
                }
                for (WxCpLinkedCorpDepartment d : lcDeptList) {
                    String departmentId = d.getDepartmentId();
                    departmentId = agentPerm.replaceFirst("/.*", "/" + departmentId);
                    List<MyWxCpLinkedCorpUser> lcUserList = wxCpLinkedCorpService.getLinkedCorpUserList(departmentId);
                    log.info("departmentId:" + departmentId);
                    log.info("lcUserList:" + lcUserList.toString());
                    if (lcUserList == null || lcUserList.size() == 0) {
                        userListMsg.append(departmentId);
                        userListMsg.append(":\u83b7\u53d6\u4e92\u8054\u4f01\u4e1a\u90e8\u95e8\u6210\u5458\u8be6\u60c5\u5931\u8d25");
                        continue;
                    }
                    for (MyWxCpLinkedCorpUser qyuser : lcUserList) {
                        UserEntity aUser;
                        UserEntity userEntity;
                        String userCorpId = qyuser.getCorpId();
                        String userid = qyuser.getUserId();
                        if (StringUtils.isEmpty((String)userCorpId) || StringUtils.isEmpty((String)userid)) continue;
                        String mobile = qyuser.getMobile();
                        String email = qyuser.getEmail();
                        boolean userIsNew = false;
                        String thirdObjid = userCorpId + "/" + userid;
                        SynThirdInfoEntity synThirdInfoEntity = this.validateCommonUtil.getThirdEntityByThirdId(thirdObjid);
                        if (ObjectUtil.isNotEmpty((Object)synThirdInfoEntity)) {
                            synThirdInfoEntity.setThirdObjectId(thirdObjid);
                            String systemObjectId = synThirdInfoEntity.getSystemObjectId();
                            userEntity = this.validateCommonUtil.getUserEntityByUserid(systemObjectId);
                            if (ObjectUtil.isEmpty((Object)userEntity) && ObjectUtil.isEmpty((Object)(userEntity = this.validateCommonUtil.getUserEntity(userid, mobile, email)))) {
                                userIsNew = true;
                                userEntity = new UserEntity();
                                userEntity.setId(RandomUtil.uuId());
                                userEntity.setAccount(userid);
                            }
                        } else {
                            synThirdInfoEntity = this.validateCommonUtil.newSynThirdInfoForWxUser(thirdObjid);
                            userEntity = this.validateCommonUtil.getUserEntity(userid, mobile, email);
                            if (ObjectUtil.isEmpty((Object)userEntity)) {
                                userIsNew = true;
                                userEntity = new UserEntity();
                                userEntity.setId(RandomUtil.uuId());
                                userEntity.setAccount(userid);
                            }
                        }
                        synThirdInfoEntity.setCropId(corpId);
                        synThirdInfoEntity.setSystemObjectId(userEntity.getId());
                        if (StringUtils.isNotEmpty((String)qyuser.getName())) {
                            String name = StringUtils.stringFilter((String)EmojiUtil.removeAllEmojis((String)qyuser.getName()));
                            userEntity.setRealName(name);
                        }
                        if (StringUtils.isNotEmpty((String)mobile)) {
                            userEntity.setMobilePhone(mobile);
                        }
                        if (StringUtils.isNotEmpty((String)qyuser.getTelephone())) {
                            userEntity.setTelePhone(qyuser.getTelephone());
                        }
                        if (StringUtils.isNotEmpty((String)email)) {
                            userEntity.setEmail(email);
                        }
                        this.validateCommonUtil.setDeptAndPosition(qyuser, userEntity);
                        userEntity.setCode(this.validateCommonUtil.getCode(qyuser));
                        if (userIsNew) {
                            userEntity.setRoleId(this.validateCommonUtil.getDefaultRoleId());
                            userEntity.setHeadIcon("/api/file/Image/userAvatar/001.png");
                            userEntity.setGender(3);
                            userEntity.setEnabledMark(1);
                            userEntity.setSecretkey(RandomUtil.uuId());
                            userEntity.setIsAdministrator(0);
                            userEntity.setPassword(this.userService.getDefaultPassword(userEntity.getSecretkey()));
                        }
                        if (userIsNew) {
                            if (saveUserMap.containsKey(thirdObjid)) {
                                aUser = (UserEntity)saveUserMap.get(thirdObjid);
                                this.validateCommonUtil.mergeDistinctOrganize(aUser, userEntity);
                                this.validateCommonUtil.mergeDistinctPosition(aUser, userEntity);
                                synThirdInfoEntity.setSystemObjectId(aUser.getId());
                            } else {
                                saveUserMap.put(thirdObjid, userEntity);
                            }
                            synThirdInfoEntity.setSynState(SynThirdConsts.SYN_STATE_OK);
                            saveThirdMap.put(thirdObjid, synThirdInfoEntity);
                            continue;
                        }
                        if (updateUserMap.containsKey(thirdObjid)) {
                            aUser = (UserEntity)updateUserMap.get(thirdObjid);
                            this.validateCommonUtil.mergeDistinctOrganize(aUser, userEntity);
                            this.validateCommonUtil.mergeDistinctPosition(aUser, userEntity);
                            synThirdInfoEntity.setSystemObjectId(aUser.getId());
                        } else {
                            updateUserMap.put(thirdObjid, userEntity);
                        }
                        synThirdInfoEntity.setSynState(SynThirdConsts.SYN_STATE_OK);
                        updateThirdMap.put(thirdObjid, synThirdInfoEntity);
                    }
                }
            }
            log.debug("===========\u540c\u6b65\u4f01\u4e1a\u5fae\u4fe1\u7528\u6237\u4fe1\u606f\u53cd\u9988===========deptListMsg" + deptListMsg);
            log.debug("===========\u540c\u6b65\u4f01\u4e1a\u5fae\u4fe1\u7528\u6237\u4fe1\u606f\u53cd\u9988===========userListMsg" + userListMsg);
            if (!saveUserMap.isEmpty()) {
                for (String key : saveUserMap.keySet()) {
                    UserEntity userEntity = (UserEntity)saveUserMap.get(key);
                    this.validateCommonUtil.convertPosition(savePositionMap, userEntity);
                    userBatch.add(userEntity);
                }
            }
            if (!saveThirdMap.isEmpty()) {
                for (String key : saveThirdMap.keySet()) {
                    synThirdInfoBatch.add(saveThirdMap.get(key));
                }
            }
            if (!savePositionMap.isEmpty()) {
                for (String key : savePositionMap.keySet()) {
                    positionBatch.add(savePositionMap.get(key));
                }
            }
            if (StringUtils.isNotEmpty(userBatch) && StringUtils.isNotEmpty(synThirdInfoBatch)) {
                for (UserEntity entity : userBatch) {
                    this.userService.saveOrUpdateCommon(entity.getId(), entity);
                }
                this.positionService.saveOrUpdateBatch(positionBatch);
                this.userService.saveOrUpdateBatch(userBatch);
                this.synThirdInfoService.saveOrUpdateBatch(synThirdInfoBatch);
                SynThirdTotal synThirdTotal = this.synThirdInfoService.getSynTotal("1", "2");
                return ActionResult.success((Object)synThirdTotal);
            }
            return ActionResult.fail((String)"\u83b7\u53d6\u7528\u6237\u6570\u636e\u4e3a\u7a7a");
        }
        catch (Exception e) {
            e.printStackTrace();
            return ActionResult.fail((String)("\u7cfb\u7edf\u8fd0\u884c\u65f6\u5f02\u5e38\uff1a" + e));
        }
    }
}

