/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.msgcenter.service.strategy;

import cn.hutool.core.collection.CollectionUtil;
import com.bringspring.common.base.UserInfo;
import com.bringspring.system.msgcenter.entity.McTaskMsgContentEntity;
import com.bringspring.system.msgcenter.entity.McTaskMsgReceiveEntity;
import com.bringspring.system.msgcenter.exception.SendMessageException;
import com.bringspring.system.msgcenter.model.mcmsgsendtemplate.McMsgSendTemplateModel;
import com.bringspring.system.msgcenter.service.McTaskMsgReceiveService;
import com.bringspring.system.msgcenter.service.context.SendMessageContext;
import com.bringspring.system.msgcenter.service.strategy.MessageSender;
import com.bringspring.system.msgcenter.service.strategy.factory.MessageSenderFactory;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SendMessageService {
    private static final Logger log = LoggerFactory.getLogger(SendMessageService.class);
    private final MessageSenderFactory senderFactory;
    private final McTaskMsgReceiveService mcTaskMsgReceiveService;

    @Autowired
    public SendMessageService(MessageSenderFactory senderFactory, McTaskMsgReceiveService mcTaskMsgReceiveService) {
        this.senderFactory = senderFactory;
        this.mcTaskMsgReceiveService = mcTaskMsgReceiveService;
    }

    public void sendMessageByChannel(boolean isAgain, String toType, McMsgSendTemplateModel sendTemplate, McTaskMsgContentEntity taskMsgContent, List<McTaskMsgReceiveEntity> receiveList, UserInfo currentUserInfo) {
        if (CollectionUtil.isEmpty(receiveList)) {
            log.warn("\u7a7a\u63a5\u6536\u4eba\u5217\u8868");
            return;
        }
        String channelType = sendTemplate.getMessageType();
        try {
            MessageSender sender = this.senderFactory.getSender(channelType);
            if (sender == null) {
                log.error("\u4e0d\u652f\u6301\u7684\u6e20\u9053\u7c7b\u578b: {}", (Object)channelType);
                return;
            }
            SendMessageContext context = new SendMessageContext();
            context.setAgain(isAgain);
            context.setToType(toType);
            context.setSendTemplate(sendTemplate);
            context.setTaskMsgContent(taskMsgContent);
            context.setReceiveList(receiveList);
            context.setCurrentUser(currentUserInfo);
            sender.send(context);
        }
        catch (SendMessageException e) {
            log.error("\u6d88\u606f\u53d1\u9001\u5931\u8d25 | \u6e20\u9053\u7c7b\u578b: {}", (Object)channelType, (Object)e);
            this.mcTaskMsgReceiveService.updateByList(isAgain, CollectionUtil.isEmpty(e.getReceiveList()) ? receiveList : e.getReceiveList(), e.getErrorCode(), e.getErrorMessage(), currentUserInfo);
        }
    }
}

