/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.permission.aop;

import com.bringspring.common.util.UserProvider;
import com.bringspring.system.permission.aop.PermissionAdminBase;
import com.bringspring.system.permission.entity.OrganizeRelationEntity;
import com.bringspring.system.permission.model.authorize.SaveBatchForm;
import com.bringspring.system.permission.service.OrganizeRelationService;
import com.bringspring.system.permission.util.PermissionAspectUtil;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class PermissionAdminAspect
implements PermissionAdminBase {
    private static final Logger log = LoggerFactory.getLogger(PermissionAdminAspect.class);
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private OrganizeRelationService organizeRelationService;

    @Pointcut(value="@annotation(com.bringspring.common.annotation.OrganizeAdminIsTrator)")
    public void pointcut() {
    }

    @Around(value="pointcut()")
    public Object around(ProceedingJoinPoint pjp) throws Throwable {
        return PermissionAdminBase.permissionCommon(pjp, this.userProvider, this);
    }

    @Override
    public Boolean detailPermission(ProceedingJoinPoint pjp, String operatorUserId, String methodName) {
        switch (methodName) {
            case "save": {
                if (this.userProvider.get().getIsAdministrator().booleanValue()) {
                    return true;
                }
                String roleId = (String)pjp.getArgs()[0];
                List orgIdList = this.organizeRelationService.getRelationListByRoleId(roleId).stream().map(OrganizeRelationEntity::getOrganizeId).collect(Collectors.toList());
                StringBuilder orgId = new StringBuilder();
                orgIdList.stream().forEach(t -> orgId.append(t + ","));
                return PermissionAspectUtil.getPermitByOrgIds(orgId.toString(), operatorUserId, "update");
            }
            case "saveBatch": {
                if (this.userProvider.get().getIsAdministrator().booleanValue()) {
                    return true;
                }
                SaveBatchForm saveBatchForm = (SaveBatchForm)pjp.getArgs()[0];
                List<String> list = Arrays.asList(saveBatchForm.getRoleIds());
                if (list.size() == 0) {
                    list.add("");
                }
                List orgIdLists = this.organizeRelationService.getRelationListByRoleIdList(list).stream().map(OrganizeRelationEntity::getOrganizeId).collect(Collectors.toList());
                StringBuilder orgIds = new StringBuilder();
                orgIdLists.stream().forEach(t -> orgIds.append(t + ","));
                return PermissionAspectUtil.getPermitByOrgIds(orgIds.toString(), operatorUserId, "update");
            }
            case "update": {
                String organizeId = String.valueOf(pjp.getArgs()[0]);
                return PermissionAspectUtil.containPermission(organizeId, operatorUserId, methodName);
            }
        }
        return false;
    }
}

