/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.permission.aop;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.URLUtil;
import com.bringspring.common.annotation.HandleLog;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.util.IpUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.ServletUtils;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.system.base.entity.LogEntity;
import com.bringspring.system.base.enums.LogSortEnum;
import com.bringspring.system.base.service.LogService;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.Executor;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Aspect
@Component
@Order(value=2)
public class RequestLogAspect {
    private static final Logger log = LoggerFactory.getLogger(RequestLogAspect.class);
    @Autowired
    UserProvider userProvider;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private LogService logService;
    @Autowired
    private Executor executor;

    @Pointcut(value="(execution(* com.bringspring..*.controller.*.*(..)) || execution(* com.bringspring.system.message.websocket.WebSocket.*(..)))&&!execution(* com.bringspring.files.controller.UtilsController.*(..)) ")
    public void requestLog() {
    }

    @Around(value="requestLog()")
    public Object doAroundService(ProceedingJoinPoint pjp) throws Throwable {
        long startTime = System.currentTimeMillis();
        Object obj = pjp.proceed();
        long costTime = System.currentTimeMillis() - startTime;
        UserInfo userInfo = this.userProvider.get();
        this.printLog(userInfo, costTime);
        try {
            MethodSignature methodSignature = (MethodSignature)pjp.getSignature();
            Object[] args = pjp.getArgs();
            Method method = methodSignature.getMethod();
            HandleLog methodAnnotation = method.getAnnotation(HandleLog.class);
            if (methodAnnotation != null) {
                String moduleName = methodAnnotation.moduleName();
                String requestMethod = methodAnnotation.requestMethod();
                this.handleLog(userInfo, costTime, obj, moduleName, requestMethod, args);
            }
        }
        catch (Exception e) {
            log.error("\u8bb0\u5f55\u64cd\u4f5c\u65e5\u5fd7\u53d1\u751f\u9519\u8bef\uff1a" + e.getMessage());
        }
        return obj;
    }

    private void printLog(UserInfo userInfo, long costTime) {
        Map parameterMap;
        String moduleHref;
        String moduleName;
        if (StringUtils.isEmpty((String)userInfo.getUserId())) {
            return;
        }
        LogEntity entity = new LogEntity();
        entity.setId(RandomUtil.uuId());
        entity.setCategory(LogSortEnum.Request.getCode());
        entity.setUserId(userInfo.getUserId());
        entity.setUserName(userInfo.getRealName() + "/" + userInfo.getUserAccount());
        entity.setRequestDuration((int)costTime);
        entity.setRequestUrl(ServletUtils.getRequest().getServletPath());
        entity.setRequestMethod(ServletUtils.getRequest().getMethod());
        String clientType = ServletUtils.getRequest().getHeader("jsbos-origin");
        if (StringUtils.isNotEmpty((String)clientType) && clientType.equals("pc")) {
            entity.setType(1);
        } else {
            entity.setType(2);
        }
        String moduleId = ServletUtils.getRequest().getHeader("Module-Id");
        if (StringUtils.isNotEmpty((String)moduleId)) {
            entity.setModuleId(moduleId);
        }
        if (StringUtils.isNotEmpty((String)(moduleName = ServletUtils.getRequest().getHeader("Module-Name")))) {
            entity.setModuleName(URLUtil.decode((String)moduleName));
        }
        if (StringUtils.isNotEmpty((String)(moduleHref = ServletUtils.getRequest().getHeader("Module-Href")))) {
            entity.setObjectId(URLUtil.decode((String)moduleHref));
        }
        if (CollectionUtil.isNotEmpty((Map)(parameterMap = ServletUtils.getRequest().getParameterMap()))) {
            entity.setAbstracts(JsonUtil.getObjectToString((Object)parameterMap));
        }
        entity.setIpAddress(IpUtil.getIpAddr());
        entity.setCreatorTime(new Date());
        entity.setPlatForm(ServletUtils.getUserAgent());
        this.executor.execute(() -> this.logService.save(entity));
    }

    private void handleLog(UserInfo userInfo, long costTime, Object obj, String moduleName, String requestMethod, Object[] arg) {
        LogEntity entity = new LogEntity();
        entity.setId(RandomUtil.uuId());
        entity.setCategory(LogSortEnum.Operate.getCode());
        entity.setUserId(userInfo.getUserId());
        entity.setUserName(userInfo.getRealName() + "/" + userInfo.getUserAccount());
        entity.setRequestDuration((int)costTime);
        entity.setRequestMethod(requestMethod);
        entity.setIpAddress(IpUtil.getIpAddr());
        entity.setCreatorTime(new Date());
        entity.setPlatForm(ServletUtils.getUserAgent());
        entity.setModuleName(moduleName);
        try {
            StringBuilder stringBuilder = new StringBuilder();
            for (Object o : arg) {
                if (!(o instanceof MultipartFile)) continue;
                stringBuilder.append("{\"originalFilename\":\"" + ((MultipartFile)o).getOriginalFilename() + "\",");
                stringBuilder.append("\"contentType\":\"" + ((MultipartFile)o).getContentType() + "\",");
                stringBuilder.append("\"name\":\"" + ((MultipartFile)o).getName() + "\",");
                stringBuilder.append("\"resource\":\"" + ((MultipartFile)o).getResource() + "\",");
                stringBuilder.append("\"size\":\"" + ((MultipartFile)o).getSize() + "\"}");
            }
            if (stringBuilder.length() > 0) {
                entity.setJsons(requestMethod + "\u5e94\u7528\u3010" + stringBuilder + "\u3011\u3010" + obj + "\u3011");
            } else {
                entity.setJsons(requestMethod + "\u5e94\u7528\u3010" + JsonUtil.getObjectToString((Object)arg) + "\u3011\u3010" + obj + "\u3011");
            }
        }
        catch (Exception e) {
            entity.setJsons(requestMethod + "\u5e94\u7528\u3010" + arg + "\u3011\u3010" + obj + "\u3011");
        }
        this.executor.execute(() -> this.logService.save(entity));
    }
}

