

package com.bringspring.system.base.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.system.base.entity.AreagroupEntity;
import com.bringspring.system.base.entity.ArearelationEntity;
import com.bringspring.system.base.model.areagroup.*;
import com.bringspring.system.base.service.AreagroupService;
import com.bringspring.system.base.service.ArearelationService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 区域分组管理
 *
 * @版本： V1.0.0
 * @版权： 荣科科技股份有限公司
 * @作者： RKKJ开发平台组
 * @日期： 2025-05-13
 */
@Slf4j
@RestController
@Api(tags = "区域分组管理", value = "system")
@RequestMapping("/api/system/Areagroup")
public class AreagroupController {

    @Autowired
    private BaseDataUtil baseDataUtil;


    @Autowired
    private UserProvider userProvider;

    @Autowired
    private AreagroupService areagroupService;

    @Autowired
    private ArearelationService arearelationService;


    /**
     * 区域分组管理列表
     *
     * @param areagroupPagination
     * @return
     */
    @PostMapping("/getList")
    @ApiOperation("区域分组管理列表")
    public ActionResult list(@RequestBody AreagroupPagination areagroupPagination) throws IOException {
        List<AreagroupEntity> list = areagroupService.getList(areagroupPagination);
        //处理id字段转名称，若无需转或者为空可删除
        for (AreagroupEntity entity : list) {
//            entity.setType(baseDataUtil.getDictName(entity.getType(), "691995563444407301"));
        }
        List<AreagroupListVO> listVO = JsonUtil.getJsonToList(list, AreagroupListVO.class);
        for (AreagroupListVO areagroupVO : listVO) {
            // 查询关联表数据
            List<String> collect = arearelationService.getList(null, areagroupVO.getId()).stream().map(v -> v.getProvinceId()).collect(Collectors.toList());
            areagroupVO.setAreaList(collect);
            areagroupVO.setCompanyName(baseDataUtil.comSelectValue(areagroupVO.getCompanyId(), null));
            areagroupVO.setDirectlyOrgName(baseDataUtil.comSelectValue(areagroupVO.getDirectlyOrgId(), null));
        }

        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = JsonUtil.getJsonToBean(areagroupPagination, PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success(vo);
    }


    /**
     * 区域分组管理创建
     *
     * @param areagroupCrForm
     * @return
     */
    @ApiOperation("区域分组管理创建")
    @PostMapping
    public ActionResult create(@RequestBody @Valid AreagroupCrForm areagroupCrForm) throws DataException {
        areagroupService.create(areagroupCrForm);
        return ActionResult.success("创建成功");
    }


    /**
     * 区域分组管理信息
     *
     * @param id
     * @return
     */
    @ApiOperation("区域分组管理信息")
    @GetMapping("/{id}")
    public ActionResult<AreagroupInfoVO> info(@PathVariable("id") String id) {
        AreagroupEntity entity = areagroupService.getInfo(id);
        AreagroupInfoVO vo = JsonUtil.getJsonToBean(entity, AreagroupInfoVO.class);
        return ActionResult.success(vo);
    }

    /**
     * 区域分组管理表单信息(详情页)
     *
     * @param id
     * @return
     */
    @ApiOperation("区域分组管理表单信息(详情页)")
    @GetMapping("/detail/{id}")
    public ActionResult<AreagroupInfoVO> detailInfo(@PathVariable("id") String id) {
        AreagroupEntity entity = areagroupService.getInfo(id);
        AreagroupInfoVO vo = JsonUtil.getJsonToBean(entity, AreagroupInfoVO.class);
        vo.setType(baseDataUtil.getDictName(vo.getType(), "691995563444407301"));

        return ActionResult.success(vo);
    }


    /**
     * 区域分组管理更新
     *
     * @param id
     * @return
     */
    @ApiOperation("区域分组管理更新")
    @PutMapping("/{id}")
    public ActionResult update(@PathVariable("id") String id, @RequestBody @Valid AreagroupUpForm areagroupUpForm) throws DataException {
        areagroupService.update(id, areagroupUpForm);
        return ActionResult.success("更新成功");
    }


    /**
     * 区域分组管理删除
     *
     * @param id
     * @return
     */
    @ApiOperation("区域分组管理删除")
    @DeleteMapping("/{id}")
    public ActionResult delete(@PathVariable("id") String id) {
        AreagroupEntity entity = areagroupService.getInfo(id);
        if (entity != null) {
            areagroupService.delete(entity);

        }
        return ActionResult.success("删除成功");
    }


    /**
     * 查询分组内区域
     *
     * @param areagroupCrForm
     * @return
     */
    @ApiOperation("查询分组内区域")
    @PostMapping("/getAreaList")
    public ActionResult getAreaList(@RequestBody @Valid AreagroupCrForm areagroupCrForm) {
        List<String> collect = arearelationService.getList(null, areagroupCrForm.getId()).stream().map(v -> v.getProvinceId()).collect(Collectors.toList());
        return ActionResult.success(collect);
    }

    /**
     * 创建分组内区域
     *
     * @param areagroupCrForm
     * @return
     */
    @ApiOperation("创建分组内区域")
    @PostMapping("/creatAreaList")
    public ActionResult creatAreaList(@RequestBody @Valid AreagroupCrForm areagroupCrForm) {
        // 创建之前删除原有关联数据
        QueryWrapper<ArearelationEntity> arearelationDelete = new QueryWrapper<>();
        arearelationDelete.lambda().eq(ArearelationEntity::getObjectId, areagroupCrForm.getId());
        arearelationService.remove(arearelationDelete);
        // 创建关联数据
        List<ArearelationEntity> arearelationList = arearelationService.list(arearelationDelete);
        List<String> areaList = areagroupCrForm.getAreaList();
        areaList.forEach(v -> {
            ArearelationEntity arearelationEntity = new ArearelationEntity();
            arearelationEntity.setId(RandomUtil.uuId());
            arearelationEntity.setProvinceId(v);
            List<String> provinceList = JsonUtil.getJsonToList(v, String.class);
            if (provinceList.size() > 1) {
                arearelationEntity.setProvId(provinceList.get(1));
            }
            if (provinceList.size() > 2) {
                arearelationEntity.setCityId(provinceList.get(2));
            }
            arearelationEntity.setObjectType("group");
            arearelationEntity.setObjectId(areagroupCrForm.getId());
            arearelationList.add(arearelationEntity);
        });
        boolean b = arearelationService.saveBatch(arearelationList);
        return ActionResult.success(b);
    }
}
