package com.bringspring.system.base.service;


import com.baomidou.mybatisplus.extension.service.IService;
import com.bringspring.system.base.entity.AreagroupEntity;
import com.bringspring.system.base.entity.ProvinceEntity;
import com.bringspring.system.base.model.areagroup.AreagroupCrForm;
import com.bringspring.system.base.model.areagroup.AreagroupPagination;
import com.bringspring.system.base.model.areagroup.AreagroupUpForm;

import java.util.List;

/**
 * 区域分组管理
 * 版本： V1.0.0
 * 版权： 荣科科技股份有限公司
 * 作者： RKKJ开发平台组
 * 日期： 2025-05-13
 */
public interface AreagroupService extends IService<AreagroupEntity> {

    /**
     * 区域分组管理列表分页查询
     *
     * @param areagroupPagination 查询参数
     * @return List<AreagroupEntity>
     */
    List<AreagroupEntity> getList(AreagroupPagination areagroupPagination);

    /**
     * 区域分组管理列表分页查询（导出使用）
     *
     * @param areagroupPagination 查询参数
     * @param dataType            0-当前页；非0-当前查询条件所有数据
     * @return List<AreagroupEntity>
     */
    List<AreagroupEntity> getTypeList(AreagroupPagination areagroupPagination, String dataType);


    /**
     * 获取区域分组管理详细信息
     *
     * @param id 主键
     * @return AreagroupEntity
     */
    AreagroupEntity getInfo(String id);

    /**
     * 删除区域分组管理操作
     *
     * @param entity
     * @return
     */
    void delete(AreagroupEntity entity);

    /**
     * 创建区域分组管理操作
     *
     * @param areagroupCrForm 主键
     * @return boolean 是否成功
     */
    void create(AreagroupCrForm areagroupCrForm);

    /**
     * 更新区域分组管理操作
     *
     * @param id              主键
     * @param areagroupUpForm 主键
     * @return boolean 是否成功
     */
    void update(String id, AreagroupUpForm areagroupUpForm);

    /**
     * 省市区单条数据集合
     *
     * @param ProIdList 省市区id集合
     * @return
     */
    List<AreagroupEntity> getProList(List<String> ProIdList);
    /**
     * 根据公司和菜单id查询区域id列表
     * @param companyId
     * @return
     */
    List<String> getAreaIdsByCompanyId(String companyId,String modelId);

    /**
     *
     * @param companyId
     * @return
     */
    List<AreagroupEntity> getListByCompanyType(String companyId,String modelId);

    /**
     * 地区组转大区
     */
    List<List<String>> areaGroupToArea(List<List<String>> address);
}
