package com.bringspring.system.base.service;


import com.baomidou.mybatisplus.extension.service.IService;
import com.bringspring.common.base.Pagination;
import com.bringspring.system.base.entity.DataInterfaceLogEntity;

import java.util.List;

/**
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2021/3/12 15:31
 */
public interface DataInterfaceLogService extends IService<DataInterfaceLogEntity> {

    /**
     * 添加日志
     *
     * @param dateInterfaceId 接口Id
     * @param invokWasteTime  执行时间
     */
    void create(String dateInterfaceId, Integer invokWasteTime);

    /**
     * 获取调用日志列表
     *
     * @param invokId    接口id
     * @param pagination 分页参数
     * @return ignore
     */
    List<DataInterfaceLogEntity> getList(String invokId, Pagination pagination);

}
