package com.bringspring.system.base.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.system.base.entity.ModuleEntity;
import com.bringspring.system.base.model.module.ModuleExportModel;

import java.util.List;

/**
 * 系统功能
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2017年9月27日 上午9:18
 */
public interface ModuleService extends IService<ModuleEntity> {

    /**
     * 列表
     *
     * @return ignore
     */
    List<ModuleEntity> getList();

    /**
     * 列表
     *
     * @param category
     * @param keyword
     * @param parentId
     * @return ignore
     */
    List<ModuleEntity> getList(String category, String keyword, String type, String enabledMark, String parentId);

    /**
     * 列表 扩展一个enCode参数
     * @param category
     * @param keyword
     * @param type
     * @param enabledMark
     * @param parentId
     * @param enCode
     * @return
     */
    List<ModuleEntity> getList(String category, String keyword, String type, String enabledMark, String parentId, String enCode);

    /**
     * 通过id获取子菜单
     *
     * @param id 主键
     * @return ignore
     */
    List<ModuleEntity> getList(String id);

    /**
     * 信息
     *
     * @param id 主键值
     * @return ignore
     */
    ModuleEntity getInfo(String id);

    /**
     * 根据编码获取有效的菜单信息
     *
     * @param enCode 编码
     * @return ignore
     */
    ModuleEntity getByEnCode(String enCode);

    /**
     * 验证名称
     *
     * @param entity   ignore
     * @param category 分类
     * @return ignore
     */
    boolean isExistByFullName(ModuleEntity entity, String category);

    /**
     * 验证编码
     *
     * @param entity   实体
     * @param category 分类
     * @return ignore
     */
    boolean isExistByEnCode(ModuleEntity entity, String category);

    /**
     * 删除
     *
     * @param entity 实体对象
     */
    void delete(ModuleEntity entity);


    /**
     * 删除权限（同步菜单 不处理数据权限）
     *
     * @param entity 实体对象
     */
    void deleteModule(ModuleEntity entity);
    /**
     * 创建
     *
     * @param entity 实体对象
     */
    void create(ModuleEntity entity);

    /**
     * 更新
     *
     * @param id     主键值
     * @param entity 实体对象
     * @return ignore
     */
    boolean update(String id, ModuleEntity entity);

    /**
     * 导出数据
     *
     * @param id 主键
     * @return DownloadVO ignore
     */
    DownloadVO exportData(String id);

    /**
     * 导入数据
     *
     * @param exportModel 导出模型
     * @return ignore
     * @throws DataException ignore
     */
    boolean importData(ModuleExportModel exportModel) throws DataException;

    /**
     * 功能设计发布功能自动创建app pc菜单
     * @return
     */
    List<ModuleEntity> getModuleList(String visualId);


    /**
     * 根据property查询数据（门户id）
     * @return
     */
    List<ModuleEntity> getModuleListByProperty(String property);

    /**
     * 获取父级组织id Tree
     * 例如：1,2,3
     *
     * @param entity
     * @return
     */
    public String getParentIds(ModuleEntity entity);
}
