package com.bringspring.system.base.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.bringspring.common.base.Page;
import com.bringspring.system.base.entity.AreagroupEntity;
import com.bringspring.system.base.entity.ProvinceEntity;
import com.bringspring.system.base.model.areagroup.AreagroupQuery;
import com.bringspring.system.base.model.province.ProvinceListQuery;

import java.util.List;

/**
 * 行政区划
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2017年9月27日 上午9:18
 */
public interface ProvinceService extends IService<ProvinceEntity> {


    /**
     * 验证名称
     *
     * @param fullName 名称
     * @param id       主键值
     * @return ignore
     */
    boolean isExistByFullName(String fullName, String id);

    /**
     * 验证编码
     *
     * @param enCode 编码
     * @param id     主键值
     * @return ignore
     */
    boolean isExistByEnCode(String enCode, String id);

    /**
     * 根据父节点Id查询下级行政区划
     *
     * @param parentId 节点Id
     * @return ignore
     */
    List<ProvinceEntity> getListByParentId(String parentId);

    /**
     * 根据父节点Id查询下级行政区划带权限
     *
     * @param parentId 节点Id
     * @return ignore
     */
    List<ProvinceEntity> getListByParentIdAuth(String parentId,String modelId);

    /**
     * 根据上级区划id和分组类型、公司id获取行政区划下拉框数据带权限
     *
     * @param areagroupQuery 节点Id
     * @return ignore
     */
    List<ProvinceEntity> SelectorAuthByGroup(String groupId);

    /**
     * 根据上级区划id和分组类型、公司id获取行政区划下拉框数据带权限
     *
     * @param areagroupQuery 节点Id
     * @return ignore
     */
    List<ProvinceEntity> SelectorAuthByGroupLevelOne(AreagroupQuery areagroupQuery);

    /**
     * 根据城市级别查询地市
     *
     * @param cityLevel 城市级别
     * @return
     */
    List<ProvinceEntity> getListByCityLevel(String cityLevel);

    /**
     * 根据节点Id查询下级行政区划
     *
     * @param parentId 节点Id
     * @param page
     * @return ignore
     */
    List<ProvinceEntity> getListByNodeId(String parentId, Page page);

    List<ProvinceEntity> getListAll(ProvinceListQuery query);

    /**
     * 普通列表
     *
     * @return ignore
     */
    List<ProvinceEntity> getAllList();


    /**
     * 省市区单条数据集合(代码生成器)
     *
     * @param ProIdList 省市区id集合
     * @return
     */
    List<ProvinceEntity> getProList(List<String> ProIdList);


    /**
     * 地域名列表（在线开发）
     *
     * @return ignore
     */
    List<ProvinceEntity> getAllProList();

    /**
     * 信息
     *
     * @param id 主键值
     * @return ignore
     */
    ProvinceEntity getInfo(String id);

    /**
     * 删除
     *
     * @param entity 实体对象
     */
    void delete(ProvinceEntity entity);

    /**
     * 创建
     *
     * @param entity 实体对象
     */
    void create(ProvinceEntity entity);

    /**
     * 更新
     *
     * @param id     主键值
     * @param entity 实体对象
     * @return ignore
     */
    boolean update(String id, ProvinceEntity entity);

    /**
     * 上移
     *
     * @param id 主键值
     * @return ignore
     */
    boolean first(String id);

    /**
     * 下移
     *
     * @param id 主键值
     * @return ignore
     */
    boolean next(String id);

    /**
     * 获取行政规划列表
     *
     * @param list 数组
     * @return ignore
     */
    List<ProvinceEntity> infoList(List<String> list);

    /**
     * 地址文字转id数组
     */
    String getAreaIds(String str);
}
