package com.bringspring.system.external.config.mutil;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.system.base.entity.SysConfigEntity;
import com.bringspring.system.base.exception.BaseException;
import com.bringspring.system.base.service.SysConfigService;
import com.bringspring.system.msgcenter.entity.McMsgAccountEntity;
import com.bringspring.system.msgcenter.model.message.MyDingTalkModel;
import com.bringspring.system.msgcenter.service.McMsgAccountService;
import com.google.common.collect.Maps;
import me.chanjar.weixin.common.error.WxRuntimeException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import static com.bringspring.system.external.constant.DingTalkConfigConsts.DING_COM;
import static com.bringspring.system.msgcenter.enums.ChannelTypeEnum.DING_MSG;

/**
 * 多实例配置
 */
@Component
public class DingTalkConfiguration {

    @Autowired
    private SysConfigService sysConfigService;
    @Autowired
    private McMsgAccountService mcMsgAccountService;

    private Map<String, MyDingTalkModel> dingTalkModels = Maps.newHashMap();

    public Map<String, MyDingTalkModel> getDingTalkModels() {
        return dingTalkModels;
    }

    public MyDingTalkModel getDingTalkModel(String corpId) {
        MyDingTalkModel dingTalkModel = dingTalkModels.get(corpId);
        if (ObjectUtil.isEmpty(dingTalkModel)) {
            initModels();
            dingTalkModel = dingTalkModels.get(corpId);
        }
        return dingTalkModel;
    }

    public void initModels() {
        try {
            List<McMsgAccountEntity> account = mcMsgAccountService.getAccountByCategory(DING_MSG.getCode());
            if (CollectionUtil.isEmpty(account)) {
                throw new WxRuntimeException("未添加阿里钉钉相关应用配置！");
            }
            List<MyDingTalkModel> listModel = new ArrayList<>();
            account.stream().forEach(a -> {
                MyDingTalkModel dingModel = new MyDingTalkModel();
                dingModel.setAccountConfigId(a.getId()); // 应用配置ID
                dingModel.setName(a.getFullName()); // 名称
                dingModel.setCorpId(a.getEnterpriseId()); // 企业id
                dingModel.setApiToken(a.getBearer()); // 应用Secret
                dingModel.setAppId(a.getAppId()); //  App ID
                dingModel.setAgentId(a.getAgentId()); // AgentId
                dingModel.setClientId(a.getAppKey()); // Client ID (原 AppKey 和 SuiteKey)
                dingModel.setClientSecrent(a.getAppSecret()); //  Client Secret (原 AppSecret 和 SuiteSecret)
                dingModel.setDingMobileUrl(a.getAddress()); // 应用访问地址
                listModel.add(dingModel);
            });

            SysConfigEntity dingComInfo = sysConfigService.getConfigByKeyName(DING_COM);
            if (ObjectUtil.isNotEmpty(dingComInfo) && StringUtils.isNotEmpty(dingComInfo.getKeyValue())) {
                String keyValue = dingComInfo.getKeyValue();
                List<MyDingTalkModel> sysConfig = JsonUtil.getJsonToList(keyValue, MyDingTalkModel.class);
                sysConfig.stream().forEach(a -> {
                    listModel.stream().forEach(b -> {
                        if (b.getAccountConfigId().equals(a.getAccountConfigId())) {
                            b.setDingSynIsSynOrg(a.getDingSynIsSynOrg()); // 启用同步组织
                            b.setDingSynIsSynUser(a.getDingSynIsSynUser()); // 启用同步用户
                            b.setOrgParent(a.getOrgParent()); // 所属组织
                        }
                    });
                });
            }

            dingTalkModels = listModel.stream().collect(Collectors.toMap(model -> model.getCorpId(), a -> a));
        } catch (BaseException e) {
            e.printStackTrace();
        }
    }
}
