package com.bringspring.system.message.controller;


import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.net.URLEncodeUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.bringspring.common.annotation.NotCheckLogin;
import com.bringspring.common.annotation.NotRecordedLog;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.Pagination;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.model.login.BaseSystemInfo;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.system.base.entity.MessageTemplateEntity;
import com.bringspring.system.base.entity.SysConfigEntity;
import com.bringspring.system.base.exception.BaseException;
import com.bringspring.system.base.service.SysConfigService;
import com.bringspring.system.base.util.JsonUtilEx;
import com.bringspring.system.external.bean.WeComModel;
import com.bringspring.system.message.entity.MessageEntity;
import com.bringspring.system.message.entity.MessageReceiveEntity;
import com.bringspring.system.message.entity.SynThirdInfoEntity;
import com.bringspring.system.message.model.message.*;
import com.bringspring.system.message.service.MessageService;
import com.bringspring.system.message.service.SynThirdInfoService;
import com.bringspring.system.message.util.JsbosMessageUtil;
import com.bringspring.system.message.util.QyWebChatUtil;
import com.bringspring.system.message.util.SentMessageUtil;
import com.bringspring.system.message.util.SynThirdConsts;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.entity.UserRelationEntity;
import com.bringspring.system.permission.service.RangeService;
import com.bringspring.system.permission.service.UserRelationService;
import com.bringspring.system.permission.service.UserService;
import com.github.pagehelper.util.StringUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.text.StringSubstitutor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.*;
import java.util.stream.Collectors;

import static com.bringspring.system.external.constant.WxCpSysConfigConsts.WECOM_KEY_NAME;

/**
 * 系统公告
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2017年9月27日 上午9:18
 */
@Slf4j
@Api(tags = "系统公告", value = "Message")
@RestController
@RequestMapping("/api/message")
public class MessageController {

    @Autowired
    private MessageService messageService;
    @Autowired
    private UserService userService;
    @Autowired
    private UserRelationService userRelationService;
    @Autowired
    private SysConfigService sysConfigService;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private SynThirdInfoService synThirdInfoService;
    @Autowired
    private SentMessageUtil sentMessageUtil;

    @Autowired
    private RangeService rangeService;

    /**
     * 列表（通知公告）
     *
     * @param pagination
     * @return
     */
    @NotRecordedLog
    @ApiOperation("获取系统公告列表（带分页）")
    @GetMapping("/Notice")
    public ActionResult<PageListVO<MessageNoticeVO>> noticeList(NoticePagination pagination) {
        List<MessageEntity> list = messageService.getNoticeList(pagination);
        List<UserEntity> userList = userService.getUserName(list.stream().map(t -> t.getCreatorUserId()).collect(Collectors.toList()));
        for (MessageEntity entity : list) {
            UserEntity user = userList.stream().filter(t -> t.getId().equals(entity.getCreatorUserId())).findFirst().orElse(null);
            entity.setCreatorUserId(user != null ? user.getRealName() : "");
        }
        PaginationVO paginationVO = JsonUtil.getJsonToBean(pagination, PaginationVO.class);
        List<MessageNoticeVO> voList = JsonUtil.getJsonToList(list, MessageNoticeVO.class);
        return ActionResult.page(voList, paginationVO);
    }

    /**
     * 添加系统公告
     *
     * @param noticeCrForm 实体对象
     * @return
     */
    @ApiOperation("添加系统公告")
    @PostMapping
    public ActionResult create(@RequestBody @Valid NoticeCrForm noticeCrForm) {
        MessageEntity entity = JsonUtil.getJsonToBean(noticeCrForm, MessageEntity.class);
//        switch (entity.getSendType()) {
////           部门
//            case "department":
//                List<String> departmentList = Arrays.asList(entity.getSendId().split(","));
//                List<String> userIds = userRelationService.getListByOrgId(departmentList).stream().map(UserRelationEntity::getUserId).collect(Collectors.toList());
//                entity.setToUserIds(String.join(",", userIds));
//        }
        String sendRange = entity.getSendRange();
        if ("user".equals(entity.getSendType())) {
            List<UserEntity> rangeUserList = rangeService.getRangeUserList(sendRange);
            List<String> ids = rangeUserList.stream()
                    .map(UserEntity::getId)
                    .collect(Collectors.toList());
            entity.setToUserIds(String.join(",", ids));
        }

        messageService.create(entity);
        return ActionResult.success(MsgCode.SU001.get());
    }

    /**
     * 修改系统公告
     *
     * @param id            主键值
     * @param messageUpForm 实体对象
     * @return
     */
    @ApiOperation("修改系统公告")
    @PutMapping("/{id}")
    public ActionResult update(@PathVariable("id") String id, @RequestBody @Valid NoticeUpForm messageUpForm) {
        MessageEntity entity = JsonUtil.getJsonToBean(messageUpForm, MessageEntity.class);
        String sendRange = entity.getSendRange();
        if ("user".equals(entity.getSendType())) {
            List<UserEntity> rangeUserList = rangeService.getRangeUserList(sendRange);
            List<String> ids = rangeUserList.stream()
                    .map(UserEntity::getId)
                    .collect(Collectors.toList());
            entity.setToUserIds(String.join(",", ids));
        }
        boolean flag = messageService.update(id, entity);
        if (!flag) {
            return ActionResult.fail(MsgCode.FA002.get());
        }
        return ActionResult.success(MsgCode.SU004.get());
    }

    /**
     * 信息
     *
     * @param id 主键值
     * @return
     */
    @NotRecordedLog
    @ApiOperation("获取/查看系统公告信息")
    @GetMapping("/{id}")
    public ActionResult<NoticeInfoVO> info(@PathVariable("id") String id) throws DataException {
        MessageEntity entity = messageService.getinfo(id);
        if (entity != null) {
            UserEntity info = userService.getInfo(entity.getCreatorUserId());
            entity.setCreatorUserId(info != null ? info.getRealName() : "");
            NoticeInfoVO vo = JsonUtilEx.getJsonToBeanEx(entity, NoticeInfoVO.class);
            return ActionResult.success(vo);
        } else {
            return ActionResult.fail("该公告已撤回！");
        }


    }

    /**
     * 删除
     *
     * @param id 主键值
     * @return
     */
    @ApiOperation("删除系统公告")
    @DeleteMapping("/{id}")
    public ActionResult delete(@PathVariable("id") String id) {
        MessageEntity entity = messageService.getinfo(id);
        if (entity != null) {
            messageService.delete(entity);
            return ActionResult.success(MsgCode.SU003.get());
        }
        return ActionResult.fail(MsgCode.FA003.get());
    }


    /**
     * 发布公告
     *
     * @param id 主键值
     * @return
     */
    @ApiOperation("发布系统公告")
    @Transactional
    @PutMapping("/{id}/Actions/Release")
    public ActionResult release(@PathVariable("id") String id) throws BaseException {
        MessageEntity entity = messageService.getinfo(id);
        UserInfo userInfo = userProvider.get();
        if (entity != null) {
            List<String> userIds = new ArrayList<>();
            switch (entity.getSendType()) {
                //用户
                case "user":
                    if (StringUtil.isNotEmpty(entity.getToUserIds())) {
                        userIds.addAll(Arrays.asList(entity.getToUserIds().split(",")));
                    } else {
                        userIds.addAll(userService.getListId());
                    }
                    break;
                // 部门
//                case "department":
//                    userIds.addAll(Arrays.asList(entity.getToUserIds().replaceAll(" ", "").split(",")));
//                    break;
//                全部用户
                case "@ALL":
                    break;
//                岗位
//                case "position":
            }
//            List<String> userIdList = new ArrayList<>();
            String content = "标题：" + entity.getTitle();
            String title = "发文：有新收到的公告等待您的阅读。";
//            String appurl = "/#/pages/notice/index?id=" + entity.getId() + "&msg_id=" + entity.getId() + "&type=1";
            //去掉msg_id,原因如果从公告点击进系统，退出后从移动端企微入口进入智行平台会报错。
            String appurl = "/#/pages/notice/index?id=" + entity.getId() + "&type=1";

            String pcurl = "/#/basic/messageRecord?id=" + entity.getId() + "&type=1";
//          /#/messageRecord?applicationId=all
            if (entity.getSendType().equals("@ALL")) {
                messageService.newSendMessage("公告", "noticeMessage", title, content, appurl, pcurl, userIds, "@ALL");
            } else {
                messageService.newSendMessage("公告", "noticeMessage", title, content, appurl, pcurl, userIds, "user");
            }

            entity.setEnabledMark(1);
            entity.setLastModifyTime(new Date());
            entity.setLastModifyUserId(userInfo.getUserId());
            entity.setPublishTime(new Date());
            messageService.updateById(entity);
//            messageService.sentNotice(userIdList, entity);
//            MessageTemplateEntity messageTemplateEntity = new MessageTemplateEntity();
//            messageTemplateEntity.setTitle("发文：有新收到的公告等待您的阅读。");
//            messageTemplateEntity.setContent("标题：" + entity.getTitle());
//            Map<String, String> map = new HashMap<>();
//            //TODO
//            String url = sysConfigService.getSystemAddress("app");
//            map.put("AppUrl", url + "#/pages/notice/index?id=" + entity.getId() + "&type=1");

            //集合size按照500划分长度。
//            List<List<String>> userIdLists = this.splitList(userIdList, 500);
//            log.info("企业微信发送循环发送次数："+userIdLists.size());
//            for (List<String> idList : userIdLists) {
//                JSONObject jsonObject = sentMessageUtil.SendQyWebChat(idList, userProvider.get(), "1", messageTemplateEntity, map);
//                if (!(Boolean) jsonObject.get("code")) {
//                    log.error("发送企业微信消息失败，错误：" + jsonObject.get("error"));
//                }
//            }
            return ActionResult.success("发布成功");
        }
        return ActionResult.fail("发布失败");
    }
//=======================================站内消息、消息中心=================================================


    /**
     * 获取消息中心列表
     *
     * @param pagination
     * @return
     */
    @NotRecordedLog
    @ApiOperation("列表（通知公告/系统消息/私信消息）")
    @GetMapping
    public ActionResult<PageListVO<MessageInfoVO>> messageList(PaginationMessage pagination) {
        List<MessageEntity> list = messageService.getMessageList(pagination, pagination.getType(), pagination.getAppid(), pagination.getIsShowRead());
        List<UserEntity> userList = userService.getUserName(list.stream().map(t -> t.getCreatorUserId()).collect(Collectors.toList()));
        for (MessageEntity entity : list) {
            UserEntity user = userList.stream().filter(t -> t.getId().equals(entity.getCreatorUserId())).findFirst().orElse(null);
            entity.setCreatorUserId(user != null ? user.getRealName() : "");
        }
        List<MessageInfoVO> listVO = JsonUtil.getJsonToList(list, MessageInfoVO.class);
        PaginationVO paginationVO = JsonUtil.getJsonToBean(pagination, PaginationVO.class);
        return ActionResult.page(listVO, paginationVO);
    }


    /**
     * 只获取公告消息列表
     *
     * @param pagination
     * @return
     */
    @NotRecordedLog
    @ApiOperation("只获取公告消息列表")
    @GetMapping("/getNoticeListByType")
    public ActionResult<PageListVO<MessageInfoVO>> getNoticeListByType(PaginationMessage pagination) {
        List<MessageEntity> list = messageService.getNoticeListByType(pagination, pagination.getType());
        List<UserEntity> userList = userService.getUserName(list.stream().map(t -> t.getCreatorUserId()).collect(Collectors.toList()));
        for (MessageEntity entity : list) {
            UserEntity user = userList.stream().filter(t -> t.getId().equals(entity.getCreatorUserId())).findFirst().orElse(null);
            entity.setCreatorUserId(user != null ? user.getRealName() : "");
        }
        List<MessageInfoVO> listVO = JsonUtil.getJsonToList(list, MessageInfoVO.class);
        PaginationVO paginationVO = JsonUtil.getJsonToBean(pagination, PaginationVO.class);
        return ActionResult.page(listVO, paginationVO);
    }

    /**
     * 查看未读消息数
     *
     * @param userId
     * @return
     */
    @NotRecordedLog
    @ApiOperation("列表（通知公告/系统消息/私信消息）")
    @PostMapping("/getUnreadCount")
    public ActionResult<Integer> getUnreadCount(String userId) {
        int unreadCount = messageService.getUnreadCount(userId);

        return ActionResult.success(unreadCount);
    }


    /**
     * 读取消息
     *
     * @param id 主键值
     * @return
     */
    @ApiOperation("读取消息")
    @NotCheckLogin
    @GetMapping("/ReadInfo/{id}")
    public ActionResult readInfo(@PathVariable("id") String id) throws DataException {
        MessageEntity entity = messageService.getinfo(id);
        if (entity != null) {
            String bodyText = entity.getBodyText();
            MessageReceiveEntity receive = messageService.messageRead(id);
            UserEntity user = userService.getInfo(entity.getCreatorUserId());
            entity.setCreatorUserId(user != null ? user.getRealName() : "");
            entity.setBodyText(receive != null ? receive.getBodyText() : null);
            if (receive == null) {
                entity.setBodyText(bodyText);
            }
            NoticeInfoVO vo = JsonUtilEx.getJsonToBeanEx(entity, NoticeInfoVO.class);
            MessageEntity getinfo = messageService.getinfo(id);
            getinfo.setIsRead(1);
            getinfo.setLastModifyTime(getinfo.getLastModifyTime());
            messageService.updateById(getinfo);
            return ActionResult.success(vo);
        }else{
            return ActionResult.fail("该公告已撤回！");
        }

    }


    /**
     * 全部已读
     *
     * @return
     */
    @ApiOperation("全部已读")
    @PostMapping("/Actions/ReadAll")
    public ActionResult allRead() {
        messageService.messageRead();
        return ActionResult.success("已读成功");
    }

    /**
     * 浏览量+1
     *
     * @param id
     * @return
     */
    @ApiOperation("系统公告更新")
    @PutMapping("/viewCount/{id}")
    public ActionResult viewCount(@PathVariable("id") String id) {

        MessageEntity entity = messageService.getinfo(id);
        if (entity != null) {
            MessageEntity crmproductmessageEntity = new MessageEntity();
            crmproductmessageEntity.setId(id);
            crmproductmessageEntity.setViewCount(entity.getViewCount() + 1);
            messageService.updateById(crmproductmessageEntity);
        }
        return ActionResult.success("浏览量+1");
    }

    /**
     * 删除记录
     *
     * @return
     */
    @ApiOperation("删除消息")
    @DeleteMapping("/Record")
    public ActionResult deleteRecord(@RequestBody MessageRecordForm recordForm) {
        String[] id = recordForm.getIds().split(",");
        List<String> list = Arrays.asList(id);
        messageService.deleteRecord(list);
        return ActionResult.success(MsgCode.SU003.get());
    }


    /**
     * 获取系统配置
     */
    private Map<String, String> getSystemConfig() {
        // 获取系统配置
        List<SysConfigEntity> configList = sysConfigService.getList();
        Map<String, String> objModel = new HashMap<>(16);
        for (SysConfigEntity entity : configList) {
            objModel.put(entity.getKeyName(), entity.getKeyValue());
        }
        return objModel;
    }

    private List<List<String>> splitList(List<String> messagesList, int groupSize) {
        int length = messagesList.size();
        // 计算可以分成多少组
        int num = (length + groupSize - 1) / groupSize; // TODO
        List<List<String>> newList = new ArrayList<>(num);
        for (int i = 0; i < num; i++) {
            // 开始位置
            int fromIndex = i * groupSize;
            // 结束位置
            int toIndex = (i + 1) * groupSize < length ? (i + 1) * groupSize : length;
            newList.add(messagesList.subList(fromIndex, toIndex));
        }
        return newList;
    }

}
