package com.bringspring.system.msgcenter.model.mcmsgaccount;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.util.Date;

/**
 * @版本： V1.0.0
 * @版权： 荣科科技股份有限公司
 * @作者： RKKJ开发平台组
 * @日期： 2024-06-03
 */
@Data
public class McMsgAccountInfoVO {
    /**
     * 主键
     **/
    @JsonProperty("id")
    private String id;

    /**
     * 分类
     **/
    @JsonProperty("category")
    private String category;

    /**
     * 名称
     **/
    @JsonProperty("fullName")
    private String fullName;

    /**
     * 编码
     **/
    @JsonProperty("enCode")
    private String enCode;

    /**
     * 发件人昵称
     **/
    @JsonProperty("addressorName")
    private String addressorName;

    /**
     * SMTP服务器
     **/
    @JsonProperty("smtpServer")
    private String smtpServer;

    /**
     * SMTP端口
     **/
    @JsonProperty("smtpPort")
    private Integer smtpPort;

    /**
     * SSL安全链接
     **/
    @JsonProperty("sslLink")
    private String sslLink;

    /**
     * SMTP用户名
     **/
    @JsonProperty("smtpUser")
    private String smtpUser;

    /**
     * SMTP密码
     **/
    @JsonProperty("smtpPassword")
    private String smtpPassword;

    /**
     * 渠道
     **/
    @JsonProperty("channel")
    private String channel;

    /**
     * 短信签名
     **/
    @JsonProperty("smsSignature")
    private String smsSignature;

    /**
     * 应用ID
     **/
    @JsonProperty("appId")
    private String appId;

    /**
     * 应用Secret
     **/
    @JsonProperty("appSecret")
    private String appSecret;

    /**
     * EndPoint
     **/
    @JsonProperty("endPoint")
    private String endPoint;

    /**
     * SDK AppID
     **/
    @JsonProperty("sdkAppId")
    private String sdkAppId;

    /**
     * AppKey
     **/
    @JsonProperty("appKey")
    private String appKey;

    /**
     * 地域域名
     **/
    @JsonProperty("zoneName")
    private String zoneName;

    /**
     * 地域参数
     **/
    @JsonProperty("zoneParam")
    private String zoneParam;

    /**
     * 企业id
     */
    @JsonProperty("enterpriseId")
    private String enterpriseId;

    /**
     * AgentID
     */
    @JsonProperty("agentId")
    private String agentId;

    /**
     * WebHook类型
     **/
    @JsonProperty("webhookType")
    private String webhookType;

    /**
     * WebHook地址
     **/
    @JsonProperty("webhookAddress")
    private String webhookAddress;

    /**
     * 认证类型
     **/
    @JsonProperty("approveType")
    private String approveType;

    /**
     * Bearer令牌
     **/
    @JsonProperty("bearer")
    private String bearer;

    /**
     * 程序类型：developer为开发版；trial为体验版；formal为正式版；默认为正式版
     **/
    @JsonProperty("programState")
    private String programState;
    /**
     * 用户名
     **/
    @JsonProperty("userName")
    private String userName;

    /**
     * 密码
     **/
    @JsonProperty("password")
    private String password;
    /**
     * 应用地址
     **/
    @JsonProperty("address")
    private String address;

    /**
     * 排序
     **/
    @JsonProperty("sortCode")
    private Integer sortCode;

    /**
     * 状态
     **/
    @JsonProperty("enabledMark")
    private String enabledMark;

    /**
     * 说明
     **/
    @JsonProperty("description")
    private String description;

    /**
     * 创建时间
     **/
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @JsonProperty("creatorTime")
    private Date creatorTime;

    /**
     * 创建用户
     **/
    @JsonProperty("creatorUserId")
    private String creatorUserId;

    /**
     * 修改时间
     **/
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @JsonProperty("lastModifyTime")
    private Date lastModifyTime;

    /**
     * 修改用户
     **/
    @JsonProperty("lastModifyUserId")
    private String lastModifyUserId;

    /**
     * 所属公司
     **/
    @JsonProperty("companyId")
    private String companyId;

}