package com.bringspring.system.msgcenter.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.system.msgcenter.entity.*;
import com.bringspring.system.msgcenter.mapper.McMsgSendMapper;
import com.bringspring.system.msgcenter.model.mcmsgsend.McMsgSendCrForm;
import com.bringspring.system.msgcenter.model.mcmsgsend.McMsgSendInfoVO;
import com.bringspring.system.msgcenter.model.mcmsgsend.McMsgSendPagination;
import com.bringspring.system.msgcenter.model.mcmsgsend.McMsgSendUpForm;
import com.bringspring.system.msgcenter.model.mcmsgsendtemplate.McMsgSendTemplateModel;
import com.bringspring.system.msgcenter.service.McMsgAccountService;
import com.bringspring.system.msgcenter.service.McMsgSendService;
import com.bringspring.system.msgcenter.service.McMsgSendTemplateService;
import com.bringspring.system.msgcenter.service.McMsgTemplateService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

import static com.bringspring.system.msgcenter.constant.CommonConsts.NOT_UNIQUE;
import static com.bringspring.system.msgcenter.constant.CommonConsts.UNIQUE;

/**
 * 消息发送配置表
 * 版本： V1.0.0
 * 版权： 荣科科技股份有限公司
 * 作者： RKKJ开发平台组
 * 日期： 2024-06-12
 */
@Service
public class McMsgSendServiceImpl extends ServiceImpl<McMsgSendMapper, McMsgSendEntity> implements McMsgSendService {


    @Autowired
    private UserProvider userProvider;

    @Autowired
    private McMsgSendTemplateService mcMsgSendTemplateService;

    @Autowired
    private McMsgTemplateService mcMsgTemplateService;
    @Autowired
    private McMsgAccountService mcMsgAccountService;

    @Override
    public List<McMsgSendEntity> getList(McMsgSendPagination pagination) {
        String userId = userProvider.get().getUserId();
        List<String> AllIdList = new ArrayList();
        int total = 0;
        int mcMsgSendNum = 0;
        QueryWrapper<McMsgSendEntity> queryWrapper = new QueryWrapper<>();
        int mcMsgSendTemplateNum = 0;
        QueryWrapper<McMsgSendTemplateEntity> templateQueryWrapper = new QueryWrapper<>();

        // 关键字查询
        if (StringUtils.isNotEmpty(pagination.getKeyword())) {
            mcMsgSendTemplateNum++;
            queryWrapper.lambda().like(McMsgSendEntity::getFullName, pagination.getKeyword())
                    .or().like(McMsgSendEntity::getEnCode, pagination.getKeyword());
        }
        if (StringUtils.isNotEmpty(pagination.getFullName())) {
            mcMsgSendNum++;
            queryWrapper.lambda().like(McMsgSendEntity::getFullName, pagination.getFullName());
        }

        if (StringUtils.isNotEmpty(pagination.getEnCode())) {
            mcMsgSendNum++;
            queryWrapper.lambda().like(McMsgSendEntity::getEnCode, pagination.getEnCode());
        }
        if (StringUtils.isNotEmpty(pagination.getTaskCode())) {
            mcMsgSendNum++;
            queryWrapper.lambda().eq(McMsgSendEntity::getTaskCode, pagination.getTaskCode());
        }

        if (StringUtils.isNotEmpty(pagination.getTemplateType())) {
            mcMsgSendNum++;
            queryWrapper.lambda().eq(McMsgSendEntity::getTemplateType, pagination.getTemplateType());
        }

        if (StringUtils.isNotEmpty(pagination.getMessageSource())) {
            mcMsgSendNum++;
            queryWrapper.lambda().eq(McMsgSendEntity::getMessageSource, pagination.getMessageSource());
        }

        if (AllIdList.size() > 0) {
            queryWrapper.lambda().in(McMsgSendEntity::getId, AllIdList);
        }
        //排序
        if (StringUtils.isEmpty(pagination.getSidx())) {
            queryWrapper.lambda().orderByDesc(McMsgSendEntity::getCreatorTime);
        } else {
            try {
                String sidx = pagination.getSidx();
                McMsgSendEntity mcMsgSendEntity = new McMsgSendEntity();
                Field declaredField = mcMsgSendEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                queryWrapper = "asc".equals(pagination.getSort().toLowerCase()) ?
                        queryWrapper.orderByAsc(value) : queryWrapper.orderByDesc(value);
            } catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ((total > 0 && AllIdList.size() > 0) || total == 0) {
            Page<McMsgSendEntity> page = new Page<>(pagination.getCurrentPage(), pagination.getPageSize());
            IPage<McMsgSendEntity> userIPage = this.page(page, queryWrapper);
            return pagination.setData(userIPage.getRecords(), userIPage.getTotal());
        } else {
            List<McMsgSendEntity> list = new ArrayList();
            return pagination.setData(list, list.size());
        }
    }

    @Override
    public List<McMsgSendEntity> getListAll(McMsgSendPagination pagination) {
        QueryWrapper<McMsgSendEntity> queryWrapper = new QueryWrapper<>();

        // 关键字查询
        if (StringUtils.isNotEmpty(pagination.getKeyword())) {
            queryWrapper.lambda().like(McMsgSendEntity::getFullName, pagination.getKeyword())
                    .or().like(McMsgSendEntity::getEnCode, pagination.getKeyword());
        }
        if (StringUtils.isNotEmpty(pagination.getFullName())) {
            queryWrapper.lambda().like(McMsgSendEntity::getFullName, pagination.getFullName());
        }

        if (StringUtils.isNotEmpty(pagination.getEnCode())) {
            queryWrapper.lambda().like(McMsgSendEntity::getEnCode, pagination.getEnCode());
        }
        if (StringUtils.isNotEmpty(pagination.getTaskCode())) {
            queryWrapper.lambda().eq(McMsgSendEntity::getTaskCode, pagination.getTaskCode());
        }

        if (StringUtils.isNotEmpty(pagination.getTemplateType())) {
            queryWrapper.lambda().eq(McMsgSendEntity::getTemplateType, pagination.getTemplateType());
        }

        if (StringUtils.isNotEmpty(pagination.getMessageSource())) {
            queryWrapper.lambda().eq(McMsgSendEntity::getMessageSource, pagination.getMessageSource());
        }

        //排序
        if (StringUtils.isEmpty(pagination.getSidx())) {
            queryWrapper.lambda().orderByDesc(McMsgSendEntity::getCreatorTime);
        } else {
            try {
                String sidx = pagination.getSidx();
                McMsgSendEntity mcMsgSendEntity = new McMsgSendEntity();
                Field declaredField = mcMsgSendEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                queryWrapper = "asc".equals(pagination.getSort().toLowerCase()) ?
                        queryWrapper.orderByAsc(value) : queryWrapper.orderByDesc(value);
            } catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        return this.list(queryWrapper);
    }

    @Override
    public List<McMsgSendEntity> getTypeList(McMsgSendPagination pagination, String dataType) {
        String userId = userProvider.get().getUserId();
        List<String> AllIdList = new ArrayList();
        int total = 0;
        int mcMsgSendNum = 0;
        QueryWrapper<McMsgSendEntity> queryWrapper = new QueryWrapper<>();
        int mcMsgSendTemplateNum = 0;
        QueryWrapper<McMsgSendTemplateEntity> templateQueryWrapper = new QueryWrapper<>();
        if (StringUtils.isNotEmpty(pagination.getFullName())) {
            mcMsgSendNum++;
            queryWrapper.lambda().like(McMsgSendEntity::getFullName, pagination.getFullName());
        }

        if (StringUtils.isNotEmpty(pagination.getEnCode())) {
            mcMsgSendNum++;
            queryWrapper.lambda().like(McMsgSendEntity::getEnCode, pagination.getEnCode());
        }
        if (StringUtils.isNotEmpty(pagination.getTaskCode())) {
            mcMsgSendNum++;
            queryWrapper.lambda().eq(McMsgSendEntity::getTaskCode, pagination.getTaskCode());
        }

        if (StringUtils.isNotEmpty(pagination.getTemplateType())) {
            mcMsgSendNum++;
            queryWrapper.lambda().eq(McMsgSendEntity::getTemplateType, pagination.getTemplateType());
        }

        if (StringUtils.isNotEmpty(pagination.getMessageSource())) {
            mcMsgSendNum++;
            queryWrapper.lambda().eq(McMsgSendEntity::getMessageSource, pagination.getMessageSource());
        }

        if (AllIdList.size() > 0) {
            queryWrapper.lambda().in(McMsgSendEntity::getId, AllIdList);
        }
        //排序
        if (StringUtils.isEmpty(pagination.getSidx())) {
            queryWrapper.lambda().orderByDesc(McMsgSendEntity::getCreatorTime);
        } else {
            try {
                String sidx = pagination.getSidx();
                McMsgSendEntity mcMsgSendEntity = new McMsgSendEntity();
                Field declaredField = mcMsgSendEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                queryWrapper = "asc".equals(pagination.getSort().toLowerCase()) ?
                        queryWrapper.orderByAsc(value) : queryWrapper.orderByDesc(value);
            } catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ("0".equals(dataType)) {
            if ((total > 0 && AllIdList.size() > 0) || total == 0) {
                Page<McMsgSendEntity> page = new Page<>(pagination.getCurrentPage(), pagination.getPageSize());
                IPage<McMsgSendEntity> userIPage = this.page(page, queryWrapper);
                return pagination.setData(userIPage.getRecords(), userIPage.getTotal());
            } else {
                List<McMsgSendEntity> list = new ArrayList();
                return pagination.setData(list, list.size());
            }
        } else {
            return this.list(queryWrapper);
        }
    }

    @Override
    public McMsgSendEntity getInfo(String id) {
        QueryWrapper<McMsgSendEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda().eq(McMsgSendEntity::getId, id);
        return this.getOne(queryWrapper);
    }

    @Override
    public McMsgSendEntity getEntityByEnCode(String enCode) {
        QueryWrapper<McMsgSendEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda().eq(McMsgSendEntity::getEnCode, enCode);
        queryWrapper.last("limit 1");
        McMsgSendEntity one = this.getOne(queryWrapper);
        return one;
    }

    @Override
    public McMsgSendInfoVO getInfoByEnCode(String enCode) {
        QueryWrapper<McMsgSendEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda().eq(McMsgSendEntity::getEnCode, enCode);
        queryWrapper.last("limit 1");
        McMsgSendEntity one = this.getOne(queryWrapper);
        McMsgSendInfoVO infoVO = JsonUtil.getJsonToBean(one, McMsgSendInfoVO.class);
        //子表
        List<McMsgSendTemplateEntity> mcMsgSendTemplateList = this.getMcMsgSendTemplateList(infoVO.getId(), 1);
        List<McMsgSendTemplateModel> modelList = JsonUtil.getJsonToList(mcMsgSendTemplateList,
                McMsgSendTemplateModel.class);
        for (McMsgSendTemplateModel templateEntity : modelList) {
            McMsgTemplateEntity templateInfo = mcMsgTemplateService.getInfo(templateEntity.getTemplateId());
            templateEntity.setTemplateName(templateInfo != null ? templateInfo.getFullName() : null);
            templateEntity.setTemplateEnCode(templateInfo != null ? templateInfo.getEnCode() : null);
            McMsgAccountEntity accountInfo = mcMsgAccountService.getInfo(templateEntity.getAccountConfigId());
            templateEntity.setAccountName(accountInfo != null ? accountInfo.getFullName() : null);
            templateEntity.setAccountEnCode(accountInfo != null ? accountInfo.getEnCode() : null);
        }
        infoVO.setSendTemplateList(modelList);
        return infoVO;
    }

    @Override
    public McMsgSendEntity getValidInfo(String enCode) {
        QueryWrapper<McMsgSendEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda().eq(McMsgSendEntity::getEnabledMark, 1);
        queryWrapper.lambda().and(t -> t.eq(McMsgSendEntity::getId, enCode).or().eq(McMsgSendEntity::getEnCode,
                enCode));

        return this.getOne(queryWrapper);
    }

    @Override
    @DSTransactional
    public void create(McMsgSendCrForm mcMsgSendCrForm) {
        String mainId = RandomUtil.uuId();
        McMsgSendEntity entity = JsonUtil.getJsonToBean(mcMsgSendCrForm, McMsgSendEntity.class);
        entity.setId(mainId);
        this.save(entity);
        List<McMsgSendTemplateEntity> sendTemplateList =
                JsonUtil.getJsonToList(mcMsgSendCrForm.getSendTemplateList(), McMsgSendTemplateEntity.class);
        for (McMsgSendTemplateEntity entitys : sendTemplateList) {
            entitys.setId(RandomUtil.uuId());
            entitys.setSendConfigId(entity.getId());
            mcMsgSendTemplateService.save(entitys);
        }
    }

    @Override
    @DSTransactional
    public boolean update(String id, McMsgSendUpForm mcMsgSendUpForm) {

        McMsgSendEntity entity = JsonUtil.getJsonToBean(mcMsgSendUpForm, McMsgSendEntity.class);
        entity.setId(id);

        QueryWrapper<McMsgSendTemplateEntity> sendTemplatequeryWrapper = new QueryWrapper<>();
        sendTemplatequeryWrapper.lambda().eq(McMsgSendTemplateEntity::getSendConfigId, entity.getId());
        mcMsgSendTemplateService.remove(sendTemplatequeryWrapper);
        List<McMsgSendTemplateEntity> sendTemplateList =
                JsonUtil.getJsonToList(mcMsgSendUpForm.getSendTemplateList(), McMsgSendTemplateEntity.class);
        for (McMsgSendTemplateEntity entitys : sendTemplateList) {
            entitys.setId(RandomUtil.uuId());
            entitys.setSendConfigId(entity.getId());
            mcMsgSendTemplateService.save(entitys);
        }
        return this.updateById(entity);
    }

    @Override
    @DSTransactional
    public void delete(McMsgSendEntity entity) {
        if (entity != null) {
            this.removeById(entity.getId());
            QueryWrapper<McMsgSendTemplateEntity> queryWrapperMcMsgSendTemplate = new QueryWrapper<>();
            queryWrapperMcMsgSendTemplate.lambda().eq(McMsgSendTemplateEntity::getSendConfigId, entity.getId());
            mcMsgSendTemplateService.remove(queryWrapperMcMsgSendTemplate);
        }
    }

    //子表方法
    @Override
    public List<McMsgSendTemplateEntity> getMcMsgSendTemplateList(String id) {
        return this.getMcMsgSendTemplateList(id, null);
    }

    //子表方法
    @Override
    public List<McMsgSendTemplateEntity> getMcMsgSendTemplateList(String id, Integer enabledMark) {
        QueryWrapper<McMsgSendTemplateEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda().eq(McMsgSendTemplateEntity::getSendConfigId, id);
        if (ObjectUtil.isNotEmpty(enabledMark)) {
            queryWrapper.lambda().eq(McMsgSendTemplateEntity::getEnabledMark, enabledMark);
        }
        return mcMsgSendTemplateService.list(queryWrapper);
    }

    //子表方法
    @Override
    public List<McMsgSendTemplateEntity> getMcMsgSendTemplateList(String sendId, String templateId,
                                                                  Integer enabledMark) {
        QueryWrapper<McMsgSendTemplateEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda().eq(McMsgSendTemplateEntity::getSendConfigId, sendId);
        queryWrapper.lambda().eq(McMsgSendTemplateEntity::getTemplateId, templateId);
        queryWrapper.lambda().eq(McMsgSendTemplateEntity::getEnabledMark, enabledMark);
        return mcMsgSendTemplateService.list(queryWrapper);
    }

    @Override
    public boolean checkEnCodeUnique(String enCode, String id) {
        LambdaQueryWrapper<McMsgSendEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(McMsgSendEntity::getEnCode, enCode);
        queryWrapper.last("limit 1");
        McMsgSendEntity entity = this.getOne(queryWrapper);
        if (ObjectUtil.isNotNull(entity) && (StringUtils.isEmpty(id) || !entity.getId().equals(id))) {
            // 存在code编码,返回false
            return NOT_UNIQUE;
        }
        return UNIQUE;
    }

    @Override
    public boolean checkFullNameUnique(String fullName, String id) {
        LambdaQueryWrapper<McMsgSendEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(McMsgSendEntity::getFullName, fullName);
        queryWrapper.last("limit 1");
        McMsgSendEntity entity = this.getOne(queryWrapper);
        if (ObjectUtil.isNotNull(entity) && (StringUtils.isEmpty(id) || !entity.getId().equals(id))) {
            // 存在code编码,返回false
            return NOT_UNIQUE;
        }
        return UNIQUE;
    }

    @Override
    public long getCountByMessageSource(String messageSource) {
        LambdaQueryWrapper<McMsgSendEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(McMsgSendEntity::getMessageSource, messageSource);
        return this.count(queryWrapper);
    }

}