package com.bringspring.system.msgcenter.service.impl;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.system.msgcenter.entity.McTaskMsgContentEntity;
import com.bringspring.system.msgcenter.mapper.McTaskMsgContentMapper;
import com.bringspring.system.msgcenter.model.mctaskmsgcontent.McTaskMsgContentCrForm;
import com.bringspring.system.msgcenter.model.mctaskmsgcontent.McTaskMsgContentListQuery;
import com.bringspring.system.msgcenter.model.mctaskmsgcontent.McTaskMsgContentPagination;
import com.bringspring.system.msgcenter.model.mctaskmsgcontent.McTaskMsgContentUpForm;
import com.bringspring.system.msgcenter.service.McTaskMsgContentService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

/**
 * 业务场景消息内容表
 * 版本： V1.0.0
 * 版权： 荣科科技股份有限公司
 * 作者： RKKJ开发平台组
 * 日期： 2024-06-14
 */
@Service
public class McTaskMsgContentServiceImpl extends ServiceImpl<McTaskMsgContentMapper, McTaskMsgContentEntity> implements McTaskMsgContentService {


    @Autowired
    private UserProvider userProvider;

    @Override
    public List<McTaskMsgContentEntity> getList(McTaskMsgContentPagination pagination) {
        String userId = userProvider.get().getUserId();
        List<String> AllIdList = new ArrayList();
        int total = 0;
        int mcTaskMsgContentNum = 0;
        QueryWrapper<McTaskMsgContentEntity> queryWrapper = new QueryWrapper<>();
        if (StringUtils.isNotEmpty(pagination.getMsgId())) {
            mcTaskMsgContentNum++;
            queryWrapper.lambda().eq(McTaskMsgContentEntity::getMsgId, pagination.getMsgId());
        }

        if (StringUtils.isNotEmpty(pagination.getTemplateId())) {
            mcTaskMsgContentNum++;
            queryWrapper.lambda().eq(McTaskMsgContentEntity::getTemplateId, pagination.getTemplateId());
        }
        if (StringUtils.isNotEmpty(pagination.getContentType())) {
            queryWrapper.lambda().eq(McTaskMsgContentEntity::getContentType, pagination.getContentType());
        }
        if (StringUtils.isNotEmpty(pagination.getChannelType())) {
            queryWrapper.lambda().eq(McTaskMsgContentEntity::getChannelType, pagination.getChannelType());
        }

        if (AllIdList.size() > 0) {
            queryWrapper.lambda().in(McTaskMsgContentEntity::getId, AllIdList);
        }
        //排序
        if (StringUtils.isEmpty(pagination.getSidx())) {
            queryWrapper.lambda().orderByDesc(McTaskMsgContentEntity::getCreatorTime);
        } else {
            try {
                String sidx = pagination.getSidx();
                McTaskMsgContentEntity mcTaskMsgContentEntity = new McTaskMsgContentEntity();
                Field declaredField = mcTaskMsgContentEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                queryWrapper = "asc".equals(pagination.getSort().toLowerCase()) ? queryWrapper.orderByAsc(value) :
                        queryWrapper.orderByDesc(value);
            } catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ((total > 0 && AllIdList.size() > 0) || total == 0) {
            Page<McTaskMsgContentEntity> page = new Page<>(pagination.getCurrentPage(),
                    pagination.getPageSize());
            IPage<McTaskMsgContentEntity> userIPage = this.page(page, queryWrapper);
            return pagination.setData(userIPage.getRecords(), userIPage.getTotal());
        } else {
            List<McTaskMsgContentEntity> list = new ArrayList();
            return pagination.setData(list, list.size());
        }
    }

    @Override
    public List<McTaskMsgContentEntity> getList(McTaskMsgContentListQuery listQuery) {
        QueryWrapper<McTaskMsgContentEntity> queryWrapper = new QueryWrapper<>();
        if (StringUtils.isNotEmpty(listQuery.getMsgId())) {
            queryWrapper.lambda().eq(McTaskMsgContentEntity::getMsgId, listQuery.getMsgId());
        }

        if (StringUtils.isNotEmpty(listQuery.getChannelType())) {
            queryWrapper.lambda().eq(McTaskMsgContentEntity::getChannelType, listQuery.getChannelType());
        }
        if (StringUtils.isNotEmpty(listQuery.getMsgTemplateId())) {
            queryWrapper.lambda().eq(McTaskMsgContentEntity::getMsgTemplateId, listQuery.getMsgTemplateId());
        }
        if (StringUtils.isNotEmpty(listQuery.getMsgAccountId())) {
            queryWrapper.lambda().eq(McTaskMsgContentEntity::getMsgAccountId, listQuery.getMsgAccountId());
        }
        if (StringUtils.isNotEmpty(listQuery.getTemplateId())) {
            queryWrapper.lambda().eq(McTaskMsgContentEntity::getTemplateId, listQuery.getTemplateId());
        }
        if (StringUtils.isNotEmpty(listQuery.getTemplateId())) {
            queryWrapper.lambda().eq(McTaskMsgContentEntity::getTemplateId, listQuery.getTemplateId());
        }
        if (StringUtils.isNotEmpty(listQuery.getContentType())) {
            queryWrapper.lambda().eq(McTaskMsgContentEntity::getContentType, listQuery.getContentType());
        }
        //排序
        queryWrapper.lambda().orderByAsc(McTaskMsgContentEntity::getCreatorTime);
        return this.list(queryWrapper);
    }

    @Override
    public List<McTaskMsgContentEntity> getTypeList(McTaskMsgContentPagination pagination, String dataType) {
        String userId = userProvider.get().getUserId();
        List<String> AllIdList = new ArrayList();
        int total = 0;
        int mcTaskMsgContentNum = 0;
        QueryWrapper<McTaskMsgContentEntity> queryWrapper = new QueryWrapper<>();
        if (StringUtils.isNotEmpty(pagination.getMsgId())) {
            mcTaskMsgContentNum++;
            queryWrapper.lambda().like(McTaskMsgContentEntity::getMsgId, pagination.getMsgId());
        }

        if (StringUtils.isNotEmpty(pagination.getTemplateId())) {
            mcTaskMsgContentNum++;
            queryWrapper.lambda().like(McTaskMsgContentEntity::getTemplateId, pagination.getTemplateId());
        }

        if (AllIdList.size() > 0) {
            queryWrapper.lambda().in(McTaskMsgContentEntity::getId, AllIdList);
        }
        //排序
        if (StringUtils.isEmpty(pagination.getSidx())) {
            queryWrapper.lambda().orderByDesc(McTaskMsgContentEntity::getCreatorTime);
        } else {
            try {
                String sidx = pagination.getSidx();
                McTaskMsgContentEntity mcTaskMsgContentEntity = new McTaskMsgContentEntity();
                Field declaredField = mcTaskMsgContentEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                queryWrapper = "asc".equals(pagination.getSort().toLowerCase()) ? queryWrapper.orderByAsc(value) :
                        queryWrapper.orderByDesc(value);
            } catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ("0".equals(dataType)) {
            if ((total > 0 && AllIdList.size() > 0) || total == 0) {
                Page<McTaskMsgContentEntity> page = new Page<>(pagination.getCurrentPage(), pagination.getPageSize());
                IPage<McTaskMsgContentEntity> userIPage = this.page(page, queryWrapper);
                return pagination.setData(userIPage.getRecords(), userIPage.getTotal());
            } else {
                List<McTaskMsgContentEntity> list = new ArrayList();
                return pagination.setData(list, list.size());
            }
        } else {
            return this.list(queryWrapper);
        }
    }

    @Override
    public McTaskMsgContentEntity getInfo(String id) {
        QueryWrapper<McTaskMsgContentEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda().eq(McTaskMsgContentEntity::getId, id);
        return this.getOne(queryWrapper);
    }

    @Override
    @DSTransactional
    public void create(McTaskMsgContentCrForm mcTaskMsgContentCrForm) {
        String mainId = RandomUtil.uuId();
        McTaskMsgContentEntity entity = JsonUtil.getJsonToBean(mcTaskMsgContentCrForm, McTaskMsgContentEntity.class);
        entity.setId(mainId);
        this.save(entity);
    }

    @Override
    @DSTransactional
    public boolean update(String id, McTaskMsgContentUpForm mcTaskMsgContentUpForm) {
        McTaskMsgContentEntity entity = JsonUtil.getJsonToBean(mcTaskMsgContentUpForm, McTaskMsgContentEntity.class);
        entity.setId(id);
        return this.updateById(entity);
    }

    @Override
    @DSTransactional
    public void delete(McTaskMsgContentEntity entity) {
        if (entity != null) {
            this.removeById(entity.getId());
        }
    }


}