package com.bringspring.system.msgcenter.service.strategy;

import cn.hutool.core.collection.CollectionUtil;
import com.bringspring.common.base.UserInfo;
import com.bringspring.system.msgcenter.entity.McTaskMsgContentEntity;
import com.bringspring.system.msgcenter.entity.McTaskMsgReceiveEntity;
import com.bringspring.system.msgcenter.model.mcmsgsendtemplate.McMsgSendTemplateModel;
import com.bringspring.system.msgcenter.service.McTaskMsgReceiveService;
import com.bringspring.system.msgcenter.service.strategy.factory.MessageSenderFactory;
import lombok.extern.slf4j.Slf4j;
import me.chanjar.weixin.common.error.WxErrorException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 渠道消息发送业务实现
 * 版本： V1.0.0
 * 版权： 荣科科技股份有限公司
 * 作者： RKKJ开发平台组
 * 日期： 2024-06-12
 */
@Component
@Slf4j
public class SendMessageService {

    private final MessageSenderFactory senderFactory;
    private final McTaskMsgReceiveService mcTaskMsgReceiveService;

    // 构造器注入
    @Autowired
    public SendMessageService(MessageSenderFactory senderFactory, McTaskMsgReceiveService mcTaskMsgReceiveService) {
        this.senderFactory = senderFactory;
        this.mcTaskMsgReceiveService = mcTaskMsgReceiveService;
    }

    /**
     * 渠道消息发送
     *
     * @param isAgain         是否重发
     * @param sendTemplate
     * @param taskMsgContent  消息内容表信息
     * @param receiveList     接收人记录
     * @param currentUserInfo 当前用户信息
     * @throws WxErrorException
     */
    public void sendMessageByChannel(boolean isAgain, String toType,
                                     McMsgSendTemplateModel sendTemplate,
                                     McTaskMsgContentEntity taskMsgContent,
                                     List<McTaskMsgReceiveEntity> receiveList,
                                     UserInfo currentUserInfo) {
        if (CollectionUtil.isEmpty(receiveList)) {
            log.warn("空接收人列表");
            return;
        }
        // 获取渠道类型
        String channelType = sendTemplate.getMessageType();
        try {
            // 通过工厂获取策略
            MessageSender sender = senderFactory.getSender(channelType);
            if (sender == null) {
                log.error("不支持的渠道类型: {}", channelType);
                return;
            }

            // 执行发送
            sender.send(isAgain, toType, sendTemplate, taskMsgContent, receiveList, currentUserInfo);
        } catch (Exception e) {
            log.error("消息发送失败 | 渠道类型: {}", channelType, e);
            // 统一失败处理
            mcTaskMsgReceiveService.updateByList(isAgain, receiveList, 2, "系统异常", currentUserInfo);
        }
    }

}