package com.bringspring.system.msgcenter.service.strategy.factory;

import cn.hutool.core.util.ObjectUtil;
import com.bringspring.system.msgcenter.service.strategy.AbstractMessageSender;
import com.bringspring.system.msgcenter.service.strategy.MessageSender;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

@Component
@Slf4j
public class MessageSenderFactory {
    private final Map<String, AbstractMessageSender> strategies;

    @Autowired
    public MessageSenderFactory(List<AbstractMessageSender> senders) {
        this.strategies = senders.stream()
                .collect(Collectors.toMap(
                        s -> s.getChannelType().getCode(),
                        Function.identity(),
                        (existing, replacement) -> {
                            log.warn("重复的渠道类型: {}", existing.getChannelType());
                            return existing;
                        }));
    }

    public MessageSender getSender(String channelType) {
        MessageSender sender = strategies.get(channelType);
        if (ObjectUtil.isNull(sender)) {
            throw new IllegalArgumentException("不支持的渠道类型: " + channelType);
        }
        return sender;
    }
}