package com.bringspring.system.msgcenter.service.strategy.impl;

import cn.hutool.core.util.ObjectUtil;
import com.bringspring.system.message.entity.SynThirdInfoEntity;
import com.bringspring.system.message.service.SynThirdInfoService;
import com.bringspring.system.msgcenter.entity.*;
import com.bringspring.system.msgcenter.enums.ChannelTypeEnum;
import com.bringspring.system.msgcenter.model.mcmsgsendtemplate.McMsgSendTemplateModel;
import com.bringspring.system.msgcenter.service.McMsgAccountService;
import com.bringspring.system.msgcenter.service.McMsgTemplateService;
import com.bringspring.system.msgcenter.service.strategy.AbstractMessageChannelStrategy;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.service.UserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

import static com.bringspring.system.message.util.SynThirdConsts.DATA_TYPE_USER;
import static com.bringspring.system.message.util.SynThirdConsts.THIRD_TYPE_DING;

/**
 * 不同渠道的策略类继承抽象基类，复用公共方法，并实现自身逻辑
 * 钉钉消息策略
 */
@Component
public class DingTalkStrategy extends AbstractMessageChannelStrategy {
    @Autowired
    private SynThirdInfoService synThirdInfoService;
    @Autowired
    private McMsgTemplateService mcMsgTemplateService;
    @Autowired
    private McMsgAccountService mcMsgAccountService;
    @Autowired
    private UserService userService;

    @Override
    public ChannelTypeEnum getChannelType() {
        return ChannelTypeEnum.DING_MSG;
    }

    @Override
    public void processMessage(McTaskMsgEntity taskMsg,
                               McMsgSendTemplateModel sendTemplate,
                               Map<String, McTaskMsgContentEntity> contentMap,
                               Map<String, List<McTaskMsgReceiveEntity>> receiveMap,
                               Set<String> userSet) {
        String taskMsgId = taskMsg.getId();

        // 具体实现钉钉渠道的逻辑（原switch-case中的代码迁移至此）
        String templateId = sendTemplate.getId(); // 发送配置消息模板
        String channelType = sendTemplate.getMessageType(); // 消息渠道
        String msgTemplateId = sendTemplate.getTemplateId(); // 消息模板
        String msgAccountId = sendTemplate.getAccountConfigId(); // 授权应用配置

        // 授权应用
        McMsgAccountEntity account = mcMsgAccountService.getInfo(sendTemplate.getAccountConfigId());
        // 消息模板
        McMsgTemplateEntity msgTemplate = mcMsgTemplateService.getInfo(sendTemplate.getTemplateId());
        // ... 省略具体逻辑（参考原代码DING_MSG部分）
        String dingContentKey = channelType + msgTemplateId + msgAccountId;
        String dingReceiveKey = channelType + msgTemplateId;
        // 消息内容
        McTaskMsgContentEntity ddContent;
        if (!contentMap.containsKey(dingContentKey)) {
            ddContent = this.getTaskMsgContent(templateId, channelType, taskMsg, msgTemplate, account);
            contentMap.put(dingContentKey, ddContent); // 渠道模板应用消息内容
        } else {
            ddContent = contentMap.get(dingContentKey);
        }

        if ("4".equals(taskMsg.getToType())) {
            // 非系统用户，第三方唯一标识直接发送
            if (!receiveMap.containsKey(dingContentKey)) {
                List<McTaskMsgReceiveEntity> ddReceiveList =
                        packNonSystemReceive(userSet, taskMsgId, templateId, channelType, msgTemplateId, msgAccountId
                                , ddContent.getId());
                receiveMap.put(dingContentKey, ddReceiveList);
            }
        } else {
            List<UserEntity> receiveUsers = userService.getUserByIds(new ArrayList<>(userSet));
            String ddCrop = ObjectUtil.isEmpty(account) ? null : account.getEnterpriseId();
            // 钉钉 钉钉用户关联base_sync_third_info获取
            List<SynThirdInfoEntity> ddThirdList =
                    synThirdInfoService.getThirdInfoList(THIRD_TYPE_DING, DATA_TYPE_USER, ddCrop, userSet);
            List<McTaskMsgReceiveEntity> receiveList = null;
            if (receiveMap.containsKey(dingReceiveKey)) {
                receiveList = receiveMap.get(dingReceiveKey);
            }
            List<McTaskMsgReceiveEntity> ddReceiveList =
                    packThirdReceive(receiveUsers, ddThirdList, taskMsgId, templateId, channelType, msgTemplateId,
                            msgAccountId, ddContent.getId(), receiveList);
            receiveMap.put(dingReceiveKey, ddReceiveList);
        }
    }
}
