package com.bringspring.system.msgcenter.service.strategy.impl;

import cn.hutool.core.util.ObjectUtil;
import com.bringspring.system.message.entity.SynThirdInfoEntity;
import com.bringspring.system.msgcenter.entity.*;
import com.bringspring.system.msgcenter.enums.ChannelTypeEnum;
import com.bringspring.system.msgcenter.model.mcmsgsendtemplate.McMsgSendTemplateModel;
import com.bringspring.system.msgcenter.service.McMsgTemplateService;
import com.bringspring.system.msgcenter.service.strategy.AbstractMessageChannelStrategy;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.service.UserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

import static com.bringspring.system.message.util.SynThirdConsts.DATA_TYPE_USER;
import static com.bringspring.system.message.util.SynThirdConsts.THIRD_TYPE_MINIAPP;

/**
 * 微信小程序策略
 */
@Component
public class WxMiniAppStrategy extends AbstractMessageChannelStrategy {
    @Autowired
    private McMsgTemplateService mcMsgTemplateService;
    @Autowired
    private UserService userService;

    @Override
    public ChannelTypeEnum getChannelType() {
        return ChannelTypeEnum.WX_MINIAPP;
    }

    @Override
    public void processMessage(McTaskMsgEntity taskMsg,
                               McMsgSendTemplateModel sendTemplate,
                               Map<String, McTaskMsgContentEntity> contentMap,
                               Map<String, List<McTaskMsgReceiveEntity>> receiveMap,
                               Set<String> userSet) {
        String taskMsgId = taskMsg.getId();

        String templateId = sendTemplate.getId(); // 发送配置消息模板
        String channelType = sendTemplate.getMessageType(); // 消息渠道
        String msgTemplateId = sendTemplate.getTemplateId(); // 消息模板
        String msgAccountId = sendTemplate.getAccountConfigId(); // 授权应用配置

        // 授权应用
        McMsgAccountEntity account = mcMsgAccountService.getInfo(sendTemplate.getAccountConfigId());
        // 消息模板
        McMsgTemplateEntity msgTemplate = mcMsgTemplateService.getInfo(sendTemplate.getTemplateId());
        String maContentKey = channelType + msgTemplateId + msgAccountId;
        String maReceiveKey = channelType + msgTemplateId;
        // 消息内容
        McTaskMsgContentEntity maContent;
        if (!contentMap.containsKey(maContentKey)) {
            maContent = this.getTaskMsgContentKey(templateId, channelType, taskMsg, msgTemplate, account);
            contentMap.put(maContentKey, maContent); // 渠道模板应用消息内容
        } else {
            maContent = contentMap.get(maContentKey);
        }

        if ("4".equals(taskMsg.getToType())) {
            // 非系统用户，第三方唯一标识直接发送
            if (!receiveMap.containsKey(maReceiveKey)) {
                List<McTaskMsgReceiveEntity> maReceiveList =
                        packNonSystemReceive(userSet, taskMsgId, templateId, channelType, msgTemplateId, msgAccountId
                                , maContent.getId());
                receiveMap.put(maReceiveKey, maReceiveList);
            }
        } else {
            List<UserEntity> receiveUsers = userService.getUserByIds(new ArrayList<>(userSet));
            String maCrop = ObjectUtil.isEmpty(account) ? null : account.getAppId();
            // 微信小程序用户关联base_sync_third_info获取
            List<SynThirdInfoEntity> maThirdList =
                    synThirdInfoService.getThirdInfoList(THIRD_TYPE_MINIAPP, DATA_TYPE_USER, maCrop, userSet);
            List<McTaskMsgReceiveEntity> receiveList = null;
            if (receiveMap.containsKey(maReceiveKey)) {
                receiveList = receiveMap.get(maReceiveKey);
            }
            List<McTaskMsgReceiveEntity> maReceiveList =
                    packThirdReceive(receiveUsers, maThirdList, taskMsgId, templateId, channelType, msgTemplateId,
                            msgAccountId, maContent.getId(), receiveList);
            receiveMap.put(maReceiveKey, maReceiveList);
        }
    }

}