package com.bringspring.system.permission.controller;

import cn.hutool.core.collection.CollectionUtil;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.Page;
import com.bringspring.common.base.vo.ListVO;
import com.bringspring.common.util.StringUtils;
import com.bringspring.system.permission.model.user.mod.RangeElementModel;
import com.bringspring.system.permission.model.user.vo.RangeElementSelectorVO;
import com.bringspring.system.permission.model.user.vo.UserSelectorVO;
import com.bringspring.system.permission.service.RangeService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 限定人员范围
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2017年9月26日 上午9:18
 */
@Api(tags = "限定人员范围", value = "Range")
@Slf4j
@RestController
@RequestMapping("/api/permission/Range")
public class RangeController {

    @Autowired
    private RangeService rangeService;

    /**
     * 获取范围限定前端组件数据
     * <p>
     * tab: Organize-组织,Role-角色,Position-岗位,Group-分组
     *
     * @return
     */
    @ApiOperation("获取范围限定前端组件数据")
    @PostMapping("/RangeElement/Selector/{tab}")
    public ActionResult<ListVO<RangeElementSelectorVO>> rangeElementSelector(@PathVariable String tab,
                                                                             @RequestBody Page page) {
        if (StringUtils.isEmpty(tab)) {
            return ActionResult.fail("获取失败，tab为空");
        }
        List<RangeElementSelectorVO> organizeUserList = rangeService.getOrganizeUserList(tab, page);
        ListVO<RangeElementSelectorVO> vo = new ListVO<>();
        vo.setList(organizeUserList);
        return ActionResult.success(vo);
    }

    /**
     * 获取范围限定前端组件回显数据
     * <p>
     * tab: Organize-组织,Role-角色,Position-岗位,Group-分组
     *
     * @return
     */
    @ApiOperation("获取范围限定前端组件回显数据")
    @PostMapping("/RangeElement/playback")
    public ActionResult<ListVO<RangeElementSelectorVO>> rangeElementPlayback(@RequestBody List<RangeElementModel> selected) {
        if (CollectionUtil.isEmpty(selected)) {
            return ActionResult.fail("获取失败，selected为空");
        }
        List<RangeElementSelectorVO> organizeUserList = rangeService.getOrganizeUserList(selected);
        ListVO<RangeElementSelectorVO> vo = new ListVO<>();
        vo.setList(organizeUserList);
        return ActionResult.success(vo);
    }

    /**
     * 获取用户下拉框列表(限定范围的)
     *
     * @return ignore
     */
    @ApiOperation("获取用户下拉框列表(限定范围的)")
    @PostMapping("/RangeElement/User/Selector")
    public ActionResult<ListVO<UserSelectorVO>> rangeElementUserSelector(@RequestBody List<RangeElementModel> selected) {
        if (CollectionUtil.isEmpty(selected)) {
            return ActionResult.fail("selected为空");
        }
        List<UserSelectorVO> rangeUserList = rangeService.getRangeUserList(selected);
        ListVO<UserSelectorVO> vo = new ListVO<>();
        vo.setList(rangeUserList);
        return ActionResult.success(vo);
    }

}
