package com.bringspring.system.permission.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 组织关系
 * </p>
 *
 * @author YanYu
 * @since 2022-01-19
 */
@Data
@TableName("BASE_ORGANIZE_RELATION")
@ApiModel(value = "OrganizeRelation对象", description = "组织关系")
public class OrganizeRelationEntity implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 自然主键
     */
    @TableId("ID")
    private String id;

    /**
     *
     */
    @TableField("ORGANIZE_ID")
    private String organizeId;

    /**
     * 对象类型（岗位：position、角色：role）
     */
    @TableField("OBJECT_TYPE")
    private String objectType;

    /**
     * 对象主键
     */
    @TableField("OBJECT_ID")
    private String objectId;

    /**
     * 创建时间
     */
    @TableField("CREATOR_TIME")
    private Date creatorTime;

    /**
     * 创建用户
     */
    @TableField("CREATOR_USER_ID")
    private String creatorUserId;

}
