package com.bringspring.system.permission.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.bringspring.system.permission.entity.BasePositionRelationEntity;
import com.bringspring.system.permission.model.basepositionrelation.BasePositionRelationPagination;
import com.bringspring.system.permission.model.basepositionrelation.BasePositionRelationUpForm;

import java.util.List;

/**
 * 岗位关系
 * <p>
 * 版本： V1.0.0
 * 版权： 荣科科技股份有限公司
 * 作者： RKKJ开发平台组
 * 日期： 2024-04-16
 */
public interface BasePositionRelationService extends IService<BasePositionRelationEntity> {

    List<BasePositionRelationEntity> getList(BasePositionRelationPagination basePositionRelationPagination);

    List<BasePositionRelationEntity> getTypeList(BasePositionRelationPagination basePositionRelationPagination,
                                                 String dataType);


    BasePositionRelationEntity getInfo(String id);

    List<BasePositionRelationEntity> infoByPosition(String id);

    List<BasePositionRelationEntity> getInfoByPositions(List<String> ids, String objectType);

    void delete(BasePositionRelationEntity entity);

    void deleteByPosition(BasePositionRelationUpForm basePositionRelationUpForm);

    void create(BasePositionRelationEntity entity);

    boolean update(String id, BasePositionRelationEntity entity);

    /**
     * 根据对象类型以及组织ID查询关联数据
     *
     * @param objectType
     * @param orgId
     * @return
     */
    List<BasePositionRelationEntity> getListByTypeAndPosId(String objectType, String orgId);

    List<BasePositionRelationEntity> getListByTypeAndPosId(String objectType, List<String> orgId);
}
