package com.bringspring.system.permission.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.bringspring.common.base.Page;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.system.permission.constant.PermissionConst;
import com.bringspring.system.permission.entity.*;
import com.bringspring.system.permission.model.organize.OrganizeListVO;
import com.bringspring.system.permission.model.user.mod.RangeElementModel;
import com.bringspring.system.permission.model.user.vo.RangeElementSelectorVO;
import com.bringspring.system.permission.model.user.vo.UserSelectorVO;
import com.bringspring.system.permission.service.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.logging.Logger;
import java.util.stream.Collectors;

import static com.bringspring.system.permission.constant.PermissionConst.*;

/**
 * 限定人员范围
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2017年9月26日 上午9:18
 */
@Service
@DSTransactional
public class RangeServiceImpl implements RangeService {

    @Autowired
    private OrganizeRelationService organizeRelationService;
    @Autowired
    private UserRelationService userRelationService;
    @Autowired
    private OrganizeService organizeService;
    @Autowired
    private PositionService positionService;
    @Autowired
    private GroupService groupService;
    @Autowired
    private RoleService roleService;
    @Autowired
    private UserService userService;
    Logger logger = Logger.getLogger(RangeServiceImpl.class.getName());

    @Override
    public Map<String, Object> getRangeElementSelected(List<RangeElementModel> selected) {
        Map<String, Object> typeMap = new HashMap<>();
        if (CollectionUtil.isNotEmpty(selected)) {
            for (int i = 0; i < selected.size(); i++) {
                RangeElementModel rangeElementModel = selected.get(i);
                String type = rangeElementModel.getType();
                String[] selectArr = rangeElementModel.getSelectArr();
                List<String> idList = Arrays.asList(selectArr);
                switch (type) {
                    case COMPANY: //公司
                        List<OrganizeEntity> companyList = organizeService.getOrgEntityList(idList, true);
                        typeMap.put(type, companyList);
                        break;
                    case DEPARTMENT: //部门
                        List<OrganizeEntity> departmentList = organizeService.getOrgEntityList(idList, true);
                        typeMap.put(type, departmentList);
                        break;
                    case USER: //用户
                        List<UserEntity> userList = userService.getUserByIds(idList);
                        typeMap.put(type, userList);
                        break;
                    case ROLE: //角色
                        List<RoleEntity> roleList = roleService.getListByIds(idList);
                        typeMap.put(type, roleList);
                        break;
                    case POSITION: //岗位
                        List<PositionEntity> positionList = positionService.getListByIds(idList);
                        typeMap.put(type, positionList);
                        break;
                    case GROUP: //分组
                        List<GroupEntity> groupList = groupService.getListByIds(idList);
                        typeMap.put(type, groupList);
                        break;
                    case "exclude": //排除
                        List<UserEntity> excludeList = userService.getUserByIds(idList);
                        typeMap.put(type, excludeList);
                        break;
                    default:
                        break;
                }

            }
        }
        return typeMap;
    }

    @Override
    public List<UserEntity> getRangeElementUserList(List<RangeElementModel> selected) {
        Set<String> userIds = new HashSet<>();
        Set<String> excludeUserIds = new HashSet<>();

        Map<String, Object> rangeElementSelected = this.getRangeElementSelected(selected);
        if (CollectionUtil.isNotEmpty(rangeElementSelected)) {
            for (Map.Entry<String, Object> entry : rangeElementSelected.entrySet()) {
                String type = entry.getKey();

                if (COMPANY.equals(type)) {//公司
                    List<OrganizeEntity> companys = (List<OrganizeEntity>) entry.getValue();
                    if (CollectionUtil.isNotEmpty(companys)) {
                        List<String> companyIds =
                                companys.stream().map(OrganizeEntity::getId).collect(Collectors.toList());
                        List<OrganizeEntity> listByCompanyIds = organizeService.getListByCompanyIds(companyIds);
                        List<String> orgIds =
                                listByCompanyIds.stream().map(OrganizeEntity::getId).collect(Collectors.toList());
                        List<UserEntity> userByOrgIds = userService.getUserByOrgIds(orgIds);
                        Set<String> userIdList =
                                userByOrgIds.stream().map(UserEntity::getId).collect(Collectors.toSet());
                        userIds.addAll(userIdList);
                    }
                }
                if (DEPARTMENT.equals(type)) {//部门
                    List<OrganizeEntity> departmentList = (List<OrganizeEntity>) entry.getValue();
                    if (CollectionUtil.isNotEmpty(departmentList)) {
                        List<String> orgIds =
                                departmentList.stream().map(OrganizeEntity::getId).collect(Collectors.toList());
                        List<String> underOrderOrgIds = new ArrayList<>();
                        for (String orgId : orgIds) {
                            List<String> underOrganizations = organizeService.getUnderOrganizations(orgId);
                            underOrderOrgIds.addAll(underOrganizations);
                        }
                        List<UserEntity> userByOrgIds = userService.getUserByOrgIds(underOrderOrgIds);
                        Set<String> userIdList =
                                userByOrgIds.stream().map(UserEntity::getId).collect(Collectors.toSet());
                        userIds.addAll(userIdList);
                    }

                }
                if (USER.equals(type)) {//用户
                    List<UserEntity> userList = (List<UserEntity>) entry.getValue();
                    if (CollectionUtil.isNotEmpty(userList)) {
                        Set<String> userIdList =
                                userList.stream().map(UserEntity::getId).collect(Collectors.toSet());
                        userIds.addAll(userIdList);
                    }
                }
                if (ROLE.equals(type)) {//角色
                    List<RoleEntity> roleList = (List<RoleEntity>) entry.getValue();
                    if (CollectionUtil.isNotEmpty(roleList)) {
                        for (RoleEntity entity : roleList) {
                            List<UserEntity> userListByRoleId = userService.getUserListByRoleId(entity.getId());
                            Set<String> userIdList =
                                    userListByRoleId.stream().map(UserEntity::getId).collect(Collectors.toSet());
                            userIds.addAll(userIdList);
                        }
                    }
                }
                if (POSITION.equals(type)) {//岗位
                    List<PositionEntity> positionList = (List<PositionEntity>) entry.getValue();
                    if (CollectionUtil.isNotEmpty(positionList)) {
                        List<String> objectIdList =
                                positionList.stream().map(PositionEntity::getId).collect(Collectors.toList());
                        List<UserRelationEntity> relationList = userRelationService.getListByObjectIdAll(objectIdList);
                        Set<String> userIdList =
                                relationList.stream().map(UserRelationEntity::getUserId).collect(Collectors.toSet());
                        userIds.addAll(userIdList);
                    }
                }
                if (GROUP.equals(type)) {//分组
                    List<GroupEntity> groupList = (List<GroupEntity>) entry.getValue();
                    if (CollectionUtil.isNotEmpty(groupList)) {
                        List<String> objectIdList =
                                groupList.stream().map(GroupEntity::getId).collect(Collectors.toList());
                        List<UserRelationEntity> relationList = userRelationService.getListByObjectIdAll(objectIdList);
                        Set<String> userIdList =
                                relationList.stream().map(UserRelationEntity::getUserId).collect(Collectors.toSet());
                        userIds.addAll(userIdList);
                    }
                }

                if ("exclude".equals(type)) {// 排除
                    List<UserEntity> excludeList = (List<UserEntity>) entry.getValue();
                    if (CollectionUtil.isNotEmpty(excludeList)) {
                        excludeUserIds = excludeList.stream().map(UserEntity::getId).collect(Collectors.toSet());
                    }
                }
            }
        }
        // 处理排除
        userIds.removeAll(excludeUserIds);

        List<UserEntity> list = new ArrayList<>();
        if (CollectionUtil.isNotEmpty(userIds)) {
            QueryWrapper<UserEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.lambda().in(UserEntity::getId, userIds);
            list = userService.list(queryWrapper);
        }
        return list;
    }

    @Override
    public List<RangeElementSelectorVO> getOrganizeUserList(String tab, Page page) {
        logger.info("getOrganizeUserList,计时开始-------------------" + DateUtil.daFormat(System.currentTimeMillis()));
        List<RangeElementSelectorVO> organizeUserList = new ArrayList<>();
        //获取所有组织
//        List<OrganizeEntity> allOrganize = organizeService.getList();
        //该接口已经加缓存注释，应用springBoot缓存机制
//        List<OrganizeEntity> allOrganize = organizeService.getList().stream().filter(
//                t -> "1".equals(String.valueOf(t.getEnabledMark()))
//        ).collect(Collectors.toList());
        List<OrganizeEntity> allOrganize = organizeService.getListById(true);
        List<OrganizeEntity> companyList =
                allOrganize.stream().filter(t -> PermissionConst.COMPANY.equals(t.getCategory())).collect(Collectors.toList());

        String keyword = page.getKeyword();
        if (ORGANIZE.equals(tab)) {
            //判断是否搜索关键字
            if (StringUtils.isNotEmpty(keyword)) {
                //通过关键字查询组织
//                List<OrganizeEntity> organizeList =
//                        allOrganize.stream().filter(t -> t.getFullName().contains(keyword)).collect(Collectors.toList());
                List<OrganizeEntity> organizeList = organizeService.getListAll(new ArrayList<>(), keyword); // 新增方法：数据库LIKE查询+索引
                for (OrganizeEntity organize : organizeList) {
                    RangeElementSelectorVO vo = JsonUtil.getJsonToBean(organize, RangeElementSelectorVO.class);
                    if (DEPARTMENT.equals(vo.getType())) {
                        vo.setIcon("icon-ym icon-ym-tree-department1");
                        // 新增：统计部门下用户数量  如果是一级部门，则统计部门下用户数量
                        List<String> allOrgIds = new ArrayList<>();
                        allOrgIds.add(vo.getId()); // 添加当前组织ID
                        List<String> underOrganizations = organizeService.getUnderOrganizations(organize.getId());
                        allOrgIds.addAll(underOrganizations);
                        List<UserEntity> deptUsers = userService.getUserByOrgIds(allOrgIds);
                        vo.setTotalNumber(deptUsers.size());
                    } else if (COMPANY.equals(vo.getType())) {
                        vo.setIcon("icon-ym icon-ym-tree-organization3");
                    }
                    vo.setHasChildren(false);
                    vo.setIsLeaf(true);
                    vo.setEnabledMark(1);
                    if (StringUtils.isNotEmpty(vo.getCompanyId())) {
                        OrganizeEntity company =
                                companyList.stream().filter(t -> t.getId().equals(vo.getCompanyId())).findFirst().orElse(null);
                        vo.setCompanyName(StringUtils.isNotEmpty(company.getShortName()) ? company.getShortName() :
                                company.getFullName());
                    }
                    organizeUserList.add(vo);
                }

                //通过关键字查询用户
                //该接口已经加缓存注释，应用springBoot缓存机制
                List<UserEntity> userList = userService.getList(keyword);
                //遍历用户给要返回的值插入值
                for (UserEntity entity : userList) {
                    RangeElementSelectorVO vo = JsonUtil.getJsonToBean(entity, RangeElementSelectorVO.class);
                    vo.setId(entity.getId());
                    vo.setParentId(entity.getOrganizeId());
                    vo.setFullName(entity.getRealName());
                    vo.setHeadIcon(entity.getHeadIcon());
                    vo.setType(USER);
                    vo.setIcon("icon-ym icon-ym-tree-user2");
                    vo.setHasChildren(false);
                    vo.setIsLeaf(true);
                    vo.setEnabledMark(1);
                    OrganizeEntity organize =
                            allOrganize.stream().filter(t -> t.getId().equals(entity.getOrganizeId())).findFirst().orElse(null);
                    if (ObjectUtil.isNotEmpty(organize)) {
                        vo.setOrganizeName(StringUtils.isNotEmpty(organize.getShortName()) ? organize.getShortName() :
                                organize.getFullName());
                        if (StringUtils.isNotEmpty(organize.getOrganizeId())) {
                            OrganizeEntity company =
                                    companyList.stream().filter(t -> t.getId().equals(organize.getOrganizeId())).findFirst().orElse(null);
                            if (ObjectUtil.isNotEmpty(company)) {
                                vo.setCompanyName(StringUtils.isNotEmpty(company.getShortName()) ?
                                        company.getShortName() : company.getFullName());
                            }
                        }
                    }
                    if (StringUtils.isNotEmpty(entity.getPositionId())) {
                        List<String> positionIds = Arrays.asList(entity.getPositionId().split(","));
                        List<PositionEntity> positionList = positionService.getPositionList(positionIds);
                        String positionNames =
                                positionList.stream().map(PositionEntity::getFullName).collect(Collectors.joining(","));
                        vo.setPositionName(positionNames);
                    }
                    organizeUserList.add(vo);
                }
            } else {
                //获取组织树形数据
                List<OrganizeListVO> organizeListTree = getOrganizeListTree("-1", allOrganize);
                //获取所有用户
//                List<UserEntity> allUser = userService.getList();
                if (CollectionUtil.isNotEmpty(organizeListTree)) {
                    List<RangeElementSelectorVO> jsonToList = JsonUtil.getJsonToList(organizeListTree,
                            RangeElementSelectorVO.class);
                    this.recursionSettingUser(jsonToList, new ArrayList<>(), companyList);
                    organizeUserList.addAll(jsonToList);
                }
            }
        }

        if (ROLE.equals(tab)) {
            List<RoleEntity> roleList = roleService.getList(keyword);
            for (RoleEntity entity : roleList) {
                RangeElementSelectorVO vo = JsonUtil.getJsonToBean(entity, RangeElementSelectorVO.class);
                vo.setId(entity.getId());
                vo.setType(ROLE);
                vo.setIcon("icon-ym icon-ym-role");
                vo.setHasChildren(false);
                vo.setIsLeaf(true);
                vo.setEnabledMark(1);
                // 新增：统计角色下用户数量
                List<UserRelationEntity> roleUsers = userRelationService.getListByObjectId(entity.getId(), ROLE);
                vo.setTotalNumber(roleUsers.size());
                List<OrganizeRelationEntity> relList = organizeRelationService.getRelationListByRoleId(entity.getId());
                OrganizeRelationEntity organizeRelation = CollectionUtil.isEmpty(relList) ? null : relList.get(0);
                if (ObjectUtil.isNotEmpty(organizeRelation)) {
                    OrganizeEntity organize =
                            allOrganize.stream().filter(t -> t.getId().equals(organizeRelation.getOrganizeId())).findFirst().orElse(null);
                    if (ObjectUtil.isNotEmpty(organize)) {
                        vo.setOrganizeName(StringUtils.isNotEmpty(organize.getShortName()) ? organize.getShortName() :
                                organize.getFullName());
                        if (StringUtils.isNotEmpty(organize.getOrganizeId())) {
                            OrganizeEntity company =
                                    companyList.stream().filter(t -> t.getId().equals(organize.getOrganizeId())).findFirst().orElse(null);
                            if (ObjectUtil.isNotEmpty(company)) {
                                vo.setCompanyName(StringUtils.isNotEmpty(company.getShortName()) ?
                                        company.getShortName() : company.getFullName());
                            }
                        }
                    }
                }
                organizeUserList.add(vo);
            }
        }
        if (POSITION.equals(tab)) {
            List<PositionEntity> positionList = positionService.getList(keyword);
            for (PositionEntity entity : positionList) {
                RangeElementSelectorVO vo = JsonUtil.getJsonToBean(entity, RangeElementSelectorVO.class);
                vo.setId(entity.getId());
                vo.setType(POSITION);
                vo.setIcon("icon-ym icon-ym-position");
                vo.setHasChildren(false);
                vo.setIsLeaf(true);
                vo.setEnabledMark(1);
                // 新增：统计岗位下用户数量
                List<UserRelationEntity> positionUsers = userRelationService.getListByObjectId(entity.getId(), POSITION);
                vo.setTotalNumber(positionUsers.size());
                List<OrganizeRelationEntity> relList =
                        organizeRelationService.getRelationListByObjectIdAndType(POSITION,
                                entity.getId());
                OrganizeRelationEntity organizeRelation = CollectionUtil.isEmpty(relList) ? null : relList.get(0);
                if (ObjectUtil.isNotEmpty(organizeRelation)) {
                    OrganizeEntity organize =
                            allOrganize.stream().filter(t -> t.getId().equals(organizeRelation.getOrganizeId())).findFirst().orElse(null);
                    if (ObjectUtil.isNotEmpty(organize)) {
                        vo.setOrganizeName(StringUtils.isNotEmpty(organize.getShortName()) ? organize.getShortName() :
                                organize.getFullName());
                        if (StringUtils.isNotEmpty(organize.getOrganizeId())) {
                            OrganizeEntity company =
                                    companyList.stream().filter(t -> t.getId().equals(organize.getOrganizeId())).findFirst().orElse(null);
                            if (ObjectUtil.isNotEmpty(company)) {
                                vo.setCompanyName(StringUtils.isNotEmpty(company.getShortName()) ?
                                        company.getShortName() : company.getFullName());
                            }
                        }
                    }
                }
                organizeUserList.add(vo);
            }
        }
        if (GROUP.equals(tab)) {
            List<GroupEntity> groupList = groupService.list(keyword);
            for (GroupEntity entity : groupList) {
                RangeElementSelectorVO vo = JsonUtil.getJsonToBean(entity, RangeElementSelectorVO.class);
                vo.setId(entity.getId());
                vo.setType(GROUP);
                vo.setIcon("icon-ym icon-ym-group");
                vo.setHasChildren(false);
                vo.setIsLeaf(true);
                vo.setEnabledMark(1);
                // 新增：统计分组下用户数量
                List<UserRelationEntity> groupUsers = userRelationService.getListByObjectId(entity.getId(), GROUP);
                vo.setTotalNumber(groupUsers.size());
                organizeUserList.add(vo);
            }
        }
        logger.info("getOrganizeUserList,计时结束-------------------" + DateUtil.daFormat(System.currentTimeMillis()));
        return organizeUserList;
    }


    private List<OrganizeListVO> getOrganizeListTree(String parentId, List<OrganizeEntity> allOrganize) {
        // 递归获取设备类型树状数据
        List<OrganizeEntity> listByParentId =
                allOrganize.stream().filter(t -> t.getParentId().equals(parentId)).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(listByParentId)) {
            List<OrganizeListVO> listVO = JsonUtil.getJsonToList(listByParentId, OrganizeListVO.class);
            recursionOrganizeTree(listVO, allOrganize);
            return listVO;
        } else {
            return null;
        }
    }

    private void recursionOrganizeTree(List<OrganizeListVO> returnList, List<OrganizeEntity> allOrganize) {
        for (OrganizeListVO organizeListVO : returnList) {
            List<OrganizeEntity> listChild =
                    allOrganize.stream().filter(t -> t.getParentId().equals(organizeListVO.getId())).collect(Collectors.toList());
            if (!ObjectUtil.isEmpty(listChild)) {
                List<OrganizeListVO> listVO = JsonUtil.getJsonToList(listChild, OrganizeListVO.class);
                organizeListVO.setChildren(listVO);
                recursionOrganizeTree(listVO, allOrganize);
            } else {
                // 移除return，改为设置空列表，确保节点能被正确渲染
                organizeListVO.setChildren(new ArrayList<>());
            }
        }
    }

    private void recursionSettingUser(List<RangeElementSelectorVO> organizeList, List<UserEntity> allUser,
                                      List<OrganizeEntity> companyList) {
        if (CollectionUtil.isNotEmpty(organizeList)) {
            for (RangeElementSelectorVO organizeVo : organizeList) {
                if (StringUtils.isNotEmpty(organizeVo.getCompanyId())) {
                    OrganizeEntity company =
                            companyList.stream().filter(t -> t.getId().equals(organizeVo.getCompanyId())).findFirst().orElse(null);
                    if (ObjectUtil.isNotEmpty(company)) {
                        organizeVo.setCompanyName(StringUtils.isNotEmpty(company.getShortName()) ?
                                company.getShortName() : company.getFullName());
                    }
                }
                List<RangeElementSelectorVO> children = organizeVo.getChildren();
                if (CollectionUtil.isNotEmpty(children)) {
                    this.recursionSettingUser(children, allUser, companyList);
                    organizeVo.setHasChildren(true);
                } else {
                    organizeVo.setHasChildren(false);
                }
                if ("department".equals(organizeVo.getType())) {
                    organizeVo.setIcon("icon-ym icon-ym-tree-department1");
                } else if (PermissionConst.COMPANY.equals(organizeVo.getType())) {
                    organizeVo.setIcon("icon-ym icon-ym-tree-organization3");
                }
                // 判断组织下是否有人
                List<UserRelationEntity> relationEntities = this.userRelationService.list(Wrappers.<UserRelationEntity>lambdaQuery()
                        .in(UserRelationEntity::getObjectId, organizeVo.getId()).eq(UserRelationEntity::getObjectType, ORGANIZE));
                List<String> relationIds = relationEntities.stream().map(UserRelationEntity::getUserId).collect(Collectors.toList());
                //并行流
//                List<UserEntity> userList = allUser.parallelStream().filter(user -> relationIds.contains(user.getId()))
//                        .collect(Collectors.toList());
                // 判断组织下是否有人：直接查询当前组织的用户（替代全量过滤）
                List<UserEntity> userList = userService.getUserByIds(relationIds); // 新增方法：按组织ID查用户
                if (CollectionUtil.isNotEmpty(userList)) {
                    organizeVo.getFullName();

                    if (CollectionUtil.isEmpty(children)) {
                        children = new ArrayList<>();
                        organizeVo.setChildren(children);
                        organizeVo.setHasChildren(true);
                    }
                    List<RangeElementSelectorVO> userVoList = new ArrayList<>();
                    //遍历用户给要返回的值插入值
                    for (UserEntity entity : userList) {
                        RangeElementSelectorVO vo = JsonUtil.getJsonToBean(entity, RangeElementSelectorVO.class);
                        vo.setId(entity.getId());
                        vo.setParentId(entity.getOrganizeId());
                        vo.setFullName(entity.getRealName());
                        vo.setHeadIcon(entity.getHeadIcon());
                        vo.setType("user");
                        vo.setIcon("icon-ym icon-ym-tree-user2");
                        vo.setHasChildren(false);
                        vo.setIsLeaf(true);
                        vo.setEnabledMark(1);
                        vo.setOrganizeName(organizeVo.getFullName());
                        vo.setCompanyName(organizeVo.getCompanyName());
                        if (StringUtils.isNotEmpty(entity.getPositionId())) {
                            List<String> positionIds = Arrays.asList(entity.getPositionId().split(","));
                            List<PositionEntity> positionList = positionService.getPositionList(positionIds);
                            String positionNames =
                                    positionList.stream().map(PositionEntity::getFullName).collect(Collectors.joining(","));
                            vo.setPositionName(positionNames);
                        }
                        userVoList.add(vo);
                    }
                    children.addAll(0, userVoList); // 头部插入
                }
                // 新增：设置组织下用户总数
                if (StrUtil.equals(organizeVo.getType(), COMPANY)) {
                    //查询该公司下所有用户
                    List<UserEntity> listByCompanyId = userService.getListByOraganizetionId(organizeVo.getId());
                    organizeVo.setTotalNumber(listByCompanyId.size());
                } else {
                    List<UserEntity> allUserList = new ArrayList<>();
                    List<String> allOrgIds = new ArrayList<>();
                    allOrgIds.add(organizeVo.getId()); // 添加当前组织ID

                    // 检查是否有子组织
                    List<RangeElementSelectorVO> childrenList = organizeVo.getChildren();
                    boolean hasSubOrg = CollectionUtil.isNotEmpty(childrenList) &&
                            childrenList.stream().anyMatch(child -> !USER.equals(child.getType()));
                    if (hasSubOrg) {
                        // 如果有子组织，获取所有下级组织ID
                        List<String> underOrganizations = organizeService.getUnderOrganizations(organizeVo.getId());
                        allOrgIds.addAll(underOrganizations);

                        // 获取所有下级组织的用户用于统计总人数
                        allUserList = userService.getUserByOrgIds(allOrgIds);
                        organizeVo.setTotalNumber(allUserList.size());
                    } else {
                        organizeVo.setTotalNumber(userList.size());
                    }
                }
                organizeVo.setIsLeaf(!organizeVo.getHasChildren()); // 是否叶子
            }
        }
    }

    @Override
    public List<RangeElementSelectorVO> getOrganizeUserList(List<RangeElementModel> selected) {
        List<RangeElementSelectorVO> organizeUserList = new ArrayList<>();
        //获取所有组织
//        List<OrganizeEntity> allOrganize = organizeService.getList();
        List<OrganizeEntity> allOrganize = organizeService.getList().stream().filter(
                t -> "1".equals(String.valueOf(t.getEnabledMark()))
        ).collect(Collectors.toList());
        List<OrganizeEntity> companyList =
                allOrganize.stream().filter(t -> PermissionConst.COMPANY.equals(t.getCategory())).collect(Collectors.toList());

        Map<String, Object> rangeElementSelected = this.getRangeElementSelected(selected);
        for (Map.Entry<String, Object> entry : rangeElementSelected.entrySet()) {
            String type = entry.getKey();

            if (COMPANY.equals(type)) {//公司
                List<OrganizeEntity> companys = (List<OrganizeEntity>) entry.getValue();
                if (CollectionUtil.isNotEmpty(companys)) {
                    List<RangeElementSelectorVO> companyVOList = JsonUtil.getJsonToList(companys,
                            RangeElementSelectorVO.class);
                    for (RangeElementSelectorVO vo : companyVOList) {
                        vo.setIcon("icon-ym icon-ym-tree-organization3");
                        vo.setHasChildren(false);
                        vo.setIsLeaf(true);
                        vo.setEnabledMark(1);
                        //获取本组织以及子组织的所有用户
                        List<UserEntity> listByOraganizetionId = userService.getListByOraganizetionId(vo.getId());
                        vo.setTotalNumber(listByOraganizetionId.size());
                        List<RangeElementSelectorVO> rangeElementSelectorVOS = JsonUtil.getJsonToList(listByOraganizetionId, RangeElementSelectorVO.class);
                        rangeElementSelectorVOS.forEach(t -> {
                            t.setType(USER);
                        });
                        vo.setChildren(rangeElementSelectorVOS);
                    }
                    organizeUserList.addAll(companyVOList);
                }

            }
            if (DEPARTMENT.equals(type)) {//部门
                List<OrganizeEntity> departmentList = (List<OrganizeEntity>) entry.getValue();
                if (CollectionUtil.isNotEmpty(departmentList)) {
                    List<RangeElementSelectorVO> departmentVOList = JsonUtil.getJsonToList(departmentList,
                            RangeElementSelectorVO.class);
                    for (RangeElementSelectorVO vo : departmentVOList) {
                        vo.setIcon("icon-ym icon-ym-tree-department1");
                        vo.setHasChildren(false);
                        vo.setIsLeaf(true);
                        vo.setEnabledMark(1);
                        if (StringUtils.isNotEmpty(vo.getCompanyId())) {
                            OrganizeEntity company =
                                    companyList.stream().filter(t -> t.getId().equals(vo.getCompanyId())).findFirst().orElse(null);
                            vo.setCompanyName(StringUtils.isNotEmpty(company.getShortName()) ?
                                    company.getShortName() : company.getFullName());
                        }
                        //获取本组织下的用户 20250828
                        //如果当前组织是一级组织，请判断children中是否有子组织，如果有子组织，先通过organizeService.getUnderOrganizations(vo.getId())获取所有子组织和当前组织，然后再去获取用户，注意这个时候获取的所有用户仅用于setTotalNumber属性赋值
                        List<UserEntity> allUserList = new ArrayList<>();
                        List<String> allOrgIds = new ArrayList<>();
                        allOrgIds.add(vo.getId()); // 添加当前组织ID
                        // 如果有子组织，获取所有下级组织ID
                        List<String> underOrganizations = organizeService.getUnderOrganizations(vo.getId());
                        allOrgIds.addAll(underOrganizations);
                        // 获取所有下级组织的用户用于统计总人数
                        allUserList = userService.getUserByOrgIds(allOrgIds);
                        vo.setTotalNumber(allUserList.size());
                        List<RangeElementSelectorVO> rangeElementSelectorVOS = JsonUtil.getJsonToList(allUserList, RangeElementSelectorVO.class);
                        rangeElementSelectorVOS.forEach(t -> {
                            t.setType(USER);
                        });
                        vo.setChildren(rangeElementSelectorVOS);
                    }
                    organizeUserList.addAll(departmentVOList);
                }
            }
            if (USER.equals(type)) {//用户
                List<UserEntity> userList = (List<UserEntity>) entry.getValue();
                if (CollectionUtil.isNotEmpty(userList)) {
                    for (UserEntity entity : userList) {
                        RangeElementSelectorVO vo = JsonUtil.getJsonToBean(entity, RangeElementSelectorVO.class);
                        vo.setId(entity.getId());
                        vo.setParentId(entity.getOrganizeId());
                        vo.setFullName(entity.getRealName());
                        vo.setHeadIcon(entity.getHeadIcon());
                        vo.setType(USER);
                        vo.setIcon("icon-ym icon-ym-tree-user2");
                        vo.setHasChildren(false);
                        vo.setIsLeaf(true);
                        vo.setEnabledMark(1);
                        vo.setTotalNumber(1);
                        OrganizeEntity organize =
                                allOrganize.stream().filter(t -> t.getId().equals(entity.getOrganizeId())).findFirst().orElse(null);
                        if (ObjectUtil.isNotEmpty(organize)) {
                            vo.setOrganizeName(StringUtils.isNotEmpty(organize.getShortName()) ?
                                    organize.getShortName() :
                                    organize.getFullName());
                            if (StringUtils.isNotEmpty(organize.getOrganizeId())) {
                                OrganizeEntity company =
                                        companyList.stream().filter(t -> t.getId().equals(organize.getOrganizeId())).findFirst().orElse(null);
                                if (ObjectUtil.isNotEmpty(company)) {
                                    vo.setCompanyName(StringUtils.isNotEmpty(company.getShortName()) ?
                                            company.getShortName() : company.getFullName());
                                }
                            }
                        }
                        if (StringUtils.isNotEmpty(entity.getPositionId())) {
                            List<String> positionIds = Arrays.asList(entity.getPositionId().split(","));
                            List<PositionEntity> positionList = positionService.getPositionList(positionIds);
                            String positionNames =
                                    positionList.stream().map(PositionEntity::getFullName).collect(Collectors.joining(","));
                            vo.setPositionName(positionNames);
                        }
                        organizeUserList.add(vo);
                    }
                }
            }
            if (ROLE.equals(type)) {//角色
                List<RoleEntity> roleList = (List<RoleEntity>) entry.getValue();
                if (CollectionUtil.isNotEmpty(roleList)) {
                    for (RoleEntity entity : roleList) {
                        RangeElementSelectorVO vo = JsonUtil.getJsonToBean(entity, RangeElementSelectorVO.class);
                        vo.setId(entity.getId());
                        vo.setType(ROLE);
                        vo.setIcon("icon-ym icon-ym-role");
                        vo.setHasChildren(false);
                        vo.setIsLeaf(true);
                        vo.setEnabledMark(1);

                        List<OrganizeRelationEntity> relList =
                                organizeRelationService.getRelationListByRoleId(entity.getId());
                        OrganizeRelationEntity organizeRelation = CollectionUtil.isEmpty(relList) ? null :
                                relList.get(0);
                        //获取角色下的用户
                        List<UserRelationEntity> listByObjectId = userRelationService.getListByObjectId(entity.getId(), ROLE);
                        vo.setTotalNumber(listByObjectId.size());
                        if (ObjectUtil.isNotEmpty(organizeRelation)) {
                            OrganizeEntity organize =
                                    allOrganize.stream().filter(t -> t.getId().equals(organizeRelation.getOrganizeId())).findFirst().orElse(null);
                            if (ObjectUtil.isNotEmpty(organize)) {
                                vo.setOrganizeName(StringUtils.isNotEmpty(organize.getShortName()) ?
                                        organize.getShortName() :
                                        organize.getFullName());
                                if (StringUtils.isNotEmpty(organize.getOrganizeId())) {
                                    OrganizeEntity company =
                                            companyList.stream().filter(t -> t.getId().equals(organize.getOrganizeId())).findFirst().orElse(null);
                                    if (ObjectUtil.isNotEmpty(company)) {
                                        vo.setCompanyName(StringUtils.isNotEmpty(company.getShortName()) ?
                                                company.getShortName() : company.getFullName());
                                    }
                                }
                            }
                        }
                        organizeUserList.add(vo);
                    }
                }
            }
            if (POSITION.equals(type)) {//岗位
                List<PositionEntity> positionList = (List<PositionEntity>) entry.getValue();
                if (CollectionUtil.isNotEmpty(positionList)) {
                    for (PositionEntity entity : positionList) {
                        RangeElementSelectorVO vo = JsonUtil.getJsonToBean(entity, RangeElementSelectorVO.class);
                        vo.setId(entity.getId());
                        vo.setType(POSITION);
                        vo.setIcon("icon-ym icon-ym-position");
                        vo.setHasChildren(false);
                        vo.setIsLeaf(true);
                        vo.setEnabledMark(1);

                        List<OrganizeRelationEntity> relList =
                                organizeRelationService.getRelationListByObjectIdAndType(POSITION,
                                        entity.getId());
                        OrganizeRelationEntity organizeRelation = CollectionUtil.isEmpty(relList) ? null :
                                relList.get(0);
                        //获取岗位下的用户
                        List<UserRelationEntity> listByObjectId = userRelationService.getListByObjectId(entity.getId(), POSITION);
                        vo.setTotalNumber(listByObjectId.size());
                        if (ObjectUtil.isNotEmpty(organizeRelation)) {
                            OrganizeEntity organize =
                                    allOrganize.stream().filter(t -> t.getId().equals(organizeRelation.getOrganizeId())).findFirst().orElse(null);
                            if (ObjectUtil.isNotEmpty(organize)) {
                                vo.setOrganizeName(StringUtils.isNotEmpty(organize.getShortName()) ?
                                        organize.getShortName() :
                                        organize.getFullName());
                                if (StringUtils.isNotEmpty(organize.getOrganizeId())) {
                                    OrganizeEntity company =
                                            companyList.stream().filter(t -> t.getId().equals(organize.getOrganizeId())).findFirst().orElse(null);
                                    if (ObjectUtil.isNotEmpty(company)) {
                                        vo.setCompanyName(StringUtils.isNotEmpty(company.getShortName()) ?
                                                company.getShortName() : company.getFullName());
                                    }
                                }
                            }
                        }
                        organizeUserList.add(vo);
                    }
                }
            }
            if (GROUP.equals(type)) {//分组
                List<GroupEntity> groupList = (List<GroupEntity>) entry.getValue();
                if (CollectionUtil.isNotEmpty(groupList)) {
                    for (GroupEntity entity : groupList) {
                        RangeElementSelectorVO vo = JsonUtil.getJsonToBean(entity,
                                RangeElementSelectorVO.class);
                        vo.setId(entity.getId());
                        vo.setType(GROUP);
                        vo.setIcon("icon-ym icon-ym-group");
                        vo.setHasChildren(false);
                        vo.setIsLeaf(true);
                        vo.setEnabledMark(1);
                        //获取分组下的用户
                        List<UserRelationEntity> listByObjectId = userRelationService.getListByObjectId(entity.getId(), GROUP);
                        vo.setTotalNumber(listByObjectId.size());
                        organizeUserList.add(vo);
                    }
                }
            }
        }

        return organizeUserList;
    }

    @Override
    public List<UserSelectorVO> getRangeUserList(List<RangeElementModel> selected) {
        List<UserSelectorVO> listvo = new ArrayList<>();
        List<UserEntity> userData = this.getRangeElementUserList(selected);
        if (CollectionUtil.isNotEmpty(userData)) {
            //获取所有组织
            List<OrganizeEntity> allOrganize = organizeService.getList();
            List<OrganizeEntity> companyList =
                    allOrganize.stream().filter(t -> PermissionConst.COMPANY.equals(t.getCategory())).collect(Collectors.toList());

            for (UserEntity entity : userData) {
                UserSelectorVO vo = JsonUtil.getJsonToBean(entity, UserSelectorVO.class);
                vo.setId(entity.getId());
                vo.setParentId(entity.getOrganizeId());
                vo.setFullName(entity.getRealName());
                vo.setHeadIcon(entity.getHeadIcon());
                vo.setType("user");
                vo.setIcon("icon-ym icon-ym-tree-user2");
                vo.setHasChildren(false);
                vo.setIsLeaf(true);
                vo.setEnabledMark(1);

                OrganizeEntity organize =
                        allOrganize.stream().filter(t -> t.getId().equals(entity.getOrganizeId())).findFirst().orElse(null);
                if (ObjectUtil.isNotEmpty(organize)) {
                    vo.setOrganizeName(StringUtils.isNotEmpty(organize.getShortName()) ?
                            organize.getShortName() :
                            organize.getFullName());
                    if (StringUtils.isNotEmpty(organize.getOrganizeId())) {
                        OrganizeEntity company =
                                companyList.stream().filter(t -> t.getId().equals(organize.getOrganizeId())).findFirst().orElse(null);
                        if (ObjectUtil.isNotEmpty(company)) {
                            vo.setCompanyName(StringUtils.isNotEmpty(company.getShortName()) ?
                                    company.getShortName() : company.getFullName());
                        }
                    }
                }
                if (StringUtils.isNotEmpty(entity.getPositionId())) {
                    List<String> positionIds = Arrays.asList(entity.getPositionId().split(","));
                    List<PositionEntity> positionList = positionService.getPositionList(positionIds);
                    String positionNames =
                            positionList.stream().map(PositionEntity::getFullName).collect(Collectors.joining(","));
                    vo.setPositionName(positionNames);
                }
                listvo.add(vo);
            }

        }

        return listvo;
    }

    @Override
    public List<UserEntity> getRangeUserList(String rangeStr) {
        if (StringUtils.isEmpty(rangeStr)) {
            return new ArrayList<>();
        }
        List<RangeElementModel> selected = JsonUtil.getJsonToList(rangeStr, RangeElementModel.class);
        return this.getRangeElementUserList(selected);
    }
}
