/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.base.controller;

import com.bringspring.common.annotation.NotRecordedLog;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.filter.RepeatSubmit;
import com.bringspring.common.util.CacheKeyUtil;
import com.bringspring.common.util.CacheUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.system.base.entity.ModuleEntity;
import com.bringspring.system.base.model.basemoduleoffen.BaseModuleOffenCrForm;
import com.bringspring.system.base.model.basemoduleoffen.BaseModuleOffenPagination;
import com.bringspring.system.base.service.BaseModuleOffenService;
import com.bringspring.system.base.service.ModuleService;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.exception.PermissionException;
import com.bringspring.system.permission.mapper.UserMapper;
import com.bringspring.system.permission.service.UserService;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"pc\u5e38\u7528\u83dc\u5355"}, value="system")
@RequestMapping(value={"/api/system/BaseModuleOffen"})
public class BaseModuleOffenController {
    private static final Logger log = LoggerFactory.getLogger(BaseModuleOffenController.class);
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private UserService userService;
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private BaseModuleOffenService baseModuleOffenService;
    @Autowired
    private ModuleService moduleService;
    @Autowired
    private CacheKeyUtil cacheKeyUtil;
    @Autowired
    private CacheUtil cacheUtil;

    @NotRecordedLog
    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody BaseModuleOffenPagination baseModuleOffenPagination) throws IOException {
        List<String> list = this.baseModuleOffenService.getList();
        ArrayList<ModuleEntity> moduleEntityList = new ArrayList<ModuleEntity>();
        if (!list.isEmpty()) {
            for (String moduleId : list) {
                ModuleEntity info = this.moduleService.getInfo(moduleId);
                if (info == null) continue;
                moduleEntityList.add(info);
            }
        }
        PageListVO vo = new PageListVO();
        vo.setList(moduleEntityList);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)baseModuleOffenPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @RepeatSubmit
    @PostMapping
    @Transactional
    public ActionResult createUserCommonMenu(@RequestBody @Valid BaseModuleOffenCrForm baseModuleOffenCrForm) throws PermissionException {
        UserInfo userInfo = this.userProvider.get();
        UserEntity userEntity = this.userService.getInfo(userInfo.getUserId());
        userEntity.setCommonMenu("");
        List<String> moduleIdList = baseModuleOffenCrForm.getModuleIdList();
        if (moduleIdList != null && !moduleIdList.isEmpty()) {
            StringBuilder moduleIds = new StringBuilder();
            for (String moduleId : moduleIdList) {
                moduleIds.append(moduleId).append(",");
            }
            if (moduleIds.length() > 0) {
                moduleIds.deleteCharAt(moduleIds.length() - 1);
            }
            userEntity.setCommonMenu(moduleIds.toString());
        }
        try {
            this.userService.update(userEntity);
            return ActionResult.success((String)"\u6dfb\u52a0\u6210\u529f!");
        }
        catch (Exception e) {
            return ActionResult.fail((String)("\u66f4\u65b0\u5e38\u7528\u83dc\u5355\u5931\u8d25: " + e.getMessage()));
        }
    }

    @DeleteMapping(value={"/{id}"})
    @Transactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        UserInfo userInfo = this.userProvider.get();
        UserEntity userEntity = this.userService.getInfo(userInfo.getUserId());
        List<String> list = this.baseModuleOffenService.getList();
        Iterator<String> iterator = list.iterator();
        for (String moduleId : list) {
            if (!moduleId.equals(id)) continue;
            iterator.remove();
        }
        String moduleIds = "";
        for (int i = 0; i < list.size(); ++i) {
            moduleIds = moduleIds + list.get(i) + ",";
        }
        int count = 0;
        char ch = ',';
        for (int i = 0; i < moduleIds.length(); ++i) {
            if (moduleIds.charAt(i) != ch) continue;
            ++count;
        }
        if (count > 1) {
            String newModuleIds = moduleIds.substring(0, moduleIds.length() - 1);
            userEntity.setCommonMenu(newModuleIds);
        }
        String cacheKey = this.cacheKeyUtil.getUserAuthorize() + userInfo.getUserId();
        this.cacheUtil.remove("loginCacheSpace", cacheKey);
        this.userMapper.updateById(userEntity);
        return ActionResult.success((String)"\u53d6\u6d88\u6210\u529f");
    }
}

