/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.base.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.ServletUtils;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.system.base.entity.AreagroupEntity;
import com.bringspring.system.base.entity.ArearelationEntity;
import com.bringspring.system.base.entity.ProvinceEntity;
import com.bringspring.system.base.mapper.AreagroupMapper;
import com.bringspring.system.base.model.areagroup.AreagroupCrForm;
import com.bringspring.system.base.model.areagroup.AreagroupPagination;
import com.bringspring.system.base.model.areagroup.AreagroupUpForm;
import com.bringspring.system.base.service.AreagroupService;
import com.bringspring.system.base.service.ArearelationService;
import com.bringspring.system.base.service.ProvinceService;
import com.bringspring.system.permission.model.authorize.AuthorizeConditionModel;
import com.bringspring.system.permission.service.AuthorizeService;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AreagroupServiceImpl
extends ServiceImpl<AreagroupMapper, AreagroupEntity>
implements AreagroupService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private ArearelationService arearelationService;
    @Autowired
    private ProvinceService provinceService;

    @Override
    public List<AreagroupEntity> getList(AreagroupPagination areagroupPagination) {
        Object crmProductBuyObj;
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int areagroupNum = 0;
        QueryWrapper areagroupQueryWrapper = new QueryWrapper();
        boolean pcPermission = true;
        boolean appPermission = false;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            crmProductBuyObj = this.authorizeService.getCondition(new AuthorizeConditionModel(areagroupQueryWrapper, areagroupPagination.getMenuId(), "base_province_group"));
            if (ObjectUtil.isEmpty((Object)crmProductBuyObj)) {
                return new ArrayList<AreagroupEntity>();
            }
            areagroupQueryWrapper = (QueryWrapper)crmProductBuyObj;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            crmProductBuyObj = this.authorizeService.getCondition(new AuthorizeConditionModel(areagroupQueryWrapper, areagroupPagination.getMenuId(), "base_province_group"));
            if (ObjectUtil.isEmpty((Object)crmProductBuyObj)) {
                return new ArrayList<AreagroupEntity>();
            }
            areagroupQueryWrapper = (QueryWrapper)crmProductBuyObj;
        }
        boolean arearelationNum = false;
        QueryWrapper arearelationQueryWrapper = new QueryWrapper();
        if (ObjectUtil.isNotEmpty((Object)areagroupPagination.getType())) {
            ++areagroupNum;
            areagroupQueryWrapper.lambda().eq(AreagroupEntity::getType, (Object)areagroupPagination.getType());
        }
        if (ObjectUtil.isNotEmpty((Object)areagroupPagination.getCompanyId())) {
            ++areagroupNum;
            areagroupQueryWrapper.lambda().eq(AreagroupEntity::getCompanyId, (Object)areagroupPagination.getCompanyId());
        }
        if (StringUtils.isNotEmpty((String)areagroupPagination.getFullName())) {
            ++areagroupNum;
            areagroupQueryWrapper.lambda().like(AreagroupEntity::getFullName, (Object)areagroupPagination.getFullName());
        }
        if (StringUtils.isNotEmpty((String)areagroupPagination.getEncode())) {
            ++areagroupNum;
            areagroupQueryWrapper.lambda().like(AreagroupEntity::getEncode, (Object)areagroupPagination.getEncode());
        }
        if (StringUtils.isNotEmpty((String)areagroupPagination.getOrganizeId())) {
            ++areagroupNum;
            areagroupQueryWrapper.lambda().like(AreagroupEntity::getOrganizeId, (Object)areagroupPagination.getOrganizeId());
        }
        if (StringUtils.isNotEmpty((String)areagroupPagination.getKeyword())) {
            ((LambdaQueryWrapper)((LambdaQueryWrapper)areagroupQueryWrapper.lambda().like(AreagroupEntity::getFullName, (Object)areagroupPagination.getKeyword())).or()).like(AreagroupEntity::getEncode, (Object)areagroupPagination.getKeyword());
        }
        if (AllIdList.size() > 0) {
            areagroupQueryWrapper.lambda().in(AreagroupEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)areagroupPagination.getSidx())) {
            areagroupQueryWrapper.lambda().orderByDesc(AreagroupEntity::getId);
        } else {
            try {
                String sidx = areagroupPagination.getSidx();
                AreagroupEntity areagroupEntity = new AreagroupEntity();
                Field declaredField = areagroupEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                areagroupQueryWrapper = "asc".equals(areagroupPagination.getSort().toLowerCase()) ? (QueryWrapper)areagroupQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)areagroupQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(areagroupPagination.getCurrentPage(), areagroupPagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)areagroupQueryWrapper);
            return areagroupPagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list = new ArrayList();
        return areagroupPagination.setData(list, list.size());
    }

    @Override
    public List<AreagroupEntity> getTypeList(AreagroupPagination areagroupPagination, String dataType) {
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int areagroupNum = 0;
        QueryWrapper areagroupQueryWrapper = new QueryWrapper();
        boolean arearelationNum = false;
        QueryWrapper arearelationQueryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((String)areagroupPagination.getFullName())) {
            ++areagroupNum;
            areagroupQueryWrapper.lambda().like(AreagroupEntity::getFullName, (Object)areagroupPagination.getFullName());
        }
        if (StringUtils.isNotEmpty((String)areagroupPagination.getEncode())) {
            ++areagroupNum;
            areagroupQueryWrapper.lambda().like(AreagroupEntity::getEncode, (Object)areagroupPagination.getEncode());
        }
        if (AllIdList.size() > 0) {
            areagroupQueryWrapper.lambda().in(AreagroupEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)areagroupPagination.getSidx())) {
            areagroupQueryWrapper.lambda().orderByDesc(AreagroupEntity::getId);
        } else {
            try {
                String sidx = areagroupPagination.getSidx();
                AreagroupEntity areagroupEntity = new AreagroupEntity();
                Field declaredField = areagroupEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                areagroupQueryWrapper = "asc".equals(areagroupPagination.getSort().toLowerCase()) ? (QueryWrapper)areagroupQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)areagroupQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ("0".equals(dataType)) {
            if (total > 0 && AllIdList.size() > 0 || total == 0) {
                Page page = new Page(areagroupPagination.getCurrentPage(), areagroupPagination.getPageSize());
                IPage userIPage = this.page((IPage)page, (Wrapper)areagroupQueryWrapper);
                return areagroupPagination.setData(userIPage.getRecords(), userIPage.getTotal());
            }
            ArrayList list = new ArrayList();
            return areagroupPagination.setData(list, list.size());
        }
        return this.list((Wrapper)areagroupQueryWrapper);
    }

    @Override
    public AreagroupEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(AreagroupEntity::getId, (Object)id);
        return (AreagroupEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    @DSTransactional
    public void create(AreagroupCrForm areagroupCrForm) {
        String mainId = RandomUtil.uuId();
        AreagroupEntity entity = (AreagroupEntity)JsonUtil.getJsonToBean((Object)areagroupCrForm, AreagroupEntity.class);
        entity.setId(mainId);
        this.save(entity);
    }

    @Override
    @DSTransactional
    public void update(String id, AreagroupUpForm areagroupUpForm) {
        UserInfo userInfo = this.userProvider.get();
        AreagroupEntity entity = this.getInfo(id);
        if (entity != null) {
            AreagroupEntity subentity = (AreagroupEntity)JsonUtil.getJsonToBean((Object)areagroupUpForm, AreagroupEntity.class);
            this.updateById(subentity);
        }
    }

    @Override
    public List<AreagroupEntity> getProList(List<String> ProIdList) {
        if (ProIdList.size() > 0) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.lambda().select(new SFunction[]{AreagroupEntity::getId, AreagroupEntity::getFullName}).in(AreagroupEntity::getId, ProIdList);
            return this.list((Wrapper)queryWrapper);
        }
        return new ArrayList<AreagroupEntity>();
    }

    @Override
    public List<String> getAreaIdsByCompanyId(String companyId, String modelId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (!this.userProvider.get().getIsAdministrator().booleanValue()) {
            Object crmCustomerVerifyObj = this.authorizeService.getCondition(new AuthorizeConditionModel(queryWrapper, modelId, "base_province_group"));
            if (ObjectUtil.isEmpty((Object)crmCustomerVerifyObj)) {
                return new ArrayList<String>();
            }
            queryWrapper = (QueryWrapper)crmCustomerVerifyObj;
        }
        List areagroupList = this.list((Wrapper)queryWrapper);
        ArrayList<String> returnIds = new ArrayList<String>();
        if (ObjectUtil.isNotEmpty((Object)areagroupList)) {
            List<ArearelationEntity> listByObjects = this.arearelationService.getListByObjects(areagroupList.stream().map(AreagroupEntity::getId).collect(Collectors.toList()));
            List<String> areaIds = listByObjects.stream().map(ArearelationEntity::getProvinceId).collect(Collectors.toList());
            areaIds.forEach(id -> {
                List jsonToList = JsonUtil.getJsonToList((String)id, String.class);
                returnIds.add((String)jsonToList.get(jsonToList.size() - 1));
            });
        }
        return returnIds;
    }

    @Override
    public List<AreagroupEntity> getListByCompanyType(String companyId, String type) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (ObjectUtil.isNotEmpty((Object)companyId)) {
            queryWrapper.lambda().in(AreagroupEntity::getCompanyId, (Object[])companyId.split(","));
        }
        if (ObjectUtil.isNotEmpty((Object)type)) {
            queryWrapper.lambda().eq(AreagroupEntity::getType, (Object)type);
        }
        List areagroupEntityList = this.list((Wrapper)queryWrapper);
        return areagroupEntityList;
    }

    @Override
    public List<List<String>> areaGroupToArea(List<List<String>> address) {
        ArrayList<List<String>> returnAddress = new ArrayList<List<String>>();
        address.forEach(area -> {
            if (area.size() > 1) {
                String province = (String)area.get(1);
                ProvinceEntity info = this.provinceService.getInfo(province);
                if (ObjectUtil.isNotEmpty((Object)info)) {
                    area.set(0, info.getParentId());
                }
                returnAddress.add((List<String>)area);
            }
            if (area.size() == 1) {
                List<ArearelationEntity> listByObjects = this.arearelationService.getListByObjects((List<String>)area);
                if (ObjectUtil.isNotEmpty(listByObjects)) {
                    listByObjects.forEach(v -> {
                        List jsonToList = JsonUtil.getJsonToList((String)v.getProvinceId(), String.class);
                        returnAddress.add(jsonToList);
                    });
                } else {
                    returnAddress.add((List<String>)area);
                }
            }
        });
        return returnAddress;
    }

    @Override
    @DSTransactional
    public void delete(AreagroupEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }
}

