/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.msgcenter.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.DeleteMarkEnum;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.system.msgcenter.entity.McMsgAccountEntity;
import com.bringspring.system.msgcenter.exception.MsgCenterException;
import com.bringspring.system.msgcenter.mapper.McMsgAccountMapper;
import com.bringspring.system.msgcenter.model.mcmsgaccount.McMsgAccountCrForm;
import com.bringspring.system.msgcenter.model.mcmsgaccount.McMsgAccountPagination;
import com.bringspring.system.msgcenter.model.mcmsgaccount.McMsgAccountUpForm;
import com.bringspring.system.msgcenter.service.McMsgAccountService;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class McMsgAccountServiceImpl
extends ServiceImpl<McMsgAccountMapper, McMsgAccountEntity>
implements McMsgAccountService {
    @Autowired
    private UserProvider userProvider;

    @Override
    public List<McMsgAccountEntity> getList(McMsgAccountPagination pagination) {
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int mcMsgAccountNum = 0;
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((String)pagination.getCategory())) {
            ++mcMsgAccountNum;
            queryWrapper.lambda().eq(McMsgAccountEntity::getCategory, (Object)pagination.getCategory());
        }
        if (ObjectUtil.isNotEmpty((Object)pagination.getEnabledMark())) {
            ++mcMsgAccountNum;
            queryWrapper.lambda().eq(McMsgAccountEntity::getEnabledMark, (Object)pagination.getEnabledMark());
        }
        if (StringUtils.isNotEmpty((String)pagination.getKeyword())) {
            ++mcMsgAccountNum;
            ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().like(McMsgAccountEntity::getFullName, (Object)pagination.getKeyword())).or()).like(McMsgAccountEntity::getEnCode, (Object)pagination.getKeyword());
        }
        if (StringUtils.isNotEmpty((String)pagination.getFullName())) {
            ++mcMsgAccountNum;
            queryWrapper.lambda().like(McMsgAccountEntity::getFullName, (Object)pagination.getFullName());
        }
        if (StringUtils.isNotEmpty((String)pagination.getEnCode())) {
            ++mcMsgAccountNum;
            queryWrapper.lambda().like(McMsgAccountEntity::getEnCode, (Object)pagination.getEnCode());
        }
        if (AllIdList.size() > 0) {
            queryWrapper.lambda().in(McMsgAccountEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)pagination.getSidx())) {
            queryWrapper.lambda().orderByDesc(McMsgAccountEntity::getCreatorTime);
        } else {
            try {
                String sidx = pagination.getSidx();
                McMsgAccountEntity mcMsgAccountEntity = new McMsgAccountEntity();
                Field declaredField = mcMsgAccountEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                queryWrapper = "asc".equals(pagination.getSort().toLowerCase()) ? (QueryWrapper)queryWrapper.orderByAsc((Object)value) : (QueryWrapper)queryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(pagination.getCurrentPage(), pagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)queryWrapper);
            return pagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list = new ArrayList();
        return pagination.setData(list, list.size());
    }

    @Override
    public List<McMsgAccountEntity> getTypeList(McMsgAccountPagination pagination, String dataType) {
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int mcMsgAccountNum = 0;
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((String)pagination.getFullName())) {
            ++mcMsgAccountNum;
            queryWrapper.lambda().like(McMsgAccountEntity::getFullName, (Object)pagination.getFullName());
        }
        if (StringUtils.isNotEmpty((String)pagination.getEnCode())) {
            ++mcMsgAccountNum;
            queryWrapper.lambda().like(McMsgAccountEntity::getEnCode, (Object)pagination.getEnCode());
        }
        if (AllIdList.size() > 0) {
            queryWrapper.lambda().in(McMsgAccountEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)pagination.getSidx())) {
            queryWrapper.lambda().orderByDesc(McMsgAccountEntity::getCreatorTime);
        } else {
            try {
                String sidx = pagination.getSidx();
                McMsgAccountEntity mcMsgAccountEntity = new McMsgAccountEntity();
                Field declaredField = mcMsgAccountEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                queryWrapper = "asc".equals(pagination.getSort().toLowerCase()) ? (QueryWrapper)queryWrapper.orderByAsc((Object)value) : (QueryWrapper)queryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ("0".equals(dataType)) {
            if (total > 0 && AllIdList.size() > 0 || total == 0) {
                Page page = new Page(pagination.getCurrentPage(), pagination.getPageSize());
                IPage userIPage = this.page((IPage)page, (Wrapper)queryWrapper);
                return pagination.setData(userIPage.getRecords(), userIPage.getTotal());
            }
            ArrayList list = new ArrayList();
            return pagination.setData(list, list.size());
        }
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<McMsgAccountEntity> getAccountByCategory(String category) {
        if (StringUtils.isEmpty((String)category)) {
            throw new MsgCenterException("\u8d26\u53f7\u5206\u7c7b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(McMsgAccountEntity::getCategory, (Object)category);
        queryWrapper.lambda().eq(McMsgAccountEntity::getEnabledMark, (Object)1);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public McMsgAccountEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(McMsgAccountEntity::getId, (Object)id);
        return (McMsgAccountEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void create(McMsgAccountCrForm mcMsgAccountCrForm) {
        McMsgAccountEntity entity = (McMsgAccountEntity)JsonUtil.getJsonToBean((Object)mcMsgAccountCrForm, McMsgAccountEntity.class);
        String mainId = RandomUtil.uuId();
        entity.setId(mainId);
        entity.setDeleteMark(DeleteMarkEnum.NOT_DELETE.getCode());
        this.save(entity);
    }

    @Override
    public boolean update(String id, McMsgAccountUpForm mcMsgAccountUpForm) {
        McMsgAccountEntity entity = (McMsgAccountEntity)JsonUtil.getJsonToBean((Object)mcMsgAccountUpForm, McMsgAccountEntity.class);
        entity.setId(id);
        entity.setDeleteMark(DeleteMarkEnum.NOT_DELETE.getCode());
        return this.updateById(entity);
    }

    @Override
    public void delete(McMsgAccountEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }

    @Override
    public boolean checkEnCodeUnique(String enCode, String id) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(McMsgAccountEntity::getEnCode, (Object)enCode);
        queryWrapper.last("limit 1");
        McMsgAccountEntity entity = (McMsgAccountEntity)this.getOne((Wrapper)queryWrapper);
        return !ObjectUtil.isNotNull((Object)entity) || !StringUtils.isEmpty((String)id) && entity.getId().equals(id);
    }

    @Override
    public boolean checkFullNameUnique(String fullName, String id) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(McMsgAccountEntity::getFullName, (Object)fullName);
        queryWrapper.last("limit 1");
        McMsgAccountEntity entity = (McMsgAccountEntity)this.getOne((Wrapper)queryWrapper);
        return !ObjectUtil.isNotNull((Object)entity) || !StringUtils.isEmpty((String)id) && entity.getId().equals(id);
    }
}

