/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.msgcenter.service.strategy.impl;

import cn.hutool.core.util.ObjectUtil;
import com.bringspring.system.message.entity.SynThirdInfoEntity;
import com.bringspring.system.msgcenter.entity.McMsgAccountEntity;
import com.bringspring.system.msgcenter.entity.McMsgTemplateEntity;
import com.bringspring.system.msgcenter.entity.McTaskMsgContentEntity;
import com.bringspring.system.msgcenter.entity.McTaskMsgEntity;
import com.bringspring.system.msgcenter.entity.McTaskMsgReceiveEntity;
import com.bringspring.system.msgcenter.enums.ChannelTypeEnum;
import com.bringspring.system.msgcenter.model.mcmsgsendtemplate.McMsgSendTemplateModel;
import com.bringspring.system.msgcenter.service.McMsgTemplateService;
import com.bringspring.system.msgcenter.service.strategy.AbstractMessageChannelStrategy;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.service.UserService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WxMediaPlatformStrategy
extends AbstractMessageChannelStrategy {
    @Autowired
    private McMsgTemplateService mcMsgTemplateService;
    @Autowired
    private UserService userService;

    @Override
    public ChannelTypeEnum getChannelType() {
        return ChannelTypeEnum.WX_MP;
    }

    @Override
    public void processMessage(McTaskMsgEntity taskMsg, McMsgSendTemplateModel sendTemplate, Map<String, McTaskMsgContentEntity> contentMap, Map<String, List<McTaskMsgReceiveEntity>> receiveMap, Set<String> userSet) {
        McTaskMsgContentEntity mpContent;
        String taskMsgId = taskMsg.getId();
        String templateId = sendTemplate.getId();
        String channelType = sendTemplate.getMessageType();
        String msgTemplateId = sendTemplate.getTemplateId();
        String msgAccountId = sendTemplate.getAccountConfigId();
        McMsgAccountEntity account = this.mcMsgAccountService.getInfo(sendTemplate.getAccountConfigId());
        McMsgTemplateEntity msgTemplate = this.mcMsgTemplateService.getInfo(sendTemplate.getTemplateId());
        String mpContentKey = channelType + msgTemplateId + msgAccountId;
        String mpReceiveKey = channelType + msgTemplateId;
        if (!contentMap.containsKey(mpContentKey)) {
            mpContent = this.getTaskMsgContentKey(templateId, channelType, taskMsg, msgTemplate, account);
            contentMap.put(mpContentKey, mpContent);
        } else {
            mpContent = contentMap.get(mpContentKey);
        }
        if ("4".equals(taskMsg.getToType())) {
            if (!receiveMap.containsKey(mpContentKey)) {
                List<McTaskMsgReceiveEntity> mpReceiveList = this.packNonSystemReceive(userSet, taskMsgId, templateId, channelType, msgTemplateId, msgAccountId, mpContent.getId());
                receiveMap.put(mpContentKey, mpReceiveList);
            }
        } else {
            List<UserEntity> receiveUsers = this.userService.getUserByIds(new ArrayList<String>(userSet));
            String mpCrop = ObjectUtil.isEmpty((Object)account) ? null : account.getAppId();
            List<SynThirdInfoEntity> mpThirdList = this.synThirdInfoService.getThirdInfoList("7", "2", mpCrop, userSet);
            List<McTaskMsgReceiveEntity> receiveList = null;
            if (receiveMap.containsKey(mpReceiveKey)) {
                receiveList = receiveMap.get(mpReceiveKey);
            }
            List<McTaskMsgReceiveEntity> mpReceiveList = this.packThirdReceive(receiveUsers, mpThirdList, taskMsgId, templateId, channelType, msgTemplateId, msgAccountId, mpContent.getId(), receiveList);
            receiveMap.put(mpReceiveKey, mpReceiveList);
        }
    }
}

