/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.msgcenter.util;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.TimeInterval;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.system.base.entity.SysConfigEntity;
import com.bringspring.system.base.exception.BaseException;
import com.bringspring.system.base.service.SysConfigService;
import com.bringspring.system.msgcenter.entity.McTaskMsgReceiveEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.stereotype.Component;

@Component
public class BlacklistUtil
implements ApplicationRunner {
    private static final Logger log = LoggerFactory.getLogger(BlacklistUtil.class);
    @Autowired
    private SysConfigService sysConfigService;
    @Autowired
    private Executor threadPoolExecutor;
    private static List<String> blacklist = new ArrayList<String>();

    public void run(ApplicationArguments args) {
        HashSet<String> blacklistConfig = new HashSet<String>();
        try {
            String keyValue;
            SysConfigEntity mcBlacklist = this.sysConfigService.getConfigByKeyName("mcBlacklist");
            if (ObjectUtil.isNotEmpty((Object)mcBlacklist) && StringUtils.isNotEmpty((String)(keyValue = mcBlacklist.getKeyValue()))) {
                JSONArray objects = JSONArray.parseArray((String)keyValue);
                objects.stream().forEach(s -> blacklistConfig.add(s.toString().trim()));
            }
        }
        catch (JSONException | BaseException e) {
            e.printStackTrace();
        }
        this.init(blacklistConfig, true);
        log.info("\u6d88\u606f\u4e2d\u5fc3-\u521d\u59cb\u5316\u9ed1\u540d\u5355\u7528\u6237\u5b8c\u6bd5, \u5171" + blacklistConfig.size() + "\u4e2a\u7528\u6237");
    }

    public void init(Collection<String> blacklistConfig, boolean isAsync) {
        if (isAsync) {
            this.threadPoolExecutor.execute(() -> this.init(blacklistConfig));
        } else {
            this.init(blacklistConfig);
        }
    }

    public void init(Collection<String> blacklistConfig) {
        blacklist.clear();
        blacklist.addAll(blacklistConfig);
    }

    public static List<McTaskMsgReceiveEntity> receiveListFilter(List<McTaskMsgReceiveEntity> receiveList) {
        if (CollectionUtil.isEmpty(receiveList)) {
            return receiveList;
        }
        TimeInterval timer = DateUtil.timer();
        List<McTaskMsgReceiveEntity> receiveBlacklist = receiveList.stream().filter(r -> blacklist.contains(r.getSysUserId())).collect(Collectors.toList());
        receiveList.removeIf(r -> receiveBlacklist.contains(r));
        log.info("\u8fc7\u6ee4\u9ed1\u540d\u5355, \u8017\u65f6: " + timer.intervalMs() + "ms");
        return receiveBlacklist;
    }
}

