/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.msgcenter.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bringspring.common.util.DateUtil;
import com.google.common.collect.Maps;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebHookUtil {
    private static Logger logger = LoggerFactory.getLogger(WebHookUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONObject doPostForJson(String url, String jsonParams) {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        JSONObject jsonObject = null;
        HttpPost httpPost = new HttpPost(url);
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(180000).setConnectionRequestTimeout(180000).setSocketTimeout(180000).setRedirectsEnabled(true).build();
        httpPost.setConfig(requestConfig);
        httpPost.setHeader("Content-Type", "application/json");
        try {
            httpPost.setEntity((HttpEntity)new StringEntity(jsonParams, ContentType.create((String)"application/json", (String)"utf-8")));
            System.out.println("request parameters" + EntityUtils.toString((HttpEntity)httpPost.getEntity()));
            System.out.println("httpPost:" + httpPost);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            if (response != null) {
                if (response.getStatusLine().getStatusCode() == 200) {
                    String result = EntityUtils.toString((HttpEntity)response.getEntity());
                    System.out.println("result:" + result);
                    JSONObject jSONObject = jsonObject = JSONObject.parseObject((String)result);
                    return jSONObject;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (null != httpClient) {
                try {
                    httpClient.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            return jsonObject;
        }
    }

    public static void sendMsgBasic(String url, List<String> msgList, String userName, String password) {
        String content = userName + ":" + password;
        String token = "Basic " + Base64.getEncoder().encodeToString(content.getBytes(StandardCharsets.UTF_8));
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("msg_type", "text");
        HashMap<String, String> contentMap = new HashMap<String, String>();
        params.put("content", contentMap);
        StringBuilder stringBuilder = new StringBuilder();
        msgList.forEach(e -> stringBuilder.append(e + "\n"));
        contentMap.put("text", stringBuilder.toString());
        WebHookUtil.doPostForJsonObject(url, JSON.toJSONString(params), token);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONObject doPostForJsonObject(String url, String jsonParams, String token) {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        JSONObject jsonObject = null;
        HttpPost httpPost = new HttpPost(url);
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(180000).setConnectionRequestTimeout(180000).setSocketTimeout(180000).setRedirectsEnabled(true).build();
        httpPost.setConfig(requestConfig);
        httpPost.setHeader("Content-Type", "application/json");
        httpPost.setHeader("Authorization", token);
        try {
            httpPost.setEntity((HttpEntity)new StringEntity(jsonParams, ContentType.create((String)"application/json", (String)"utf-8")));
            System.out.println("request parameters" + EntityUtils.toString((HttpEntity)httpPost.getEntity()));
            System.out.println("httpPost:" + httpPost);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            if (response != null) {
                if (response.getStatusLine().getStatusCode() == 200) {
                    String result = EntityUtils.toString((HttpEntity)response.getEntity());
                    System.out.println("result:" + result);
                    JSONObject jSONObject = jsonObject = JSONObject.parseObject((String)result);
                    return jSONObject;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (null != httpClient) {
                try {
                    httpClient.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            return jsonObject;
        }
    }

    private static String GenSign(String secret, Long timestamp) throws NoSuchAlgorithmException, InvalidKeyException {
        String stringToSign = timestamp + "\n" + secret;
        Mac mac = Mac.getInstance("HmacSHA256");
        mac.init(new SecretKeySpec(secret.getBytes(StandardCharsets.UTF_8), "HmacSHA256"));
        byte[] signData = mac.doFinal(stringToSign.getBytes(StandardCharsets.UTF_8));
        return new String(Base64.getEncoder().encode(signData));
    }

    public static void sendMsg(String url, List<String> msgList, String Secret) throws NoSuchAlgorithmException, InvalidKeyException {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        Long timestamp = DateUtil.getTime((Date)DateUtil.getNowDate());
        String sign = WebHookUtil.GenSign(Secret, timestamp);
        params.put("msg_type", "text");
        params.put("timestamp", timestamp);
        params.put("sign", sign);
        HashMap<String, String> contentMap = new HashMap<String, String>();
        params.put("content", contentMap);
        StringBuilder stringBuilder = new StringBuilder();
        msgList.forEach(e -> stringBuilder.append(e + "\n"));
        contentMap.put("text", stringBuilder.toString());
        WebHookUtil.doPostForJson(url, JSON.toJSONString(params));
    }

    public static void sendMsgNoSecret(String url, List<String> msgList) {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("msg_type", "text");
        HashMap<String, String> contentMap = new HashMap<String, String>();
        params.put("content", contentMap);
        StringBuilder stringBuilder = new StringBuilder();
        msgList.forEach(e -> stringBuilder.append(e + "\n"));
        contentMap.put("text", stringBuilder.toString());
        WebHookUtil.doPostForJson(url, JSON.toJSONString(params));
    }

    public static String sendPostByMap(String url, Map<String, Object> mapParam) {
        HashMap<String, String> headParam = new HashMap<String, String>();
        headParam.put("Content-type", "application/json;charset=UTF-8");
        return WebHookUtil.sendPost(url, mapParam, headParam);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sendPost(String url, Map<String, Object> param, Map<String, String> headParam) {
        PrintWriter out = null;
        BufferedReader in = null;
        String result = "";
        try {
            String line;
            URL realUrl = new URL(url);
            URLConnection conn = realUrl.openConnection();
            conn.setRequestProperty("accept", "*/*");
            conn.setRequestProperty("connection", "Keep-Alive");
            conn.setRequestProperty("user-agent", "Fiddler");
            if (headParam != null) {
                for (Map.Entry<String, String> entry : headParam.entrySet()) {
                    conn.setRequestProperty(entry.getKey(), entry.getValue());
                }
            }
            conn.setDoOutput(true);
            conn.setDoInput(true);
            out = new PrintWriter(conn.getOutputStream());
            out.print(JSON.toJSONString(param));
            out.flush();
            in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            while ((line = in.readLine()) != null) {
                result = result + line;
            }
        }
        catch (Exception e) {
            logger.info("\u53d1\u9001 POST \u8bf7\u6c42\u51fa\u73b0\u5f02\u5e38\uff01" + e);
            e.printStackTrace();
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return result;
    }

    public static String sendTextMsg(String msg) {
        JSONObject text = new JSONObject();
        text.put("content", (Object)msg);
        JSONObject reqBody = new JSONObject();
        reqBody.put("msgtype", (Object)"text");
        reqBody.put("text", (Object)text);
        reqBody.put("safe", (Object)0);
        return reqBody.toString();
    }

    public static JSONObject callWeChatBot(String url, String content) {
        OkHttpClient client = new OkHttpClient().newBuilder().build();
        MediaType mediaType = MediaType.parse((String)"application/json");
        content = WebHookUtil.sendTextMsg(content);
        RequestBody body = RequestBody.create((String)content, (MediaType)mediaType);
        Request request = new Request.Builder().url(url).method("POST", body).addHeader("Content-Type", "application/json").build();
        Response response = null;
        String result = "";
        try {
            String line;
            response = client.newCall(request).execute();
            BufferedReader in = new BufferedReader(new InputStreamReader(response.body().byteStream()));
            while ((line = in.readLine()) != null) {
                result = result + line;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return JSONObject.parseObject((String)result);
    }

    public static JSONObject sendDDMessage(String url, String msg) {
        HashMap<String, Object> json = new HashMap<String, Object>();
        HashMap<String, String> text = new HashMap<String, String>();
        json.put("msgtype", "text");
        text.put("content", msg);
        json.put("text", text);
        String response = WebHookUtil.sendPostByMap(url, json);
        return JSONObject.parseObject((String)response);
    }

    public static JSONObject sendDingDing(String url, String Secret, String content) {
        try {
            Long timestamp = System.currentTimeMillis();
            String sign = WebHookUtil.GenSign(Secret, timestamp);
            String stringToSign = timestamp + "\n" + Secret;
            String dingUrl = url + "&timestamp=" + timestamp + "&sign=" + URLEncoder.encode(sign, "UTF-8");
            boolean isAtAll = true;
            HashMap contentMap = Maps.newHashMap();
            contentMap.put("content", content);
            HashMap atMap = Maps.newHashMap();
            atMap.put("isAtAll", isAtAll);
            HashMap reqMap = Maps.newHashMap();
            reqMap.put("msgtype", "text");
            reqMap.put("text", contentMap);
            reqMap.put("at", atMap);
            String result = WebHookUtil.sendPostByMap(dingUrl, reqMap);
            return JSONObject.parseObject((String)result);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

