package com.bringspring.system.base.controller;

import cn.dev33.satoken.annotation.SaCheckPermission;
import cn.dev33.satoken.annotation.SaMode;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.Pagination;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.system.base.model.online.BatchOnlineModel;
import com.bringspring.system.base.service.UserOnlineService;
import com.bringspring.system.message.model.UserOnlineModel;
import com.bringspring.system.message.model.UserOnlineVO;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.stream.Collectors;

/**
 * 在线用户
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2017年9月26日 上午9:18
 */
@Tag(name = "在线用户")
@RestController
@RequestMapping("/api/system/OnlineUser")
public class UserOnlineController {

    @Autowired
    private UserOnlineService userOnlineService;

    /**
     * 列表
     *
     * @param page 分页参数
     * @return ignore
     */
    @Operation(summary = "获取在线用户列表")
    @SaCheckPermission(value = {"permission.userOnline", "monitor.userOnline"}, mode = SaMode.OR)
    @GetMapping
    public ActionResult<PageListVO<UserOnlineVO>> list(Pagination page) {
        List<UserOnlineModel> data = userOnlineService.getList(page);
        List<UserOnlineVO> voList = data.stream().map(online -> {
            UserOnlineVO vo = JsonUtil.getJsonToBean(online, UserOnlineVO.class);
            vo.setUserId(online.getToken());
            //vo.setUserName(vo.getUserName() + "/" + online.getDevice());
            return vo;
        }).collect(Collectors.toList());
        PaginationVO paginationVO = JsonUtil.getJsonToBean(page, PaginationVO.class);
        return ActionResult.page(voList, paginationVO);
    }

    /**
     * 注销
     *
     * @param token 主键值
     * @return
     */
    @Operation(summary = "强制下线")
    @Parameter(name = "token", description = "token", required = true)
    @SaCheckPermission("permission.userOnline")
    @DeleteMapping("/{token}")
    public ActionResult delete(@PathVariable("token") String token) {
        userOnlineService.delete(token);
        return ActionResult.success(MsgCode.SU005.get());
    }

    /**
     * 批量下线用户
     *
     * @param model 主键值
     * @return ignore
     */
    @Operation(summary = "批量下线用户")
    @Parameter(name = "model", description = "在线用户id集合", required = true)
    @SaCheckPermission("permission.userOnline")
    @DeleteMapping
    public ActionResult clear(@RequestBody BatchOnlineModel model) {
        userOnlineService.delete(model.getIds());
        return ActionResult.success(MsgCode.SU005.get());
    }
//    /**
//     * 列表
//     *
//     * @param page 分页参数
//     * @return ignore
//     */
//    @Operation(summary="获取在线用户列表")
//    @GetMapping
//    public ActionResult list(Page page) {
//        List<UserOnlineModel> data = userOnlineService.getList(page);
//        List<UserOnlineVO> vo = JsonUtil.getJsonToList(data, UserOnlineVO.class);
//        return ActionResult.success(vo);
//    }
//
//    /**
//     * 注销
//     *
//     * @param id 主键值
//     * @return ignore
//     */
//    @Operation(summary="强制下线")
//    @DeleteMapping("/{id}")
//    public ActionResult delete(@PathVariable("id") String id) {
//        userOnlineService.delete(id);
//        return ActionResult.success(MsgCode.SU005.get());
//    }
//
//
//    /**
//     * 批量下线用户
//     *
//     * @param model 主键值
//     * @return ignore
//     */
//    @Operation(summary="批量下线用户")
//    @DeleteMapping
//    public ActionResult clear(@RequestBody BatchOnlineModel model) {
//        for (String id : model.getIds()) {
//            userOnlineService.delete(id);
//        }
//        return ActionResult.success(MsgCode.SU005.get());
//    }
}
