package com.bringspring.system.base.model.baseSyncThirdInfo;


import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.util.Date;

/**
 * @版本： V1.0.0
 * @版权： 荣科科技股份有限公司
 * @作者： RKKJ开发平台组
 * @日期： 2024-08-19
 */
@Data
public class BaseSyncThirdInfoListVO {

    /**
     * 主键
     */
    private String id;


    /**
     * 企业微信id
     **/
    @JsonProperty("cropId")
    private String cropId;


    /**
     * 第三方类型
     **/
    @JsonProperty("thirdType")
    private String thirdType;


    /**
     * 数据类型
     **/
    @JsonProperty("dataType")
    private String dataType;


    /**
     * 系统对象ID
     **/
    @JsonProperty("systemObjectId")
    private String systemObjectId;


    /**
     * 第三对象ID
     **/
    @JsonProperty("thirdObjectId")
    private String thirdObjectId;


    /**
     * 同步状态
     **/
    @JsonProperty("synState")
    private String synState;


    /**
     * 备注
     **/
    @JsonProperty("description")
    private String description;


    /**
     * 创建时间
     **/
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @JsonProperty("creatorTime")
    private Date creatorTime;


    /**
     * 创建人
     **/
    @JsonProperty("creatorUserId")
    private String creatorUserId;


    /**
     * 修改时间
     **/
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @JsonProperty("lastModifyTime")
    private Date lastModifyTime;


    /**
     * 修改人
     **/
    @JsonProperty("lastModifyUserId")
    private String lastModifyUserId;


}