package com.bringspring.system.base.service.impl;


import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.auth.util.UserProvider;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.*;
import com.bringspring.common.util.context.SpringContext;
import com.bringspring.common.util.enums.ModuleTypeEnum;
import com.bringspring.common.util.file.FileExport;
import com.bringspring.system.base.entity.*;
import com.bringspring.system.base.mapper.ModuleMapper;
import com.bringspring.system.base.model.module.ModuleExportModel;
import com.bringspring.system.base.service.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import static com.bringspring.common.base.EnabledMarkEnum.ENABLE;

/**
 * 系统功能
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2017年9月27日 上午9:18
 */
@Service
public class ModuleServiceImpl extends ServiceImpl<ModuleMapper, ModuleEntity> implements ModuleService {

    @Autowired
    private UserProvider userProvider;
    @Autowired
    private ModuleButtonService moduleButtonService;
    @Autowired
    private ModuleColumnService moduleColumnService;
    @Autowired
    private ModuleDataAuthorizeService moduleDataAuthorizeService;
    @Autowired
    private ModuleButtonService buttonService;
    @Autowired
    private ModuleColumnService columnService;
    @Autowired
    private ModuleFormService formService;
    @Autowired
    private ModuleDataAuthorizeSchemeService schemeService;
    @Autowired
    private ModuleDataAuthorizeService authorizeService;
    @Autowired
    private FileExport fileExport;
    @Autowired
    private ConfigValueUtil configValueUtil;

    @Override
    @Cacheable(value = "ModuleCache", keyGenerator = "cacheKeyGenerator", unless = "#result.size()==0")
    public List<ModuleEntity> getList() {
        QueryWrapper<ModuleEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda().orderByAsc(ModuleEntity::getSortCode).orderByDesc(ModuleEntity::getCreatorTime);
        return this.list(queryWrapper);
    }

    @Override
    @Cacheable(value = "ModuleCache", keyGenerator = "cacheKeyGenerator", unless = "#result.size()==0")
    public List<ModuleEntity> getList(String category, String keyword, String type, String enabledMark, String parentId) {
        return getList(category, keyword, type, enabledMark, parentId, "");
    }

    @Override
    @Cacheable(value = "ModuleCache", keyGenerator = "cacheKeyGenerator", unless = "#result.size()==0")
    public List<ModuleEntity> getList(String category, String keyword, String type, String enabledMark, String parentId, String enCode) {
        // 定义变量判断是否需要使用修改时间倒序
        boolean flag = false;
        QueryWrapper<ModuleEntity> queryWrapper = new QueryWrapper<>();
        if (!StringUtils.isEmpty(category)) {
            flag = true;
            queryWrapper.lambda().eq(ModuleEntity::getCategory, category);
        }
        if (!StringUtils.isEmpty(keyword)) {
            flag = true;
            queryWrapper.lambda().and(t -> t.like(ModuleEntity::getFullName, keyword));
        }
        if (StringUtils.isNotEmpty(type)) {
            flag = true;
            queryWrapper.lambda().eq(ModuleEntity::getType, Integer.valueOf(type));
        }
        if (StringUtils.isNotEmpty(enabledMark)) {
            flag = true;
            queryWrapper.lambda().eq(ModuleEntity::getEnabledMark, Integer.valueOf(enabledMark));
        }
        if (StringUtils.isNotEmpty(parentId)) {
            flag = true;
            queryWrapper.lambda().and(t -> t.eq(ModuleEntity::getParentId, parentId).or().like(ModuleEntity::getParentIds, parentId));
        }
        if (StringUtils.isNotEmpty(enCode)) {
            flag = true;
            queryWrapper.lambda().eq(ModuleEntity::getEnCode, enCode);
        }
        queryWrapper.lambda().orderByAsc(ModuleEntity::getSortCode).orderByDesc(ModuleEntity::getCreatorTime);
        if (flag) {
            queryWrapper.lambda().orderByDesc(ModuleEntity::getLastModifyTime);
        }
        return this.list(queryWrapper);
    }

    @Override
    @Cacheable(value = "ModuleCache", keyGenerator = "cacheKeyGenerator", unless = "#result.size()==0")
    public List<ModuleEntity> getList(String id) {
        QueryWrapper<ModuleEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda().eq(ModuleEntity::getParentId, id);
        queryWrapper.lambda().orderByAsc(ModuleEntity::getSortCode).orderByDesc(ModuleEntity::getCreatorTime);
        return this.list(queryWrapper);
    }

    @Override
    @Cacheable(value = "ModuleCache", keyGenerator = "cacheKeyGenerator", unless = "#result==null")
    public ModuleEntity getInfo(String id) {
        QueryWrapper<ModuleEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda().eq(ModuleEntity::getId, id);
        return this.getOne(queryWrapper);
    }

    @Override
    @Cacheable(value = "ModuleCache", keyGenerator = "cacheKeyGenerator", unless = "#result==null")
    public ModuleEntity getByEnCode(String enCode) {
        if (StringUtils.isEmpty(enCode)) {
            return null;
        }
        QueryWrapper<ModuleEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda().eq(ModuleEntity::getEnCode, enCode);
        queryWrapper.lambda().eq(ModuleEntity::getEnabledMark, ENABLE.getCode());
        List<ModuleEntity> list = this.list(queryWrapper);
        if (CollectionUtil.isNotEmpty(list)) {
            return list.get(0);
        }
        return null;
    }

    @Override
    @Cacheable(value = "ModuleCache", keyGenerator = "cacheKeyGenerator", unless = "#result==null")
    public boolean isExistByFullName(ModuleEntity entity, String category) {
        QueryWrapper<ModuleEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda().eq(ModuleEntity::getFullName, entity.getFullName()).eq(ModuleEntity::getCategory, category);
        if (!StringUtils.isEmpty(entity.getId())) {
            queryWrapper.lambda().ne(ModuleEntity::getId, entity.getId());
        }
        List<ModuleEntity> entityList = this.list(queryWrapper);
        if (entityList.size() > 0) {
            for (ModuleEntity moduleEntity : entityList) {
                if (moduleEntity.getParentId().equals(entity.getParentId())) {
                    return true;
                }
            }
            return false;
        }
        return this.count(queryWrapper) > 0 ? true : false;
    }

    @Override
    @Cacheable(value = "ModuleCache", keyGenerator = "cacheKeyGenerator", unless = "#result==null")
    public boolean isExistByEnCode(ModuleEntity entity, String category) {
        QueryWrapper<ModuleEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda().eq(ModuleEntity::getEnCode, entity.getEnCode()).eq(ModuleEntity::getCategory, category);
        if (!StringUtils.isEmpty(entity.getId())) {
            queryWrapper.lambda().ne(ModuleEntity::getId, entity.getId());
            List<ModuleEntity> entityList = this.list(queryWrapper);
            if (entityList.size() > 0) {
                for (ModuleEntity moduleEntity : entityList) {
                    if (moduleEntity.getParentId().equals(entity.getParentId())) {
                        return true;
                    }
                }
            } else {
                return false;
            }
        }
        return this.count(queryWrapper) > 0 ? true : false;
    }

    @DSTransactional
    @Override
    @CacheEvict(value = "ModuleCache", allEntries = true)
    public void delete(ModuleEntity entity) {
        this.removeById(entity.getId());
        QueryWrapper<ModuleButtonEntity> buttonWrapper = new QueryWrapper<>();
        buttonWrapper.lambda().eq(ModuleButtonEntity::getModuleId, entity.getId());
        moduleButtonService.remove(buttonWrapper);
        QueryWrapper<ModuleColumnEntity> columnWrapper = new QueryWrapper<>();
        columnWrapper.lambda().eq(ModuleColumnEntity::getModuleId, entity.getId());
        moduleColumnService.remove(columnWrapper);
        QueryWrapper<ModuleDataAuthorizeEntity> dataWrapper = new QueryWrapper<>();
        dataWrapper.lambda().eq(ModuleDataAuthorizeEntity::getModuleId, entity.getId());
        moduleDataAuthorizeService.remove(dataWrapper);
        Object service = SpringContext.getBean("appDataServiceImpl");
        Class[] types = new Class[]{String.class};
        Object[] datas = new Object[]{entity.getId()};
        ReflectionUtil.invokeMethod(service, "delete", types, datas);
    }

    @DSTransactional
    @Override
    @CacheEvict(value = "ModuleCache", allEntries = true)
    public void deleteModule(ModuleEntity entity) {
        QueryWrapper<ModuleButtonEntity> buttonWrapper = new QueryWrapper<>();
        buttonWrapper.lambda().eq(ModuleButtonEntity::getModuleId, entity.getId());
        moduleButtonService.remove(buttonWrapper);
        QueryWrapper<ModuleColumnEntity> columnWrapper = new QueryWrapper<>();
        columnWrapper.lambda().eq(ModuleColumnEntity::getModuleId, entity.getId());
        moduleColumnService.remove(columnWrapper);
        QueryWrapper<ModuleFormEntity> formWrapper = new QueryWrapper<>();
        formWrapper.lambda().eq(ModuleFormEntity::getModuleId, entity.getId());
        formService.remove(formWrapper);
    }

    @DSTransactional
    @Override
    @CacheEvict(value = "ModuleCache", allEntries = true)
    public void create(ModuleEntity entity) {
        boolean flag = false;
        if (entity.getId() == null) {
            entity.setId(RandomUtil.uuId());
            flag = true;
        }

        String parentIds = this.getParentIds(entity);
        entity.setParentIds(parentIds);
        this.save(entity);
        //添加默认按钮
        if ("3".equals(String.valueOf(entity.getType())) && flag) {
//            Map<String,Object> propJsonMap= JSONUtil.StringToMap(entity.getPropertyJson());
//            if(propJsonMap!=null){
//                VisualdevEntity visualdevEntity =visualdevService.getInfo(propJsonMap.get("moduleId").toString());
//                //去除模板中的CREATOR_TIME
//                visualdevEntity= VisualUtil.delFKey(visualdevEntity);
//                if(visualdevEntity!=null){
//                    List<BtnData> btnData =new ArrayList<>();
//                    Map<String,Object> column=JSONUtil.StringToMap(visualdevEntity.getColumnData());
//                    if(column.get("columnBtnsList")!=null){
//                        btnData.addAll(JSONUtil.getJsonToList(JSONUtil.getJsonToListMap(column.get("columnBtnsList").toString()),BtnData.class));
//                    }
//                    if(column.get("btnsList")!=null){
//                        btnData.addAll(JSONUtil.getJsonToList(JSONUtil.getJsonToListMap(column.get("btnsList").toString()),BtnData.class));
//                    }
//                    if(btnData.size()>0){
//                        for(BtnData btn:btnData){
//                            ModuleButtonEntity moduleButtonEntity=new ModuleButtonEntity();
//                            moduleButtonEntity.setId(RandomUtil.uuId());
//                            moduleButtonEntity.setParentId("-1");
//                            moduleButtonEntity.setFullName(btn.getLabel());
//                            moduleButtonEntity.setEnCode("btn_"+btn.getValue());
//                            moduleButtonEntity.setSortCode(0L);
//                            moduleButtonEntity.setModuleId(entity.getId());
//                            moduleButtonEntity.setEnabledMark(1);
//                            moduleButtonEntity.setIcon(btn.getIcon());
//                            moduleButtonService.save(moduleButtonEntity);
//                        }
//                    }
//                    List<IndexGridField6Model> indexGridField6Models =new ArrayList<>();
//                    if(column.get("columnList")!=null){
//                        indexGridField6Models.addAll(JSONUtil.getJsonToList(JSONUtil.getJsonToListMap(column.get("columnList").toString()),IndexGridField6Model.class));
//                       if(indexGridField6Models.size()>0){
//                           for(IndexGridField6Model field6Model:indexGridField6Models){
//                               ModuleColumnEntity moduleColumnEntity=new ModuleColumnEntity();
//                               moduleColumnEntity.setId(RandomUtil.uuId());
//                               moduleColumnEntity.setParentId("-1");
//                               moduleColumnEntity.setFullName(field6Model.getLabel());
//                               moduleColumnEntity.setEnCode(field6Model.getProp());
//                               moduleColumnEntity.setSortCode(0L);
//                               moduleColumnEntity.setModuleId(entity.getId());
//                               moduleColumnEntity.setEnabledMark(1);
//                               moduleColumnService.save(moduleColumnEntity);
//                           }
//                       }
//                    }
//                }
//            }
        } else if ("4".equals(String.valueOf(entity.getType())) && flag) {
            for (int i = 0; i < 3; i++) {
                String fullName = "新增";
                String value = "add";
                String icon = "el-icon-plus";
                if (i == 1) {
                    fullName = "编辑";
                    value = "edit";
                    icon = "el-icon-edit";
                }
                if (i == 2) {
                    fullName = "删除";
                    value = "remove";
                    icon = "el-icon-delete";
                }
                ModuleButtonEntity moduleButtonEntity = new ModuleButtonEntity();
                moduleButtonEntity.setId(RandomUtil.uuId());
                moduleButtonEntity.setParentId("-1");
                moduleButtonEntity.setFullName(fullName);
                moduleButtonEntity.setEnCode("btn_" + value);
                moduleButtonEntity.setSortCode(0L);
                moduleButtonEntity.setModuleId(entity.getId());
                moduleButtonEntity.setEnabledMark(1);
                moduleButtonEntity.setIcon(icon);
                moduleButtonService.save(moduleButtonEntity);
            }

        }
    }

    @Override
    @CacheEvict(value = "ModuleCache", allEntries = true)
    public boolean update(String id, ModuleEntity entity) {
        entity.setId(id);
        entity.setLastModifyTime(DateUtil.getNowDate());
        String parentIds = this.getParentIds(entity);
        entity.setParentIds(parentIds);
        return this.updateById(entity);
    }

    @Override
    public DownloadVO exportData(String id) {
        //获取信息转model
        ModuleEntity moduleEntity = getInfo(id);
        List<ModuleButtonEntity> buttonServiceList = buttonService.getList(id);
        List<ModuleColumnEntity> columnServiceList = columnService.getList(id);
        List<ModuleDataAuthorizeSchemeEntity> schemeServiceList = schemeService.getList(id);
        List<ModuleDataAuthorizeEntity> authorizeServiceList = authorizeService.getList(id);
        List<ModuleFormEntity> formList = formService.getList(id);
        ModuleExportModel exportModel = new ModuleExportModel();
        exportModel.setModuleEntity(moduleEntity);
        exportModel.setButtonEntityList(buttonServiceList);
        exportModel.setColumnEntityList(columnServiceList);
        exportModel.setFormEntityList(formList);
        exportModel.setSchemeEntityList(schemeServiceList);
        exportModel.setAuthorizeEntityList(authorizeServiceList);
        //导出文件
        DownloadVO downloadVO = fileExport.exportFile(exportModel, configValueUtil.getTemporaryFilePath(), moduleEntity.getFullName(), ModuleTypeEnum.SYSTEM_MODULE.getTableName());
        return downloadVO;
    }

    @Override
    @DSTransactional
    @CacheEvict(value = "ModuleCache", allEntries = true)
    public boolean importData(ModuleExportModel exportModel) throws DataException {
        try {
            boolean isExists = true;
            ModuleEntity moduleEntity = exportModel.getModuleEntity();
            //开始导入
            if (getInfo(moduleEntity.getId()) == null) {
                isExists = false;
                create(moduleEntity);
            }
            //按钮
            List<ModuleButtonEntity> buttonEntityList = JsonUtil.getJsonToList(exportModel.getButtonEntityList(), ModuleButtonEntity.class);
            for (ModuleButtonEntity buttonEntity : buttonEntityList) {
                if (buttonService.getInfo(buttonEntity.getId()) == null && !buttonService.isExistByFullName(buttonEntity.getModuleId(), buttonEntity.getFullName(), buttonEntity.getId()) && !buttonService.isExistByEnCode(buttonEntity.getModuleId(), buttonEntity.getEnCode(), buttonEntity.getId())) {
                    isExists = false;
                    buttonService.create(buttonEntity);
                }
            }
            //列表
            List<ModuleColumnEntity> columnEntityList = JsonUtil.getJsonToList(exportModel.getColumnEntityList(), ModuleColumnEntity.class);
            for (ModuleColumnEntity columnEntity : columnEntityList) {
                if (columnService.getInfo(columnEntity.getId()) == null && !columnService.isExistByFullName(columnEntity.getModuleId(), columnEntity.getFullName(), columnEntity.getId()) && !columnService.isExistByEnCode(columnEntity.getModuleId(), columnEntity.getEnCode(), columnEntity.getId())) {
                    isExists = false;
                    columnService.create(columnEntity);
                }
            }
            //表单
            List<ModuleFormEntity> formEntityList = JsonUtil.getJsonToList(exportModel.getFormEntityList(), ModuleFormEntity.class);
            for (ModuleFormEntity formEntity : formEntityList) {
                if (formService.getInfo(formEntity.getId()) == null && !formService.isExistByFullName(formEntity.getModuleId(), formEntity.getFullName(), formEntity.getId()) && !formService.isExistByEnCode(formEntity.getModuleId(), formEntity.getEnCode(), formEntity.getId())) {
                    isExists = false;
                    formService.create(formEntity);
                }
            }
            //数据权限方案
            List<ModuleDataAuthorizeSchemeEntity> schemeEntityList = JsonUtil.getJsonToList(exportModel.getSchemeEntityList(), ModuleDataAuthorizeSchemeEntity.class);
            for (ModuleDataAuthorizeSchemeEntity schemeEntity : schemeEntityList) {
                if (schemeService.getInfo(schemeEntity.getId()) == null) {
                    isExists = false;
                    schemeService.create(schemeEntity);
                }
            }
            //数据权限
            List<ModuleDataAuthorizeEntity> authorizeEntityList = JsonUtil.getJsonToList(exportModel.getAuthorizeEntityList(), ModuleDataAuthorizeEntity.class);
            for (ModuleDataAuthorizeEntity authorizeEntity : authorizeEntityList) {
                if (authorizeService.getInfo(authorizeEntity.getId()) == null) {
                    isExists = false;
                    authorizeService.create(authorizeEntity);
                }
            }
            return isExists;
        } catch (Exception e) {
            //手动回滚事务
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            throw new DataException(e.getMessage());
        }
    }

    @Override
    @Cacheable(value = "ModuleCache", keyGenerator = "cacheKeyGenerator", unless = "#result.size()==0")
    public List<ModuleEntity> getModuleList(String visualId) {
        QueryWrapper<ModuleEntity> moduleWrapper = new QueryWrapper<>();
        moduleWrapper.lambda().eq(ModuleEntity::getModuleId, visualId);
        return this.list(moduleWrapper);
    }

    @Override
    public List<ModuleEntity> getModuleListByProperty(String property) {
        QueryWrapper<ModuleEntity> moduleWrapper = new QueryWrapper<>();
        moduleWrapper.lambda().like(ModuleEntity::getPropertyJson, property);
        return this.list(moduleWrapper);
    }
    /**
     * 获取父级组织id Tree
     * 例如：1,2,3
     *
     * @param entity
     * @return
     */
    @Override
    public String getParentIds(ModuleEntity entity) {
        List<String> list = new ArrayList<>();
        getIdTree(entity.getParentId(), list);
        // 倒叙排放
        Collections.reverse(list);
        StringBuffer moduleIdTree = new StringBuffer();
        for (String organizeParentId : list) {
            moduleIdTree.append("," + organizeParentId);
        }
        moduleIdTree.append("," + entity.getId());

        String parentIdTree = moduleIdTree.toString();
        if (StringUtils.isNotEmpty(parentIdTree)) {
            parentIdTree = parentIdTree.replaceFirst(",", "");
        }
        return parentIdTree;
    }
    public void getIdTree(String organizeId, List<String> parentIdList) {
        ModuleEntity entity = getInfo(organizeId);
        if (entity != null) {
            parentIdList.add(entity.getId());
            if (StringUtils.isNotEmpty(entity.getParentId())) {
                getIdTree(entity.getParentId(), parentIdList);
            }
        }
    }


}
