package com.bringspring.system.external.constant;


/**
 * 企业微信相关系统配置常量类
 */
public interface WxCpSysConfigConsts {
    /**
     * 企业微信信息
     */
    String WECOM_KEY_NAME = "weCom";
    /**
     * 不同属性内容分割
     */
    String TARGET_CHAR = "/";
    /**
     * 相同属性数组分割
     */
    String REGEX_CHAR = ",";

    /**
     * 系统树顶级节点
     */
    String TOP_SYS_PID = "-1";

    /**
     * 顶级节点时，企业微信的父id为0
     */
    Long TOP_PID = 0L;

    /**
     * 系统删除，执行同步
     */
    String SYS_DELETE = "sys_delete";

    /**
     * 企业微信删除事件通知，不执行同步
     */
    String WXCP_DELETE = "wxcp_delete";

    /**
     * 新增成员事件
     * 该事件会回调给通讯录同步助手，代开发自建应用以及上游企业共享的应用
     * 【重要】对于2022年8月15号后通讯录助手新配置或修改的回调url，成员属性只回调UserID/Department两个字段
     * 说明： 由通讯录同步助手通过api发起的更新成员触发的事件不回调给通讯录同步助手应用。
     */
    String CREATE_USER = "create_user";
    /**
     * 更新成员事件
     * 该事件会回调给通讯录同步助手，代开发自建应用以及上游企业共享的应用
     * 【重要】对于2022年8月15号后通讯录助手新配置或修改的回调url，该事件只会在成员所属部门变更或UserId变更的情况下触发，并且成员属性只回调UserId/Department/NewUserId三个字段
     * 说明： 由通讯录同步助手通过api发起的更新成员触发的事件不回调给通讯录同步助手应用。
     */
    String UPDATE_USER = "update_user";
    /**
     * 删除成员事件
     * 该事件会回调给通讯录同步助手，代开发自建应用以及上游企业共享的应用。
     * 说明： 由通讯录同步助手通过api发起的删除成员触发的事件不回调给通讯录同步助手应用。
     */
    String DELETE_USER = "delete_user";
    /**
     * 新增部门事件
     * 该事件会回调给通讯录同步助手，代开发自建应用以及上游企业共享的应用。
     * 【重要】对于2022年8月15号后通讯录助手新配置或修改的回调url，部门属性只回调Id/ParentId两个字段
     * 说明： 由通讯录同步助手通过api发起的新增部门触发的事件不回调给通讯录同步助手应用。
     */
    String CREATE_PARTY = "create_party";
    /**
     * 更新部门事件
     * 该事件会回调给通讯录同步助手，代开发自建应用以及上游企业共享的应用
     * 【重要】对于2022年8月15号后通讯录助手新配置或修改的回调url，该事件只会在ParentId变更时触发，并且部门属性只回调Id/ParentId两个字段
     * 说明： 由通讯录同步助手通过api发起的更新部门触发的事件不回调给通讯录同步助手应用。
     */
    String UPDATE_PARTY = "update_party";
    /**
     * 删除部门事件
     * 该事件会回调给通讯录同步助手，代开发自建应用以及上游企业共享的应用。
     * 说明： 由通讯录同步助手通过api发起的删除部门触发的事件不回调给通讯录同步助手应用。
     */
    String DELETE_PARTY = "delete_party";
}
