package com.bringspring.system.external.handler;

import com.bringspring.common.util.JsonUtil;
import com.bringspring.system.external.bean.WxCpDepartTreeNode;
import com.bringspring.system.external.builder.TextBuilder;
import com.bringspring.system.external.service.WxCpCorpService;
import com.bringspring.system.external.util.JsonUtils;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.session.WxSessionManager;
import me.chanjar.weixin.cp.api.WxCpService;
import me.chanjar.weixin.cp.bean.WxCpDepart;
import me.chanjar.weixin.cp.bean.WxCpUser;
import me.chanjar.weixin.cp.bean.message.WxCpXmlMessage;
import me.chanjar.weixin.cp.bean.message.WxCpXmlOutMessage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import static me.chanjar.weixin.cp.constant.WxCpConsts.ContactChangeType.*;

/**
 * 通讯录变更事件处理器.
 *
 * @author <a href="https://github.com/binarywang">Binary Wang</a>
 */
@Component
public class ContactChangeHandler extends AbstractHandler {
    @Autowired
    private WxCpCorpService wxCpCorpService;

    @Override
    public WxCpXmlOutMessage handle(WxCpXmlMessage wxMessage, Map<String, Object> context, WxCpService cpService,
                                    WxSessionManager sessionManager) {
        String content = "收到通讯录变更事件，内容：" + JsonUtils.toJson(wxMessage);
        logger.info(content);
        String changeType = wxMessage.getChangeType();
        try {
            String corpId = cpService.getWxCpConfigStorage().getCorpId();
            // 新增部门事件 更新部门事件
            if (CREATE_PARTY.equals(changeType) || UPDATE_PARTY.equals(changeType)) {
                String deptid = wxMessage.getId();
                WxCpDepart wxCpDepart = cpService.getDepartmentService().get(Long.valueOf(deptid));
                WxCpDepartTreeNode wxCpDepartTreeNode = JsonUtil.getJsonToBean(wxCpDepart, WxCpDepartTreeNode.class);
                List<WxCpDepartTreeNode> wxCpDepartTreeNodes = new ArrayList<>();
                wxCpDepartTreeNodes.add(wxCpDepartTreeNode);
                /**
                 * 保存到本地
                 */
                wxCpCorpService.saveOrUpdateOrganizeList(wxCpDepartTreeNodes, corpId, null);
            }
            // 删除部门事件
            if (DELETE_PARTY.equals(changeType)) {
                /**
                 * 删除本地部门信息
                 */
                String deptid = wxMessage.getId();
                wxCpCorpService.deleteOrganize(corpId, deptid);
            }
            // 新增成员事件 更新成员事件
            if (CREATE_USER.equals(changeType) || UPDATE_USER.equals(changeType)) {
                String userId = wxMessage.getUserId();
                WxCpUser wxCpUser = cpService.getUserService().getById(userId);
                List<WxCpUser> users = new ArrayList<>();
                users.add(wxCpUser);
                /**
                 * 保存到本地
                 */
                wxCpCorpService.saveOrUpdateUserList(users, cpService);
            }
            // 删除成员事件
            if (DELETE_USER.equals(changeType)) {
                /**
                 * 删除本地用户信息
                 */
                String userId = wxMessage.getUserId();
                wxCpCorpService.deleteUser(corpId, userId);
            }
        } catch (WxErrorException e) {
            e.printStackTrace();
        }

        return new TextBuilder().build(content, wxMessage, cpService);
    }

}
