package com.bringspring.system.message.model.message;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotBlank;
import lombok.Data;

/**
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2021/3/12 15:31
 */
@Data
public class NoticeCrForm {
    @Schema(description = "内容")
    private String bodyText;
    @NotBlank(message = "必填")
    @Schema(description = "标题")
    private String title;
    @Schema(description = "接收人")
    private String toUserIds;
    @Schema(description = "附件")
    private String files;
    /**
     * 发送消息类型   用户user   部门department    角色role   岗位position
     */
    private String sendType;

    private String sendRange;

    /**
     * 存储用户，部门，角色id
     */
    private String sendId;

    /**
     * 今创公告类型
     */
    private String noticeTypeJC;
}
