package com.bringspring.system.msgcenter.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.Size;
import lombok.Data;

@Data
public class TaskMsg {

    /**
     * 业务系统
     **/
    @NotBlank(message = "业务系统不能为空")
    @Size(max = 200, message = "业务系统最多为200个字符！")
    @JsonProperty("taskCode")
    private String taskCode;

    /**
     * 发送配置
     **/
    @NotBlank(message = "发送配置不能为空")
    @Size(max = 200, message = "发送配置最多为200个字符！")
    @JsonProperty("sendCode")
    private String sendCode;

    /**
     * 场景关键词
     **/
    @JsonProperty("businessKey")
    private BusinessKeys businessKey;

    /**
     * 自定义参数
     **/
    @JsonProperty("customKey")
    private CustomKeysLink customKey;

    /**
     * 接收者 类型
     **/
    @JsonProperty("toType")
    private String toType;

    /**
     * 接收者
     **/
    @JsonProperty("toUserIds")
    private String toUserIds;

    /**
     * 接收者的部门
     **/
    @JsonProperty("toDeptIds")
    private String toDeptIds;

    /**
     * 描述
     **/
    @JsonProperty("description")
    private String description;

    /**
     * 渠道消息未发出，自动重发最大限制次数
     **/
    @Size(max = 100, message = "重发尝试次数最大100次")
    @JsonProperty("autoAgainMaxNum")
    private Integer autoAgainMaxNum;
}
