package com.bringspring.system.msgcenter.model.mctaskmsg;


import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.Size;
import lombok.Data;


/**
 * @版本： V1.0.0
 * @版权： 荣科科技股份有限公司
 * @作者： RKKJ开发平台组
 * @日期： 2024-06-14
 */
@Data
public class McTaskMsgCrForm {

    /**
     * 业务系统
     **/
    @NotBlank(message = "业务系统不能为空")
    @Size(max = 200, message = "业务系统最多为200个字符！")
    @JsonProperty("taskCode")
    private String taskCode;

    /**
     * 发送配置
     **/
    @NotBlank(message = "发送配置不能为空")
    @Size(max = 200, message = "发送配置最多为200个字符！")
    @JsonProperty("sendCode")
    private String sendCode;

    /**
     * 场景关键词
     **/
    @NotBlank(message = "发送配置不能为空")
    @JsonProperty("businessKey")
    private String businessKey;

    /**
     * 接收者 类型
     **/
    @JsonProperty("toType")
    private String toType;

    /**
     * 接收者
     **/
    @JsonProperty("toUserIds")
    private String toUserIds;

    /**
     * 接收者的部门
     **/
    @JsonProperty("toDeptIds")
    private String toDeptIds;

    /**
     * 自定义参数
     **/
    @JsonProperty("customKey")
    private String customKey;

    /**
     * 渠道消息未发出，自动重发最大限制次数
     **/
    @JsonProperty("autoAgainMaxNum")
    private Integer autoAgainMaxNum;

    /**
     * 状态
     **/
    @JsonProperty("enabledMark")
    private String enabledMark;

    /**
     * 描述
     **/
    @JsonProperty("description")
    private String description;

    /**
     * 创建时间
     **/
    @JsonProperty("creatorTime")
    private String creatorTime;

    /**
     * 创建人
     **/
    @JsonProperty("creatorUserId")
    private String creatorUserId;

    /**
     * 修改时间
     **/
    @JsonProperty("lastModifyTime")
    private String lastModifyTime;

    /**
     * 修改人
     **/
    @JsonProperty("lastModifyUserId")
    private String lastModifyUserId;


}