package com.bringspring.system.msgcenter.service.chain;

import java.util.Arrays;
import java.util.List;

/**
 * 多处理链的类型
 * 定义渠道类型枚举
 */
public enum ChainChannelType {
    SYS_MSG(Arrays.asList(
            BlacklistFilter.class,
            ReceiveUserFilter.class
    )),
    SMS(Arrays.asList(
            BlacklistFilter.class,
            ReceiveUserFilter.class
    )),
    DING(Arrays.asList(
            BlacklistFilter.class,
            ReceiveUserFilter.class,
            ThirdInfoFilter.class,
            ThirdObjectIdFilter.class
    )),
    WECHAT(Arrays.asList(
            BlacklistFilter.class,
            ReceiveUserFilter.class,
            ThirdInfoFilter.class,
            ThirdObjectIdFilter.class
    )),
    WEBHOOK(Arrays.asList(
            BlacklistFilter.class,
            ReceiveUserFilter.class
    )),
    DEFAULT(Arrays.asList(
            BlacklistFilter.class,
            ReceiveUserFilter.class
    )),
    NON_SYS_USER(Arrays.asList(
            BlacklistFilter.class,
            ReceiveUserFilter.class
    ));

    private final List<Class<? extends FilterProcessor>> processors;

    ChainChannelType(List<Class<? extends FilterProcessor>> processors) {
        this.processors = processors;
    }

    public List<Class<? extends FilterProcessor>> getProcessors() {
        return processors;
    }
}
