package com.bringspring.system.msgcenter.util;

import com.alibaba.fastjson.JSONObject;
import com.bringspring.system.msgcenter.model.message.MyEmailModel;

import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import java.io.UnsupportedEncodingException;
import java.util.Properties;

/**
 * 邮件类
 *
 * @版本： V1.0.0
 * @版权： 荣科科技股份有限公司
 * @作者： RKKJ开发平台组
 * @日期： 2021/4/20 14:52
 */
public class EmailUtil {
    // 添加私有构造函数
    private EmailUtil() {
        throw new AssertionError("工具类不允许实例化");
    }

    public static boolean isEmail(String email) {
        // 修正后的正则表达式
        String EMAIL_REGEX = "^[\\w.+_-]+@[\\w-]+(\\.[\\w-]{2,})+$";
        return email.matches(EMAIL_REGEX);
    }

    public static JSONObject sendMail(MyEmailModel emailModel) {
        JSONObject retMsg = new JSONObject();
        String from = emailModel.getEmailAccount();
        String to = emailModel.getEmailToUsers();

        Properties props = System.getProperties();
        props.setProperty("mail.smtp.host", emailModel.getEmailSmtpHost());
        props.setProperty("mail.smtp.auth", "true");
        props.setProperty("mail.smtp.ssl.enable", emailModel.getEmailSsl());
        props.setProperty("mail.transport.protocol", "smtp");

        if ("587".equals(emailModel.getEmailSmtpPort())) {
            props.put("mail.smtp.starttls.enable", "true");
        }

        Session session = Session.getInstance(props);
        session.setDebug(true);
        try {
            MimeMessage message = new MimeMessage(session);
            message.setFrom(new InternetAddress(from, emailModel.getEmailSenderName(), "UTF-8"));
            InternetAddress[] sendTo = InternetAddress.parse(to);
            message.setRecipients(MimeMessage.RecipientType.TO, sendTo);
            message.setSubject(emailModel.getEmailTitle());
            message.setContent(emailModel.getEmailContent(), "text/html;charset=utf-8");

            Transport transport = session.getTransport();
            int port = Integer.parseInt(emailModel.getEmailSmtpPort());
            transport.connect(emailModel.getEmailSmtpHost(), port,
                    emailModel.getEmailAccount(), emailModel.getEmailPassword());
            transport.sendMessage(message, sendTo);
            transport.close();

            retMsg.put("code", true);
            retMsg.put("error", "");
        } catch (MessagingException | UnsupportedEncodingException | NumberFormatException e) {
            retMsg.put("code", false);
            retMsg.put("error", e.getMessage());  // 更简洁的错误信息
        }
        return retMsg;
    }
}

