package com.bringspring.system.permission.aop;

import cn.dev33.satoken.context.SaHolder;
import cn.dev33.satoken.router.SaRouter;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.database.data.DataSourceContextHolder;
import com.bringspring.common.database.util.NotTenantPluginHolder;
import com.bringspring.common.database.util.TenantDataSourceUtil;
import com.bringspring.common.properties.GatewayWhite;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.auth.util.UserProvider;
import com.bringspring.common.util.TenantHolder;
import lombok.extern.slf4j.Slf4j;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

/**
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2021/3/15 17:12
 */
@Slf4j
@Aspect
@Component
@Order(1)
public class DataSourceBindAspect {

    @Autowired
    UserProvider userProvider;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private GatewayWhite gatewayWhite;

    @Pointcut("((execution(* com.bringspring.*.controller.*.*(..))) " +
            "&& !execution(* com.bringspring.oauth.controller.LoginController.Login(..)))" +
            "|| execution(* com.bringspring.system.message.websocket.WebSocket.*(..))")
    public void bindDataSource() {

    }

    /**
     * NoDataSourceBind 不需要绑定数据库的注解
     *
     * @param pjp
     * @return
     * @throws Throwable
     */
    @Around("bindDataSource() && !@annotation(com.bringspring.common.base.NoDataSourceBind)")
    public Object doAroundService(ProceedingJoinPoint pjp) throws Throwable {
        if (configValueUtil.isMultiTenancy()) {
            if(StringUtils.isEmpty(TenantHolder.getDatasourceId())){
                String url = null;
                try{
                    url = SaHolder.getRequest().getRequestPath();
                }catch (Exception e){}
                if(url != null){
                    // 白名单接口不传Token, 不检查租户信息, 要查询数据库需要手动切换租户
                    boolean isWhiteUrl = SaRouter.isMatch(gatewayWhite.excludeUrl, url) || SaRouter.isMatch(gatewayWhite.whiteUrl, url);
                    if(!isWhiteUrl) {
                        UserInfo userInfo = UserProvider.getUser();
                        log.error("未检测到租户信息, Tenant: {}, URL: {}, TOKEN: {}", userInfo.getTenantId(), url, userInfo.getToken());
                        return null;
                    }
                }
            }
            return pjp.proceed();
//            if ("true".equals(DataSourceContextHolder.getDatasourceName())) {
//                return pjp.proceed();
//            }
//            UserInfo userInfo = userProvider.get();
//            if (StringUtils.isNotEmpty(userInfo.getTenantDbConnectionString())) {
//                DataSourceContextHolder.setDatasource(userInfo.getTenantId(), userInfo.getTenantDbConnectionString());
//                Object obj = pjp.proceed();
//                return obj;
//            }
//            log.error("租户" + userInfo.getTenantId() + "数据库不存在");
//            return null;
        }
        Object obj = pjp.proceed();
        return obj;
    }

    /**
     * NoDataSourceBind 不需要绑定数据库的注解 加入不切租户库标记
     *
     * @param pjp
     * @return
     * @throws Throwable
     */
    @Around("bindDataSource() && @annotation(com.bringspring.common.base.NoDataSourceBind)")
    public Object doAroundService2(ProceedingJoinPoint pjp) throws Throwable {
        try{
            NotTenantPluginHolder.setNotSwitchAlwaysFlag();
            //Filter中提前设置租户信息, 不需要切库的方法进行清除切库
            TenantDataSourceUtil.clearLocalTenantInfo();
            return pjp.proceed();
        }finally {
            NotTenantPluginHolder.clearNotSwitchAlwaysFlag();
        }
    }
}
