package com.bringspring.system.permission.model.organize;

import com.alibaba.fastjson.annotation.JSONField;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotBlank;
import lombok.Data;

/**
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2021/3/12 15:31
 */
@Data
public class OrganizeDepartCrForm {

    @JSONField(name="managerId")
    private String managerId;
    @NotBlank(message = "必填")
    @Schema(description = "上级ID")
    private String parentId;
    @NotBlank(message = "必填")
    @Schema(description = "部门名称")
    private String fullName;
    @Schema(description = "部门简称")
    private String shortName;
    @Schema(description = "部门编码")
    private String enCode;
    @Schema(description = "状态")
    private int enabledMark;
    private String description;
    @Schema(description = "排序")
    private Long sortCode;
}
