package com.bringspring.system.permission.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.bringspring.system.permission.entity.PermissionEntityBase;
import com.bringspring.system.permission.entity.UserRelationEntity;
import com.bringspring.system.permission.model.permission.PermissionModel;
import com.bringspring.system.permission.model.userrelation.UserRelationForm;

import java.util.List;

/**
 * 用户关系
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2017年9月26日 上午9:18
 */
public interface UserRelationService extends IService<UserRelationEntity> {

    /**
     * 根据用户主键获取列表
     *
     * @param userId 用户主键
     * @return
     */
    List<UserRelationEntity> getListByUserId(String userId);

    /**
     * 获取用户关联数据集合（组织、角色、岗位）
     *
     * @param userId     用户ID
     * @param objectType 关联对象类型
     *                   PermissionConst.ORGANIZE 组织
     *                   PermissionConst.Role 角色
     *                   PermissionConst.Position 角色
     * @return
     */
    List<UserRelationEntity> getListByUserIdAndObjType(String userId, String objectType);

    /**
     * 获取用户关联数据集合（组织、角色、岗位）
     *
     * @param userIds     用户ID
     * @param objectType 关联对象类型
     *                   PermissionConst.ORGANIZE 组织
     *                   PermissionConst.Role 角色
     *                   PermissionConst.Position 角色
     * @return
     */
    List<UserRelationEntity> getListByUserIdAndObjType(List<String> userIds, String objectType);

    /**
     * 根据用户主键获取关联对象列表集合
     *
     * @param userIdList 用户主键集合
     * @return
     */
    List<UserRelationEntity> getListByUserIdAll(List<String> userIdList);

    /**
     * 根据关联对象主键获取列表
     *
     * @param objectId 对象主键
     * @return
     */
    List<UserRelationEntity> getListByObjectId(String objectId);

    /**
     * 根据关联对象主键及对象类型获取列表
     *
     * @param objectId   对象主键
     * @param objectType 关联对象类型
     *                   PermissionConst.ORGANIZE 组织
     *                   PermissionConst.Role 角色
     *                   PermissionConst.Position 角色
     * @return
     */
    List<UserRelationEntity> getListByObjectId(String objectId, String objectType);

    /**
     * 根据关联对象主键及对象类型获取列表
     *
     * @param userId     用户主键
     * @param objectId   对象主键
     * @param objectType 关联对象类型
     *                   PermissionConst.ORGANIZE 组织
     *                   PermissionConst.Role 角色
     *                   PermissionConst.Position 角色
     * @return
     */
    List<UserRelationEntity> getListByUserIdAndObjectId(String userId, String objectId, String objectType);

    /**
     * 根据关联对象主键及对象类型获取列表
     *
     * @param userIds     用户主键
     * @param objectId   对象主键
     * @param objectType 关联对象类型
     *                   PermissionConst.ORGANIZE 组织
     *                   PermissionConst.Role 角色
     *                   PermissionConst.Position 角色
     * @return
     */
    List<UserRelationEntity> getListByUserIdAndObjectId(List<String> userIds, String objectId, String objectType);

    /**
     * 根据对象主键获取列表
     *
     * @param objectIdList 关联对象主键集合
     * @return
     */
    List<UserRelationEntity> getListByObjectIdAll(List<String> objectIdList);

    /**
     * 根据对象主键获取列表
     *
     * @param userIds     用户主键
     * @param objectIds 关联对象主键集合
     * @param objectTypes 关联对象类型集合
     * @return
     */
    List<UserRelationEntity> getListByJointKey(List<String> userIds, List<String> objectIds, List<String> objectTypes);

    /**
     * 根据关联对象主键删除数据
     *
     * @param objectId 关联对象主键
     * @return
     */
    void deleteAllByObjId(String objectId);

    /**
     * 删除用户所有的关联关系
     *
     * @param userId 用户ID
     */
    void deleteAllByUserId(String userId);

    /**
     * 用户关联信息
     *
     * @param id 主键值
     * @return
     */
    UserRelationEntity getInfo(String id);

    /**
     * 创建
     *
     * @param objectId 对象主键
     * @param entitys  实体对象
     */
    void save(String objectId, List<UserRelationEntity> entitys);

    /**
     * 创建用户和所属区域的关系
     *
     * @param address
     * @param userId
     * @return
     */
    UserRelationEntity createAuthorizeAddress(List<String> address, List<String> userId);

    /**
     * 判断当前用户是否有当前地区权限
     */
    Boolean judgeAuthorize(List<String> address, String userId);

    /**
     * 创建
     *
     * @param list 实体对象
     */
    void save(List<UserRelationEntity> list);

    /**
     * 删除
     *
     * @param ids 主键值
     */
    void delete(String[] ids);

    /**
     * 添加岗位或角色成员
     */
    void saveObjectId(String objectId, UserRelationForm userRelationForm);

    void roleSaveByUserIds(String roleId, List<String> userIds);

    /**
     * 部门管理-部门成员 操作
     *
     * @param objectId
     * @param userIds
     */
    void organizeSaveByUserIds(String objectId, List<String> userIds);

    /**
     * 获取用户组织/岗位/角色集合
     *
     * @param userId
     * @return
     */
    List<UserRelationEntity> getListByObjectType(String userId, String objectType);

    /**
     * 获取用户所有组织关系
     *
     * @param userId 用户id
     * @return 组织关系集合
     */
    List<UserRelationEntity> getAllOrgRelationByUserId(String userId);

    /**
     * 获取个人信息页面用户组织/岗位/角色集合
     *
     * @param objectType 归属类型
     */
    List<PermissionModel> getObjectVoList(String objectType);

    /**
     * 根据用户id获取用户当前组织底下所有岗位
     *
     * @param userId     用户id
     * @param objectType 归属类型
     */
    List<PermissionModel> getObjectVoListById(String userId, String objectType);

    /**
     * 判断岗位/角色与用户是否存在关联关系
     *
     * @param objectType 类型
     * @param objectId   岗位/角色ID
     * @return 存在判断
     */
    Boolean existByObjectId(String objectType, String objectId);

    /**
     * 设置返回模型
     *
     * @param permissionList
     * @param majorId
     */
    public <T extends PermissionEntityBase> List<PermissionModel> setModel(List<T> permissionList, String majorId);

    /**
     * 根据角色Id获取该角色所属组织下所有人员
     *
     * @param roleId 角色ID
     */
    List<UserRelationEntity> getListByRoleId(String roleId);

    /**
     * 获取用户角色id,查询到与该角色对应的关联人员
     *
     * @param roleId 角色ID
     */
    List<UserRelationEntity> getListByRoleIds(String roleId);


    /**
     * 根据用户id获取关系
     *
     * @param userId     用户主键
     * @param objectType 类型
     * @return
     */
    List<UserRelationEntity> getListByUserId(String userId, String objectType);

    /**
     * 判断组织下有哪些人
     *
     * @param orgIdList 组织id
     * @return
     */
    List<UserRelationEntity> getListByOrgId(List<String> orgIdList);

    /**
     * 根据用户id获取该用户所属组织的name信息
     *
     * @param id 用户id
     * @return
     */
    String getAllOrganizeNameInfoById(String id);
}
